/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.wizards;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.wizards.BaseWizard;
import com.aptana.ide.documentation.DocumentationPlugin;
import com.aptana.ide.wizards.Messages;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.osgi.framework.Bundle;

public class WebProjectWizard
extends BaseWizard
implements IExecutableExtension {
    public static final String ID = "com.aptana.ide.wizards.WebProjectWizard";
    private static final String INDEX_PATH = "/project/index.html";
    private IFile indexFile;
    private IConfigurationElement fConfigElement;
    private IWorkbench fWorkbench;

    public WebProjectWizard() {
        super.setIncludeProjectPage(true);
        super.setWindowTitle(Messages.WebProjectWizard_WebProjectWizard);
        this.indexFile = null;
    }

    public String getID() {
        return ID;
    }

    protected IProjectDescription createProjectDescription(String name, IPath path) {
        IProjectDescription description = super.createProjectDescription(name, path);
        description.setNatureIds(new String[]{"com.aptana.ide.project.nature.web"});
        return description;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.setDefaultPageImageDescriptor(DocumentationPlugin.getImageDescriptor("icons/web_project_wiz.png"));
    }

    public IFile getFileToOpenOnFinish() {
        if (this.isCreatingHostedSite()) {
            return null;
        }
        if (this.indexFile != null && this.indexFile.exists()) {
            return this.indexFile;
        }
        return null;
    }

    public String[] getFileNamesToSelect() {
        return new String[]{"index.html", "index.htm"};
    }

    public void finishProjectCreation() {
        URL indexUrl;
        Bundle bundle;
        final IProject project = super.getCreatedProject();
        this.indexFile = project.getFile("index.html");
        if (this.indexFile != null && !this.indexFile.exists() && (bundle = Platform.getBundle((String)"com.aptana.ide.documentation")) != null && (indexUrl = bundle.getEntry(INDEX_PATH)) != null) {
            try {
                indexUrl = FileLocator.toFileURL((URL)indexUrl);
                this.indexFile.create(indexUrl.openStream(), true, null);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)DocumentationPlugin.getDefault(), (String)"Error creating index.html for new web project", (Throwable)e);
            }
        }
        UIJob uiJob = new UIJob("Show Project view"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)WebProjectWizard.this.fConfigElement);
                try {
                    CoreUIUtils.showView((String)"com.aptana.ide.core.ui.AptanaNavigator");
                }
                catch (PartInitException pe) {
                    IdeLog.logInfo((Plugin)DocumentationPlugin.getDefault(), (String)pe.getMessage(), (Throwable)pe);
                }
                BasicNewResourceWizard.selectAndReveal((IResource)project, (IWorkbenchWindow)WebProjectWizard.this.fWorkbench.getActiveWorkbenchWindow());
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigElement = config;
    }
}

