/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.contentassist;

import com.aptana.ide.core.ui.contentassist.RegExMessages;
import com.aptana.ide.epl.Activator;
import java.util.ArrayList;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.contentassist.SubjectControlContextInformationValidator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.widgets.Shell;

public final class LoggingRegExContentAssistProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private IContextInformationValidator fValidator = new SubjectControlContextInformationValidator((IContentAssistProcessor)this);
    private final boolean fIsFind;

    public static SubjectControlContentAssistant createContentAssistant() {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(Activator.getDefault().getDialogSettings());
        LoggingRegExContentAssistProcessor processor = new LoggingRegExContentAssistProcessor(true);
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }

    public LoggingRegExContentAssistProcessor(boolean isFind) {
        this.fIsFind = isFind;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        throw new UnsupportedOperationException("ITextViewer not supported");
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        throw new UnsupportedOperationException("ITextViewer not supported");
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.fIsFind) {
            return new char[]{'\\', '[', '('};
        }
        return new char[]{'$'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        if (this.fIsFind) {
            return new ProposalComputer(contentAssistSubjectControl, documentOffset).computeFindProposals();
        }
        return new ProposalComputer(contentAssistSubjectControl, documentOffset).computeReplaceProposals();
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    private static class ProposalComputer {
        private final String fExpression;
        private final int fDocumentOffset;
        private final ArrayList fPriorityProposals;
        private final ArrayList fProposals;
        private final boolean fIsEscape;

        public ProposalComputer(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
            this.fExpression = contentAssistSubjectControl.getDocument().get();
            this.fDocumentOffset = documentOffset;
            this.fPriorityProposals = new ArrayList();
            this.fProposals = new ArrayList();
            boolean isEscape = false;
            int i = documentOffset - 1;
            while (i >= 0) {
                if (this.fExpression.charAt(i) != '\\') break;
                isEscape = !isEscape;
                --i;
            }
            this.fIsEscape = isEscape;
        }

        public ICompletionProposal[] computeFindProposals() {
            this.addBsProposal("\\t", RegExMessages.displayString_bs_t, RegExMessages.additionalInfo_bs_t);
            this.addBsProposal("\\v", RegExMessages.displayString_bs_v, RegExMessages.additionalInfo_bs_v);
            this.addBsProposal("\\n", RegExMessages.displayString_bs_n, RegExMessages.additionalInfo_bs_n);
            this.addBsProposal("\\r", RegExMessages.displayString_bs_r, RegExMessages.additionalInfo_bs_r);
            this.addBsProposal("\\f", RegExMessages.displayString_bs_f, RegExMessages.additionalInfo_bs_f);
            if (!this.fIsEscape) {
                this.addBracketProposal(".", 1, RegExMessages.displayString_dot, RegExMessages.additionalInfo_dot);
            }
            this.addBsProposal("\\d", RegExMessages.displayString_bs_d, RegExMessages.additionalInfo_bs_d);
            this.addBsProposal("\\D", RegExMessages.displayString_bs_D, RegExMessages.additionalInfo_bs_D);
            this.addBsProposal("\\s", RegExMessages.displayString_bs_s, RegExMessages.additionalInfo_bs_s);
            this.addBsProposal("\\S", RegExMessages.displayString_bs_S, RegExMessages.additionalInfo_bs_S);
            this.addBsProposal("\\w", RegExMessages.displayString_bs_w, RegExMessages.additionalInfo_bs_w);
            this.addBsProposal("\\W", RegExMessages.displayString_bs_W, RegExMessages.additionalInfo_bs_W);
            if (!this.fIsEscape) {
                this.addBracketProposal("[]", 1, RegExMessages.displayString_set, RegExMessages.additionalInfo_set);
                this.addBracketProposal("[^]", 2, RegExMessages.displayString_setExcl, RegExMessages.additionalInfo_setExcl);
                this.addBracketProposal("[-]", 1, RegExMessages.displayString_setRange, RegExMessages.additionalInfo_setRange);
            }
            if (this.fDocumentOffset == 0) {
                this.addPriorityProposal("^", RegExMessages.displayString_start, RegExMessages.additionalInfo_start);
            } else if (this.fDocumentOffset == 1 && this.fExpression.charAt(0) == '^') {
                this.addBracketProposal("^", 1, RegExMessages.displayString_start, RegExMessages.additionalInfo_start);
            }
            if (this.fDocumentOffset == this.fExpression.length()) {
                this.addProposal("$", RegExMessages.displayString_end, RegExMessages.additionalInfo_end);
            }
            this.addBsProposal("\\b", RegExMessages.displayString_bs_b, RegExMessages.additionalInfo_bs_b);
            this.addBsProposal("\\B", RegExMessages.displayString_bs_B, RegExMessages.additionalInfo_bs_B);
            this.addBsProposal("\\A", RegExMessages.displayString_bs_A, RegExMessages.additionalInfo_bs_A);
            this.addBsProposal("\\Z", RegExMessages.displayString_bs_Z, RegExMessages.additionalInfo_bs_Z);
            if (!this.fIsEscape) {
                this.addBracketProposal("()", 1, RegExMessages.displayString_group, RegExMessages.additionalInfo_group);
                this.addBracketProposal("(?:)", 3, RegExMessages.displayString_nonCap, RegExMessages.additionalInfo_nonCap);
                this.addBracketProposal("(?=)", 3, RegExMessages.displayString_posLookahead, RegExMessages.additionalInfo_posLookahead);
                this.addBracketProposal("(?!)", 3, RegExMessages.displayString_negLookahead, RegExMessages.additionalInfo_negLookahead);
                this.addBracketProposal("?", 1, RegExMessages.displayString_quest, RegExMessages.additionalInfo_quest);
                this.addBracketProposal("*", 1, RegExMessages.displayString_star, RegExMessages.additionalInfo_star);
                this.addBracketProposal("+", 1, RegExMessages.displayString_plus, RegExMessages.additionalInfo_plus);
                this.addBracketProposal("{}", 1, RegExMessages.displayString_exact, RegExMessages.additionalInfo_exact);
                this.addBracketProposal("{,}", 1, RegExMessages.displayString_least, RegExMessages.additionalInfo_least);
                this.addBracketProposal("{,}", 1, RegExMessages.displayString_count, RegExMessages.additionalInfo_count);
                this.addBracketProposal("{.}", 2, RegExMessages.displayString_zeromore, RegExMessages.additionalInfo_zeromore);
                this.addBracketProposal("|", 1, RegExMessages.displayString_alt, RegExMessages.additionalInfo_alt);
            }
            this.fPriorityProposals.addAll(this.fProposals);
            return this.fPriorityProposals.toArray(new ICompletionProposal[this.fProposals.size()]);
        }

        public ICompletionProposal[] computeReplaceProposals() {
            if (this.fDocumentOffset > 0 && '$' == this.fExpression.charAt(this.fDocumentOffset - 1)) {
                this.addProposal("", RegExMessages.displayString_dollar, RegExMessages.additionalInfo_dollar);
            } else {
                this.addProposal("$", RegExMessages.displayString_dollar, RegExMessages.additionalInfo_dollar);
                this.addBsProposal("\\", RegExMessages.displayString_replace_bs, RegExMessages.additionalInfo_replace_bs);
                this.addProposal("\t", RegExMessages.displayString_tab, RegExMessages.additionalInfo_tab);
            }
            return this.fProposals.toArray(new ICompletionProposal[this.fProposals.size()]);
        }

        private void addProposal(String proposal, String displayString, String additionalInfo) {
            this.fProposals.add(new CompletionProposal(proposal, this.fDocumentOffset, 0, proposal.length(), null, displayString, null, additionalInfo));
        }

        private void addProposal(String proposal, int cursorPosition, String displayString, String additionalInfo) {
            this.fProposals.add(new CompletionProposal(proposal, this.fDocumentOffset, 0, cursorPosition, null, displayString, null, additionalInfo));
        }

        private void addPriorityProposal(String proposal, String displayString, String additionalInfo) {
            this.fPriorityProposals.add(new CompletionProposal(proposal, this.fDocumentOffset, 0, proposal.length(), null, displayString, null, additionalInfo));
        }

        private void addBracketProposal(String proposal, int cursorPosition, String displayString, String additionalInfo) {
            String prolog = this.fExpression.substring(0, this.fDocumentOffset);
            if (!this.fIsEscape && prolog.endsWith("\\") && proposal.startsWith("\\")) {
                this.fProposals.add(new CompletionProposal(proposal, this.fDocumentOffset, 0, cursorPosition, null, displayString, null, additionalInfo));
                return;
            }
            int i = 1;
            while (i <= cursorPosition) {
                String prefix = proposal.substring(0, i);
                if (prolog.endsWith(prefix)) {
                    String postfix = proposal.substring(cursorPosition);
                    String epilog = this.fExpression.substring(this.fDocumentOffset);
                    if (epilog.startsWith(postfix)) {
                        this.fPriorityProposals.add(new CompletionProposal(proposal.substring(i, cursorPosition), this.fDocumentOffset, 0, cursorPosition - i, null, displayString, null, additionalInfo));
                    } else {
                        this.fPriorityProposals.add(new CompletionProposal(proposal.substring(i), this.fDocumentOffset, 0, cursorPosition - i, null, displayString, null, additionalInfo));
                    }
                    return;
                }
                ++i;
            }
            this.fProposals.add(new CompletionProposal(proposal, this.fDocumentOffset, 0, cursorPosition, null, displayString, null, additionalInfo));
        }

        private void addBsProposal(String proposal, String displayString, String additionalInfo) {
            if (this.fIsEscape) {
                this.fPriorityProposals.add(new CompletionProposal(proposal.substring(1), this.fDocumentOffset, 0, proposal.length() - 1, null, displayString, null, additionalInfo));
            } else {
                this.addProposal(proposal, displayString, additionalInfo);
            }
        }
    }
}

