/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.preferences;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.preferences.PixelConverter;
import com.aptana.ide.epl.Activator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectNaturesPage
extends PropertyPage
implements ICheckStateListener {
    protected static final String APTANA_NATURE_PREFIX = "com.aptana.ide.";
    private static final int NATURES_LIST_MULTIPLIER = 30;
    private Image aptanaNatureImage = Activator.getImage("icons/aptana_nature.gif");
    private IProject project;
    private boolean modified = false;
    private CheckboxTableViewer listViewer;
    protected boolean showAptanaOnly = true;
    private List<String> projectNatures;
    private HashMap<Object, TableItem> maintainChecked = new HashMap();
    private HashMap<String, String> descriptionCache = new HashMap();
    private String primaryNature;
    private Button makePrimaryButton;
    private Button restoreButton;
    private List<String> initialCheckedItems;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this.initialize();
        Label description = this.createDescriptionLabel(composite);
        description.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite tableComposite = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        tableComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        tableComposite.setLayoutData((Object)data);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2176);
        Table table = this.listViewer.getTable();
        table.setFont(font);
        TableColumn column = new TableColumn(table, 16384);
        column.setWidth(350);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        if (!this.project.isOpen()) {
            this.listViewer.getControl().setEnabled(false);
        }
        if (DialogUtil.inRegularFontMode((Composite)parent)) {
            data.heightHint = ProjectNaturesPage.getDefaultFontHeight((Control)table, 30);
        }
        table.setLayoutData((Object)data);
        table.setFont(font);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)this.getContentProvider(this.project));
        this.listViewer.setComparator(this.getViewerComperator());
        this.listViewer.setInput((Object)this.project.getWorkspace());
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
        table.setMenu(this.createMenu());
        this.initialCheckedItems = this.initializeCheckedNatures();
        Collections.sort(this.initialCheckedItems);
        this.listViewer.setCheckedElements(this.initialCheckedItems.toArray());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectNaturesPage.this.updateButtons();
            }
        });
        Composite buttons = new Composite(tableComposite, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(1040));
        this.makePrimaryButton = this.createButton("Make Primary", buttons, (SelectionListener)new MakePrimarySelectionListener());
        this.restoreButton = this.createButton("Revert", buttons, (SelectionListener)new RestoreSelectionListener());
        this.updateButtons();
        return composite;
    }

    private List<String> initializeCheckedNatures() {
        HashSet<String> projectNatureIds = new HashSet<String>(this.projectNatures);
        IProjectNatureDescriptor[] natureDescriptors = this.project.getWorkspace().getNatureDescriptors();
        ArrayList<String> checked = new ArrayList<String>(projectNatureIds.size());
        int i = 0;
        while (i < natureDescriptors.length) {
            if (projectNatureIds.remove(natureDescriptors[i].getNatureId())) {
                checked.add(this.fixNatureId(natureDescriptors[i].getNatureId()));
            }
            ++i;
        }
        Iterator stream = projectNatureIds.iterator();
        while (stream.hasNext()) {
            checked.add((String)stream.next());
        }
        return checked;
    }

    private Button createButton(String text, Composite parent, SelectionListener selectionListener) {
        Button b = new Button(parent, 8);
        b.setText(text);
        GridData data = new GridData(4);
        data.widthHint = ProjectNaturesPage.getButtonWidthHint(b);
        b.setLayoutData((Object)data);
        if (selectionListener != null) {
            b.addSelectionListener(selectionListener);
        }
        return b;
    }

    private void updateButtons() {
        StructuredSelection selection = (StructuredSelection)this.listViewer.getSelection();
        this.makePrimaryButton.setEnabled(!selection.isEmpty() && !this.isPrimary(selection.getFirstElement()));
        this.restoreButton.setEnabled(this.modified || this.isPrimaryModified());
    }

    private static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    private IStructuredContentProvider getContentProvider(IProject project) {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (!(o instanceof IWorkspace)) {
                    return new Object[0];
                }
                HashSet projectNatureIds = new HashSet(ProjectNaturesPage.this.projectNatures);
                IProjectNatureDescriptor[] natureDescriptors = ((IWorkspace)o).getNatureDescriptors();
                HashSet<String> elements = new HashSet<String>(natureDescriptors.length);
                int i = 0;
                while (i < natureDescriptors.length) {
                    String natureId = ProjectNaturesPage.this.fixNatureId(natureDescriptors[i].getNatureId());
                    if (natureId != null && (natureId.startsWith(ProjectNaturesPage.APTANA_NATURE_PREFIX) || projectNatureIds.contains(natureId) || !ProjectNaturesPage.this.showAptanaOnly)) {
                        elements.add(natureId);
                        ProjectNaturesPage.this.descriptionCache.put(natureId, natureDescriptors[i].getLabel());
                    }
                    ++i;
                }
                for (String nature : ProjectNaturesPage.this.projectNatures) {
                    if (elements.contains(nature)) continue;
                    elements.add(nature);
                    ProjectNaturesPage.this.descriptionCache.put(nature, "missing description");
                }
                return elements.toArray();
            }
        };
    }

    private ILabelProvider getLabelProvider() {
        return new NaturesLabelProvider();
    }

    protected String getNatureDescriptorLabel(IProjectNatureDescriptor natureDescriptor) {
        String id = natureDescriptor.getNatureId();
        id = this.fixNatureId(id);
        String label = natureDescriptor.getLabel();
        if (label.trim().length() != 0) {
            return String.valueOf(id) + " (" + label + ')';
        }
        return id;
    }

    protected Menu createMenu() {
        Menu menu = new Menu((Control)this.listViewer.getTable());
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Set as primary");
        item.addSelectionListener((SelectionListener)new MakePrimarySelectionListener());
        return menu;
    }

    private ViewerComparator getViewerComperator() {
        return new ViewerComparator(new Comparator(){

            public int compare(Object element1, Object element2) {
                String firstId = element1.toString();
                String secondId = element2.toString();
                if (firstId.startsWith(ProjectNaturesPage.APTANA_NATURE_PREFIX)) {
                    if (secondId.startsWith(ProjectNaturesPage.APTANA_NATURE_PREFIX)) {
                        return firstId.compareTo(secondId);
                    }
                    return -1;
                }
                if (secondId.startsWith(ProjectNaturesPage.APTANA_NATURE_PREFIX)) {
                    return 1;
                }
                return firstId.compareTo(secondId);
            }
        });
    }

    protected void handle(InvocationTargetException e) {
        IStatus error;
        IdeLog.logError((Plugin)Activator.getDefault(), (String)"ProjectNaturesPage error", (Throwable)e);
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            error = ((CoreException)target).getStatus();
        } else {
            String msg = target.getMessage();
            if (msg == null) {
                msg = IDEWorkbenchMessages.Internal_error;
            }
            error = new Status(4, "org.eclipse.ui.ide", 1, msg, target);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), null, null, (IStatus)error);
    }

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        try {
            String[] natureIds = this.project.getDescription().getNatureIds();
            this.projectNatures = new ArrayList<String>((Collection)Arrays.asList(natureIds));
        }
        catch (CoreException e) {
            this.handle(new InvocationTargetException(e));
        }
        this.primaryNature = this.projectNatures != null && !this.projectNatures.isEmpty() ? this.projectNatures.get(0) : null;
        this.noDefaultAndApplyButton();
        String desc = NLS.bind((String)"Projects may have natures assigned to enable additional functionalities.\nUse this page to specify which natures should be assigned to the project.\n\n&Project natures for {0}:", (Object)this.project.getName());
        this.setDescription(desc);
    }

    protected boolean isPrimary(Object element) {
        return this.primaryNature != null && this.primaryNature.equals(element);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.maintainChecked.containsKey(event.getElement())) {
            this.maintainChecked.get(event.getElement()).setChecked(!event.getChecked());
        }
        Object[] checkedElements = this.listViewer.getCheckedElements();
        Arrays.sort(checkedElements);
        boolean bl = this.modified = !Arrays.equals(this.initialCheckedItems.toArray(), checkedElements);
        if (this.primaryNature == null) {
            if (event.getChecked()) {
                this.primaryNature = event.getElement().toString();
                this.listViewer.refresh();
            }
        } else if (!event.getChecked() && this.isPrimary(event.getElement())) {
            this.primaryNature = null;
            checkedElements = this.listViewer.getCheckedElements();
            if (checkedElements.length > 0) {
                this.primaryNature = checkedElements[0].toString();
            }
            this.listViewer.refresh();
        }
        this.updateButtons();
    }

    public boolean performOk() {
        if (!this.modified && !this.isPrimaryModified()) {
            return true;
        }
        Object[] checked = this.listViewer.getCheckedElements();
        final ArrayList<String> natureIds = new ArrayList<String>();
        int i = 0;
        while (i < checked.length) {
            if (!(checked[i] instanceof String)) {
                this.handle(new InvocationTargetException(new IllegalStateException(NLS.bind((String)"invalid element \"{0}\" in nature list", (Object)checked[i]))));
                return false;
            }
            natureIds.add(checked[i].toString());
            ++i;
        }
        natureIds.remove(this.primaryNature);
        if (this.primaryNature != null) {
            natureIds.add(0, this.primaryNature);
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IProjectDescription description = ProjectNaturesPage.this.project.getDescription();
                    description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
                    ProjectNaturesPage.this.project.setDescription(description, 64, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            this.handle(e);
            return false;
        }
        this.resetProject();
        return true;
    }

    private boolean isPrimaryModified() {
        return this.projectNatures != null && !this.projectNatures.isEmpty() ? !this.projectNatures.get(0).equals(this.primaryNature) : this.primaryNature != null;
    }

    private String fixNatureId(String natureId) {
        int secondComIndex = natureId.indexOf(".com.");
        if (secondComIndex > -1) {
            natureId = natureId.substring(secondComIndex + 1);
        }
        return natureId;
    }

    protected void resetProject() {
        boolean reset = MessageDialog.openQuestion((Shell)this.getControl().getShell(), (String)"Nature Change", (String)"To immediately apply the 'Nature' change you will need to close the project and re-open it.\nWould you like to do so?");
        if (reset) {
            IRunnableWithProgress close = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    UIJob job = new UIJob("Closing project..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            CloseResourceAction closeAction = new CloseResourceAction(Display.getDefault().getActiveShell());
                            closeAction.selectionChanged((IStructuredSelection)new StructuredSelection(new Object[]{ProjectNaturesPage.this.project}));
                            closeAction.run();
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (String)"Error while closing the project", (Throwable)e);
                    }
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, close);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                this.handle(e);
            }
            IRunnableWithProgress open = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ProjectNaturesPage.this.project.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, open);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                this.handle(e);
            }
        }
    }

    private class NaturesLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private NaturesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                if (ProjectNaturesPage.this.descriptionCache.containsKey(element)) {
                    String desc = (String)ProjectNaturesPage.this.descriptionCache.get(element);
                    if (ProjectNaturesPage.this.isPrimary(element)) {
                        desc = String.valueOf(desc) + " - Primary";
                    }
                    return desc;
                }
                return element.toString();
            }
            if (element instanceof IWorkspace) {
                return "Unknown";
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            String natureId = element.toString();
            if (natureId != null && natureId.startsWith(ProjectNaturesPage.APTANA_NATURE_PREFIX)) {
                return ProjectNaturesPage.this.aptanaNatureImage;
            }
            return super.getImage(element);
        }

        public Font getFont(Object element) {
            this.updateEnablement(element);
            if (ProjectNaturesPage.this.isPrimary(element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        private void updateEnablement(Object element) {
            TableItem[] items;
            if (ProjectNaturesPage.this.maintainChecked.containsKey(element)) {
                return;
            }
            TableItem[] tableItemArray = items = ProjectNaturesPage.this.listViewer.getTable().getItems();
            int n = 0;
            int n2 = tableItemArray.length;
            while (n < n2) {
                TableItem item = tableItemArray[n];
                if (item.getData() == element) {
                    if (item.getData().toString().startsWith(ProjectNaturesPage.APTANA_NATURE_PREFIX)) break;
                    item.setForeground(Display.getDefault().getSystemColor(15));
                    ProjectNaturesPage.this.maintainChecked.put(element, item);
                    break;
                }
                ++n;
            }
        }
    }

    private class MakePrimarySelectionListener
    extends SelectionAdapter {
        private MakePrimarySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ISelection selection = ProjectNaturesPage.this.listViewer.getSelection();
            if (!selection.isEmpty() && selection instanceof StructuredSelection) {
                Object firstElement = ((StructuredSelection)selection).getFirstElement();
                ProjectNaturesPage.this.listViewer.setChecked(firstElement, true);
                ProjectNaturesPage.this.primaryNature = firstElement.toString();
                ProjectNaturesPage.this.listViewer.refresh();
                ProjectNaturesPage.this.updateButtons();
            }
        }
    }

    private class RestoreSelectionListener
    extends SelectionAdapter {
        private RestoreSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ProjectNaturesPage.this.modified = false;
            ProjectNaturesPage.this.initialize();
            ProjectNaturesPage.this.listViewer.setCheckedElements(ProjectNaturesPage.this.initialCheckedItems.toArray());
            ProjectNaturesPage.this.listViewer.refresh();
            ProjectNaturesPage.this.updateButtons();
        }
    }
}

