/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.utils;

import com.aptana.ide.editors.unified.utils.DNDListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class DragAndDropInstaller {
    private static Cursor hoverCursor = new Cursor((Device)Display.getDefault(), 0);

    public static void installTextDragAndDrop(final ISourceViewer viewer, final AbstractTextEditor editor) {
        final StyledText st = viewer.getTextWidget();
        st.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                try {
                    if (e.stateMask == 0) {
                        Point p = st.getSelection();
                        int offset = st.getOffsetAtLocation(new Point(e.x, e.y));
                        if (p.x != p.y && offset >= p.x && offset <= p.y) {
                            st.setCursor(hoverCursor);
                        } else {
                            st.setCursor(null);
                        }
                    }
                }
                catch (Exception exception) {
                    st.setCursor(null);
                }
            }
        });
        final ISelectionProvider selectionProvider = viewer.getSelectionProvider();
        DragSource source = new DragSource((Control)st, 3);
        DropTarget target = new DropTarget((Control)st, 3);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        source.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        DNDListener listener = new DNDListener(){
            String fSelectedText;
            Point fSelection;

            public void dragStart(DragSourceEvent event) {
                this.fTextDragAndDropToken = null;
                try {
                    this.fSelection = st.getSelection();
                    int offset = st.getOffsetAtLocation(new Point(event.x, event.y));
                    Point p = st.getLocationAtOffset(offset);
                    if (p.x > event.x) {
                        --offset;
                    }
                    event.doit = offset > this.fSelection.x && offset < this.fSelection.y;
                    ISelection selection = selectionProvider.getSelection();
                    this.fSelectedText = selection instanceof ITextSelection ? ((ITextSelection)selection).getText() : st.getSelectionText();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.fSelectedText;
                this.fTextDragAndDropToken = this;
            }

            public void dragFinished(DragSourceEvent event) {
                try {
                    if (event.detail == 2 && editor.validateEditorInputState()) {
                        IRewriteTarget target;
                        Point newSelection = st.getSelection();
                        int length = this.fSelection.y - this.fSelection.x;
                        int delta = 0;
                        if (newSelection.x < this.fSelection.x) {
                            delta = length;
                        }
                        st.replaceTextRange(this.fSelection.x + delta, length, "");
                        if (this.fTextDragAndDropToken == null && (target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class)) != null) {
                            target.endCompoundChange();
                        }
                    }
                }
                finally {
                    this.fTextDragAndDropToken = null;
                }
            }

            public void dragEnter(DropTargetEvent event) {
                this.fTextDragAndDropToken = null;
                this.fSelection = st.getSelection();
                if (event.detail == 16) {
                    event.detail = 2;
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 2;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback |= 8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void drop(DropTargetEvent event) {
                try {
                    if (this.fTextDragAndDropToken != null && event.detail == 2) {
                        int caretOffset = st.getCaretOffset();
                        if (this.fSelection.x <= caretOffset && caretOffset <= this.fSelection.y) {
                            event.detail = 0;
                            return;
                        }
                        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
                        if (target != null) {
                            target.beginCompoundChange();
                        }
                    }
                    if (!editor.validateEditorInputState()) {
                        event.detail = 0;
                        return;
                    }
                    String text = (String)event.data;
                    Point newSelection = st.getSelection();
                    try {
                        if (viewer instanceof ITextViewerExtension5) {
                            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                            int modelOffset = extension.widgetOffset2ModelOffset(newSelection.x);
                            viewer.getDocument().replace(modelOffset, 0, text);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    st.setSelectionRange(newSelection.x, text.length());
                    return;
                }
                finally {
                    this.fTextDragAndDropToken = null;
                }
            }
        };
        source.addDragListener((DragSourceListener)listener);
        target.addDropListener((DropTargetListener)listener);
    }
}

