/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Authorizer;
import SQLite.BusyHandler;
import SQLite.Callback;
import SQLite.Exception;
import SQLite.Function;
import SQLite.ProgressHandler;
import SQLite.TableResult;
import SQLite.Trace;
import SQLite.Vm;

public class Database {
    protected long handle = 0L;
    protected int error_code = 0;

    public synchronized native void open(String var1, int var2) throws Exception;

    public synchronized native void open_aux_file(String var1) throws Exception;

    protected synchronized native void finalize();

    public synchronized native void close() throws Exception;

    public synchronized native void exec(String var1, Callback var2) throws Exception;

    public synchronized native void exec(String var1, Callback var2, String[] var3) throws Exception;

    public synchronized native long last_insert_rowid();

    public synchronized native void interrupt();

    public synchronized native long changes();

    public synchronized native void busy_handler(BusyHandler var1);

    public synchronized native void busy_timeout(int var1);

    public TableResult get_table(String string) throws Exception {
        TableResult tableResult = new TableResult();
        this.exec(string, tableResult);
        return tableResult;
    }

    public TableResult get_table(String string, String[] stringArray) throws Exception {
        TableResult tableResult = new TableResult();
        this.exec(string, tableResult, stringArray);
        return tableResult;
    }

    public void get_table(String string, String[] stringArray, TableResult tableResult) throws Exception {
        tableResult.clear();
        this.exec(string, tableResult, stringArray);
    }

    public static synchronized native boolean complete(String var0);

    public static native String version();

    public native void create_function(String var1, int var2, Function var3);

    public native void create_aggregate(String var1, int var2, Function var3);

    public native void function_type(String var1, int var2);

    public int last_error() {
        return this.error_code;
    }

    public static native String error_string(int var0);

    public synchronized native void set_encoding(String var1) throws Exception;

    public synchronized native void set_authorizer(Authorizer var1);

    public synchronized native void trace(Trace var1);

    public Vm compile(String string) throws Exception {
        Vm vm = new Vm();
        this.vm_compile(string, vm);
        return vm;
    }

    public synchronized native void vm_compile(String var1, Vm var2) throws Exception;

    public synchronized native void progress_handler(int var1, ProgressHandler var2);

    private static native void internal_init();

    static {
        try {
            System.loadLibrary("sqlite_jni");
            Database.internal_init();
        }
        catch (Throwable throwable) {
            System.err.println("Unable to load sqlite: " + throwable);
        }
    }
}

