/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Callback;
import SQLite.DBDump;
import SQLite.Database;
import SQLite.Exception;
import SQLite.TableResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class Shell
implements Callback {
    Database db;
    boolean echo;
    int count;
    int mode;
    boolean showHeader;
    String tableName;
    String sep;
    String[] cols;
    int[] colwidth;
    String destTable;
    static final int MODE_Line = 0;
    static final int MODE_Column = 1;
    static final int MODE_List = 2;
    static final int MODE_Semi = 3;
    static final int MODE_Html = 4;
    static final int MODE_Insert = 5;

    protected Object clone() {
        Shell shell = new Shell();
        shell.db = this.db;
        shell.echo = this.echo;
        shell.mode = this.mode;
        shell.count = 0;
        shell.showHeader = this.showHeader;
        shell.tableName = this.tableName;
        shell.sep = this.sep;
        shell.colwidth = this.colwidth;
        return shell;
    }

    public static String sql_quote(String string) {
        int n;
        if (string == null) {
            return "NULL";
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\'') {
                ++n2;
                continue;
            }
            if (string.charAt(n) != '\"') continue;
            ++n3;
        }
        if (n2 == 0) {
            return "'" + string + "'";
        }
        if (n3 == 0) {
            return "\"" + string + "\"";
        }
        StringBuffer stringBuffer = new StringBuffer("'");
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '\'') {
                stringBuffer.append("''");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String html_quote(String string) {
        if (string == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static boolean is_numeric(String string) {
        try {
            Double d = Double.valueOf(string);
        }
        catch (java.lang.Exception exception) {
            return false;
        }
        return true;
    }

    void set_table_name(String string) {
        if (string == null) {
            this.tableName = "";
            return;
        }
        this.tableName = Shell.sql_quote(string);
    }

    public void columns(String[] stringArray) {
        this.cols = stringArray;
    }

    public void types(String[] stringArray) {
    }

    public boolean newrow(String[] stringArray) {
        switch (this.mode) {
            case 0: {
                if (stringArray.length == 0) break;
                if (this.count++ > 0) {
                    System.out.println("");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(this.cols[i] + " = " + stringArray[i] == null ? "NULL" : stringArray[i]);
                }
                break;
            }
            case 1: {
                int n;
                String string = "";
                if (this.count++ == 0) {
                    this.colwidth = new int[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        int n2 = this.cols[n].length();
                        if (n2 < 10) {
                            n2 = 10;
                        }
                        this.colwidth[n] = n2;
                        if (!this.showHeader) continue;
                        System.out.print(string + this.cols[n]);
                        string = " ";
                    }
                    if (this.showHeader) {
                        System.out.println("");
                    }
                }
                if (stringArray.length == 0) break;
                string = "";
                for (n = 0; n < stringArray.length; ++n) {
                    System.out.print(string + (stringArray[n] == null ? "NULL" : stringArray[n]));
                    string = " ";
                }
                System.out.println("");
                break;
            }
            case 2: 
            case 3: {
                int n;
                if (this.count++ == 0 && this.showHeader) {
                    for (n = 0; n < stringArray.length; ++n) {
                        System.out.print(this.cols[n] + (n == stringArray.length - 1 ? "\n" : this.sep));
                    }
                }
                if (stringArray.length == 0) break;
                for (n = 0; n < stringArray.length; ++n) {
                    System.out.print(stringArray[n] == null ? "NULL" : stringArray[n]);
                    if (this.mode == 3) {
                        System.out.print(";");
                        continue;
                    }
                    if (n >= stringArray.length - 1) continue;
                    System.out.print(this.sep);
                }
                System.out.println("");
                break;
            }
            case 4: {
                int n;
                if (this.count++ == 0 && this.showHeader) {
                    System.out.print("<TR>");
                    for (n = 0; n < stringArray.length; ++n) {
                        System.out.print("<TH>" + Shell.html_quote(this.cols[n]) + "</TH>");
                    }
                    System.out.println("</TR>");
                }
                if (stringArray.length == 0) break;
                System.out.print("<TR>");
                for (n = 0; n < stringArray.length; ++n) {
                    System.out.print("<TD>" + Shell.html_quote(stringArray[n]) + "</TD>");
                }
                System.out.println("</TR>");
                break;
            }
            case 5: {
                if (stringArray.length == 0) break;
                String string = this.tableName;
                if (this.destTable != null) {
                    string = this.destTable;
                }
                System.out.print("INSERT INTO " + string + " VALUES(");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2;
                    String string3 = string2 = i > 0 ? "," : "";
                    if (stringArray[i] == null) {
                        System.out.print(string2 + "NULL");
                        continue;
                    }
                    if (Shell.is_numeric(stringArray[i])) {
                        System.out.print(string2 + stringArray[i]);
                        continue;
                    }
                    System.out.print(string2 + Shell.sql_quote(stringArray[i]));
                }
                System.out.println(");");
            }
        }
        return false;
    }

    void do_meta(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase());
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        String[] stringArray = new String[n - 1];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (string2.compareTo(".dump") == 0) {
            new DBDump(this, stringArray);
            return;
        }
        if (string2.compareTo(".echo") == 0) {
            if (stringArray.length > 0 && (stringArray[0].startsWith("y") || stringArray[0].startsWith("on"))) {
                this.echo = true;
            }
            return;
        }
        if (string2.compareTo(".exit") == 0) {
            try {
                this.db.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
        if (string2.compareTo(".header") == 0) {
            if (stringArray.length > 0 && (stringArray[0].startsWith("y") || stringArray[0].startsWith("on"))) {
                this.showHeader = true;
            }
            return;
        }
        if (string2.compareTo(".help") == 0) {
            System.out.println(".dump ?TABLE? ...  Dump database in text fmt");
            System.out.println(".echo ON|OFF       Command echo on or off");
            System.out.println(".enc ?NAME?        Change encoding");
            System.out.println(".exit              Exit program");
            System.out.println(".header ON|OFF     Display headers on or off");
            System.out.println(".help              This message");
            System.out.println(".mode MODE         Set output mode to\n                   line, column, insert\n                   list, or html");
            System.out.println(".mode insert TABLE Generate SQL insert stmts");
            System.out.println(".schema ?PATTERN?  List table schema");
            System.out.println(".separator STRING  Set separator string");
            System.out.println(".tables ?PATTERN?  List table names");
            return;
        }
        if (string2.compareTo(".mode") == 0) {
            if (stringArray.length > 0) {
                if (stringArray[0].compareTo("line") == 0) {
                    this.mode = 0;
                } else if (stringArray[0].compareTo("column") == 0) {
                    this.mode = 1;
                } else if (stringArray[0].compareTo("list") == 0) {
                    this.mode = 2;
                } else if (stringArray[0].compareTo("html") == 0) {
                    this.mode = 4;
                } else if (stringArray[0].compareTo("insert") == 0) {
                    this.mode = 4;
                    if (stringArray.length > 1) {
                        this.destTable = stringArray[1];
                    }
                }
            }
            return;
        }
        if (string2.compareTo(".separator") == 0) {
            if (stringArray.length > 0) {
                this.sep = stringArray[0];
            }
            return;
        }
        if (string2.compareTo(".tables") == 0) {
            Object object;
            TableResult tableResult = null;
            if (stringArray.length > 0) {
                try {
                    object = new String[]{stringArray[0]};
                    tableResult = this.db.get_table("SELECT name FROM sqlite_master WHERE type='table' AND name LIKE '%%%q%%' ORDER BY name", (String[])object);
                }
                catch (Exception exception) {
                    System.err.println("SQL Error: " + exception);
                }
            } else {
                try {
                    tableResult = this.db.get_table("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name");
                }
                catch (Exception exception) {
                    System.err.println("SQL Error: " + exception);
                }
            }
            if (tableResult != null) {
                for (n2 = 0; n2 < tableResult.nrows; ++n2) {
                    object = ((String[])tableResult.rows.elementAt(n2))[0];
                    if (object == null) continue;
                    System.out.println((String)object);
                }
            }
            return;
        }
        if (string2.compareTo(".schema") == 0) {
            if (stringArray.length > 0) {
                try {
                    String[] stringArray2 = new String[]{stringArray[0]};
                    this.db.exec("SELECT sql FROM sqlite_master WHERE type!='meta' AND name LIKE '%%%q%%' AND sql NOTNULL ORDER BY type DESC, name", this, stringArray2);
                }
                catch (Exception exception) {
                    System.err.println("SQL Error: " + exception);
                }
            } else {
                try {
                    this.db.exec("SELECT sql FROM sqlite_master WHERE type!='meta' AND sql NOTNULL ORDER BY tbl_name, type DESC, name", this);
                }
                catch (Exception exception) {
                    System.err.println("SQL Error: " + exception);
                }
            }
            return;
        }
        if (string2.compareTo(".enc") == 0) {
            try {
                this.db.set_encoding(stringArray.length > 0 ? stringArray[0] : null);
            }
            catch (Exception exception) {
                System.err.println("" + exception);
            }
            return;
        }
        System.err.println("Unknown command '" + string2 + "'");
    }

    static String read_line(BufferedReader bufferedReader, String string) {
        try {
            System.out.print(string);
            String string2 = bufferedReader.readLine();
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void do_input(BufferedReader bufferedReader) {
        String string;
        String string2 = null;
        String string3 = "SQLITE> ";
        while ((string = Shell.read_line(bufferedReader, string3)) != null) {
            if (this.echo) {
                System.out.println(string);
            }
            if (string.length() > 0 && string.charAt(0) == '.') {
                this.do_meta(string);
                continue;
            }
            if (Database.complete(string2 = string2 == null ? string : string2 + " " + string)) {
                try {
                    this.db.exec(string2, this);
                }
                catch (Exception exception) {
                    if (!this.echo) {
                        System.err.println(string2);
                    }
                    System.err.println("SQL Error: " + exception);
                }
                string2 = null;
                string3 = "SQLITE> ";
                continue;
            }
            string3 = "SQLITE? ";
        }
        if (string2 != null) {
            System.err.println("Incomplete SQL: " + string2);
        }
    }

    public static void main(String[] stringArray) {
        Shell shell = new Shell();
        shell.mode = 2;
        shell.sep = "|";
        shell.showHeader = false;
        shell.db = new Database();
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo("-html") == 0) {
                shell.mode = 4;
                continue;
            }
            if (stringArray[i].compareTo("-list") == 0) {
                shell.mode = 2;
                continue;
            }
            if (stringArray[i].compareTo("-line") == 0) {
                shell.mode = 0;
                continue;
            }
            if (i < stringArray.length - 1 && stringArray[i].compareTo("-separator") == 0) {
                shell.sep = stringArray[++i];
                continue;
            }
            if (stringArray[i].compareTo("-header") == 0) {
                shell.showHeader = true;
                continue;
            }
            if (stringArray[i].compareTo("-noheader") == 0) {
                shell.showHeader = false;
                continue;
            }
            if (stringArray[i].compareTo("-echo") == 0) {
                shell.echo = true;
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            System.err.println("Arguments: ?OPTIONS? FILENAME ?SQL?");
            System.exit(1);
        }
        if (string == null) {
            System.err.println("No database file given");
            System.exit(1);
        }
        try {
            shell.db.open(string, 0);
        }
        catch (Exception exception) {
            System.err.println("Unable to open database: " + exception);
            System.exit(1);
        }
        if (string2 != null) {
            if (string2.length() > 0 && string2.charAt(0) == '.') {
                shell.do_meta(string2);
            } else {
                try {
                    shell.db.exec(string2, shell);
                }
                catch (Exception exception) {
                    System.err.println("SQL Error: " + exception);
                }
            }
        } else {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            shell.do_input(bufferedReader);
        }
        try {
            shell.db.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

