/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.IHttpServerProviderAdapter;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.JSLaunchConfigurationDelegate;
import com.aptana.ide.debug.core.JSLaunchConfigurationHelper;
import com.aptana.ide.debug.core.Messages;
import com.aptana.ide.debug.internal.core.LocalResourceMapper;
import com.aptana.ide.debug.internal.core.model.DebugConnection;
import com.aptana.ide.debug.internal.core.model.HttpServerProcess;
import com.aptana.ide.debug.internal.core.model.JSDebugProcess;
import com.aptana.ide.debug.internal.core.model.JSDebugTarget;
import com.aptana.ide.server.core.IServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class JSRemoteLaunchConfigurationDelegate
extends JSLaunchConfigurationDelegate {
    private static final Pattern HOST_PATTERN = Pattern.compile("^((\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|(\\w+(\\.\\w+)*))(:(\\d{4,7}))?$");

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean debug = "debug".equals(mode);
        String serverHost = configuration.getAttribute("serverHost", null);
        if (serverHost == null || !HOST_PATTERN.matcher(serverHost).matches()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, StringUtils.format((String)"Invalid server host", (String)serverHost), null));
        }
        int serverType = configuration.getAttribute("serverType", 1);
        int startActionType = configuration.getAttribute("startActionType", 1);
        LocalResourceMapper resourceMapper = null;
        HttpServerProcess httpServer = null;
        boolean launchHttpServer = false;
        URL baseURL = null;
        try {
            if (serverType == 1) {
                if (startActionType != 3) {
                    launchHttpServer = true;
                }
            } else {
                baseURL = new URL(configuration.getAttribute("externalBaseUrl", ""));
                resourceMapper = new LocalResourceMapper();
                resourceMapper.addMapping(baseURL, ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
            }
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_MalformedServerURL, (Throwable)e));
        }
        try {
            URL launchURL = null;
            try {
                if (startActionType == 3) {
                    launchURL = new URL(configuration.getAttribute("startPageUrl", ""));
                } else {
                    String resourcePath;
                    IResource resource = null;
                    if (startActionType == 1) {
                        resource = this.getCurrentEditorResource();
                    } else if (startActionType == 2 && (resourcePath = configuration.getAttribute("startPagePath", null)) != null && resourcePath.length() > 0) {
                        resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(resourcePath));
                    }
                    if (resource != null) {
                        if (baseURL == null && launchHttpServer) {
                            monitor.subTask(Messages.JSLaunchConfigurationDelegate_LaunchingHTTPServer);
                            IHttpServerProviderAdapter httpServerProvider = (IHttpServerProviderAdapter)this.getContributedAdapter(IHttpServerProviderAdapter.class);
                            IServer server = null;
                            if (httpServerProvider != null) {
                                server = httpServerProvider.getServer(resource);
                            }
                            File root = resource.getProject().getLocation().toFile();
                            if (server != null) {
                                baseURL = new URL(server.getHost());
                            } else {
                                httpServer = new HttpServerProcess(launch);
                                httpServer.setServerRoot(root);
                                baseURL = httpServer.getBaseURL();
                            }
                            resourceMapper = new LocalResourceMapper();
                            resourceMapper.addMapping(baseURL, root);
                            JSLaunchConfigurationHelper.setResourceMapping(configuration, baseURL, resourceMapper, httpServer);
                            launchURL = new URL(baseURL, resource.getProjectRelativePath().makeRelative().toPortableString());
                        } else if (baseURL != null) {
                            IProject project = resource.getProject();
                            resourceMapper.addMapping(baseURL, project.getLocation().toFile());
                            launchURL = new URL(baseURL, resource.getProjectRelativePath().makeRelative().toPortableString());
                        } else {
                            launchURL = resource.getLocation().toFile().toURI().toURL();
                        }
                    } else if (startActionType == 1) {
                        IPath path = this.getCurrentEditorPath();
                        launchURL = path != null ? path.toFile().toURI().toURL() : this.getCurrentEditorURL();
                    }
                }
                if (launchURL == null) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchURLNotDefined, null));
                }
                String httpGetQuery = configuration.getAttribute("httpGetData", "");
                if (httpGetQuery != null && httpGetQuery.length() > 0 && launchURL.getQuery() == null && launchURL.getRef() == null) {
                    if (httpGetQuery.charAt(0) != '?') {
                        httpGetQuery = String.valueOf('?') + httpGetQuery;
                    }
                    launchURL = new URL(launchURL, String.valueOf(launchURL.getFile()) + httpGetQuery);
                }
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_MalformedLaunchURL, (Throwable)e));
            }
            monitor.subTask(Messages.JSRemoteLaunchConfigurationDelegate_ConnectingServer);
            Socket socket = null;
            try {
                String host = serverHost;
                int port = 8999;
                int index = serverHost.indexOf(58);
                if (index > 0) {
                    host = serverHost.substring(0, index);
                    try {
                        port = Integer.parseInt(serverHost.substring(index + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        port = 0;
                    }
                }
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), 30000);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_SocketConnectionError, (Throwable)e));
            }
            monitor.subTask(Messages.JSLaunchConfigurationDelegate_InitializingDebugger);
            JSDebugTarget debugTarget = null;
            try {
                JSDebugProcess debugProcess = new JSDebugProcess(launch, Messages.JSRemoteLaunchConfigurationDelegate_Server, null);
                DebugConnection controller = DebugConnection.createConnection(socket);
                debugTarget = new JSDebugTarget(launch, debugProcess, httpServer, resourceMapper, controller, debug);
                monitor.subTask(StringUtils.format((String)Messages.JSLaunchConfigurationDelegate_OpeningPage, (Object)launchURL));
                debugTarget.openURL(launchURL);
            }
            catch (CoreException e) {
                JSDebugPlugin.log(e);
                if (debugTarget != null) {
                    debugTarget.terminate();
                } else {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                throw e;
            }
        }
        catch (CoreException e) {
            if (httpServer != null) {
                launch.removeProcess(httpServer);
                try {
                    httpServer.terminate();
                }
                catch (DebugException e1) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e1);
                }
            }
            throw e;
        }
    }
}

