/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core.util;

import com.aptana.ide.core.FirefoxUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.JSDebugPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public final class FirebugUtils {
    private static final String PREF_FORMAT = "user_pref(\"extensions.firebug.externalEditors{0}\", \"{1}\");";

    private FirebugUtils() {
    }

    public static boolean registerEditor(String name, IPath path, String cmdLine) {
        String id = name.replaceAll("\\W", "_");
        return FirebugUtils.registerEditor(id, name, path, cmdLine);
    }

    public static boolean registerEditor(String id, String name, IPath path, String cmdLine) {
        block33: {
            PrintWriter writer;
            BufferedReader reader;
            block32: {
                File profile = FirefoxUtils.findDefaultProfileLocation();
                if (profile == null) {
                    return false;
                }
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("label", name);
                options.put("executable", path.toOSString());
                options.put("cmdline", cmdLine);
                options.put("image", "");
                File prefs = new File(profile, "prefs.js");
                reader = null;
                writer = null;
                try {
                    try {
                        String value;
                        String line;
                        reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(prefs), "UTF8"));
                        ArrayList<String> lines = new ArrayList<String>();
                        boolean editorsFound = false;
                        boolean doWrite = false;
                        Pattern prefPattern = Pattern.compile("^user_pref\\(\"extensions\\.firebug\\.externalEditors(.*)\", \"(.*)\"\\);$");
                        while ((line = ((LineNumberReader)reader).readLine()) != null) {
                            Matcher matcher = prefPattern.matcher(line);
                            if (matcher.find()) {
                                String option;
                                String editorId;
                                int index;
                                String pref = matcher.group(1);
                                value = matcher.group(2);
                                if (pref.length() == 0) {
                                    editorsFound = true;
                                    String[] editors = value.split(",");
                                    boolean addEntry = true;
                                    int i = 0;
                                    while (i < editors.length) {
                                        if (id.equals(editors[i].trim())) {
                                            addEntry = false;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (addEntry) {
                                        line = StringUtils.format((String)PREF_FORMAT, (Object[])new String[]{pref, String.valueOf(value) + ',' + id});
                                        doWrite = true;
                                    }
                                } else if (pref.charAt(0) == '.' && (index = pref.indexOf(46, 1)) > 0 && id.equals(editorId = pref.substring(1, index)) && options.containsKey(option = pref.substring(index + 1))) {
                                    if (!value.equals(options.get(option))) {
                                        value = (String)options.get(option);
                                        line = value.length() > 0 ? StringUtils.format((String)PREF_FORMAT, (Object[])new String[]{pref, value}) : null;
                                        doWrite = true;
                                    }
                                    options.remove(option);
                                }
                            }
                            if (line == null) continue;
                            lines.add(line);
                        }
                        reader.close();
                        reader = null;
                        if (!editorsFound) {
                            lines.add(StringUtils.format((String)PREF_FORMAT, (Object[])new String[]{"", id}));
                            doWrite = true;
                        }
                        if (!options.isEmpty()) {
                            for (String option : options.keySet()) {
                                value = (String)options.get(option);
                                if (value.length() <= 0) continue;
                                lines.add(StringUtils.format((String)PREF_FORMAT, (Object[])new String[]{String.valueOf('.') + id + '.' + option, value}));
                                doWrite = true;
                            }
                        }
                        if (doWrite) {
                            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(prefs), "UTF8")));
                            Iterator<Object> i = lines.iterator();
                            while (i.hasNext()) {
                                writer.println((String)i.next());
                            }
                        }
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Reading '{0}' fails", (String)prefs.getAbsolutePath()), (Throwable)e);
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (writer != null) {
                        writer.close();
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (writer != null) {
                    writer.close();
                }
                break block33;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
        return true;
    }
}

