/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core;

import com.aptana.ide.server.http.HttpServerException;
import com.aptana.ide.server.http.RequestLineParser;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import com.aptana.ide.server.resources.FileHttpResource;
import com.aptana.ide.server.resources.IHttpResource;
import java.io.File;
import java.util.ArrayList;

public class CompositeResourceResolver
implements IHttpResourceResolver {
    private ArrayList<Entry> paths = new ArrayList();

    public IHttpResource getResource(RequestLineParser requestLine) throws HttpServerException {
        String request = requestLine.getUri();
        for (Entry entry : this.paths) {
            File file;
            String path = entry.path;
            if (!request.startsWith(path)) continue;
            String subpath = request.substring(path.length());
            File dir = entry.dir;
            if (!dir.exists() || !(file = new File(dir, subpath.replace('/', File.separatorChar))).exists() || !file.isFile()) continue;
            return new FileHttpResource(file);
        }
        return null;
    }

    public void addPath(String path, File dir) {
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        if (path.length() > 1 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        int index = 0;
        for (Entry entry : this.paths) {
            int cmp = path.compareTo(entry.path);
            if (cmp > 0) {
                this.paths.add(index, new Entry(path, dir));
                return;
            }
            if (cmp == 0) {
                entry.dir = dir;
                return;
            }
            ++index;
        }
        this.paths.add(new Entry(path, dir));
    }

    private class Entry {
        String path;
        File dir;

        Entry(String path, File dir) {
            this.path = path;
            this.dir = dir;
        }
    }
}

