/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.URLEncoder;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.internal.core.Util;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class LocalResourceMapper {
    private List<Entry> entries = new ArrayList<Entry>();

    public void addMapping(URL baseURL, File rootDir) throws MalformedURLException {
        IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)("LocalResourceMapper: " + baseURL.toExternalForm() + " = " + rootDir));
        try {
            Entry newEntry = new Entry(baseURL, rootDir);
            int index = 0;
            for (Entry entry : this.entries) {
                int cmp = newEntry.baseUrlString.compareTo(entry.baseUrlString);
                if (cmp > 0) {
                    this.entries.add(index, newEntry);
                    return;
                }
                if (cmp == 0) {
                    entry.setRootDir(rootDir);
                    return;
                }
                ++index;
            }
            this.entries.add(0, newEntry);
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    public File resolveServerURL(URL url) {
        try {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        File file = null;
        Iterator<Entry> i = this.entries.iterator();
        while (file == null && i.hasNext()) {
            file = i.next().resolveServerURL(url);
        }
        IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)("LocalResourceMapper: " + url.toExternalForm() + " -> " + file));
        return file;
    }

    public URI resolveLocalURI(URI localURI) {
        if ("file".equals(localURI.getScheme())) {
            URI remoteURI = null;
            Iterator<Entry> i = this.entries.iterator();
            while (remoteURI == null && i.hasNext()) {
                remoteURI = i.next().resolveLocalURI(localURI);
            }
            IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)("LocalResourceMapper: " + localURI + " -> " + remoteURI));
            if (remoteURI != null) {
                return remoteURI;
            }
        }
        return localURI;
    }

    private class Entry {
        private URI baseURI;
        private File rootDir;
        private String baseUrlString;
        private URI rootDirURI;

        protected Entry(URL baseURL, File rootDir) throws MalformedURLException, URISyntaxException {
            this.baseUrlString = URLEncoder.encode((URL)baseURL).toExternalForm();
            if (!this.baseUrlString.endsWith("/")) {
                this.baseUrlString = String.valueOf(this.baseUrlString) + "/";
            }
            this.baseURI = new URI(this.baseUrlString);
            this.setRootDir(rootDir);
        }

        protected void setRootDir(File rootDir) {
            this.rootDir = rootDir;
            this.rootDirURI = rootDir.toURI();
        }

        protected File resolveServerURL(URL url) {
            String string = url.toExternalForm();
            if (string.startsWith(this.baseUrlString)) {
                string = string.substring(this.baseUrlString.length());
                File file = new File(this.rootDir, string = Util.decodeURL(string));
                if (file.exists() && file.isFile()) {
                    return file;
                }
            }
            return null;
        }

        protected URI resolveLocalURI(URI uri) {
            URI relative = this.rootDirURI.relativize(uri);
            if (relative != uri) {
                return this.baseURI.resolve(relative);
            }
            return null;
        }
    }
}

