/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PathUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.IUniformResourceMarker;
import com.aptana.ide.debug.core.DetailFormatter;
import com.aptana.ide.debug.core.IDetailFormattersChangeListener;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.JSDetailFormattersManager;
import com.aptana.ide.debug.core.model.IJSDebugTarget;
import com.aptana.ide.debug.core.model.IJSExceptionBreakpoint;
import com.aptana.ide.debug.core.model.IJSLineBreakpoint;
import com.aptana.ide.debug.core.model.IJSScriptElement;
import com.aptana.ide.debug.core.model.IJSWatchpoint;
import com.aptana.ide.debug.core.model.JSDebugModel;
import com.aptana.ide.debug.core.xhr.IXHRService;
import com.aptana.ide.debug.internal.core.DbgSourceURLStreamHandler;
import com.aptana.ide.debug.internal.core.IFileContentRetriever;
import com.aptana.ide.debug.internal.core.LocalResourceMapper;
import com.aptana.ide.debug.internal.core.Util;
import com.aptana.ide.debug.internal.core.model.DebugConnection;
import com.aptana.ide.debug.internal.core.model.HttpServerProcess;
import com.aptana.ide.debug.internal.core.model.JSDebugElement;
import com.aptana.ide.debug.internal.core.model.JSDebugProcess;
import com.aptana.ide.debug.internal.core.model.JSDebugScriptElement;
import com.aptana.ide.debug.internal.core.model.JSDebugStackFrame;
import com.aptana.ide.debug.internal.core.model.JSDebugThread;
import com.aptana.ide.debug.internal.core.model.JSDebugTopScriptElement;
import com.aptana.ide.debug.internal.core.model.JSDebugValue;
import com.aptana.ide.debug.internal.core.model.JSDebugVariable;
import com.aptana.ide.debug.internal.core.model.Messages;
import com.aptana.ide.debug.internal.core.xhr.XHRService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public class JSDebugTarget
extends JSDebugElement
implements IJSDebugTarget,
IBreakpointManagerListener,
IDetailFormattersChangeListener,
DebugConnection.IHandler {
    private static final String UPDATE = "update";
    private static final String VERSION = "version";
    private static final String JAVASCRIPT = "javascript";
    private static final String JAVASCRIPT_SCHEME = "javascript:";
    private static final String OPENED = "opened";
    private static final String HTTP = "http";
    private static final String FILE = "file";
    private static final String EXCEPTION_0_1 = "exception*{0}*{1}";
    private static final String BREAKPOINT_0_1_2_3 = "breakpoint*{0}*{1}*{2}{3}";
    private static final String WATCHPOINT_0_1_2 = "watchpoint*{0}*{1}*{2}";
    private static final String DETAILS_0 = "details*{0}";
    private static final String SET_VALUE_0_1 = "setValue*{0}*{1}";
    private static final String EVAL_0 = "eval[{0}]";
    private static final String EVAL_0_1 = "eval*{0}*{1}";
    private static final String RESULT = "result";
    private static final String FRAME_0 = "frame[{0}]";
    private static final String VARIABLES_0 = "variables*{0}";
    private static final String OPEN_URL_0 = "openUrl*{0}";
    private static final String OPTION_0_1 = "option*{0}*{1}";
    private static final String ENABLE = "enable";
    private static final String STEP_FILTERS = "stepFilters";
    private static final String MONITOR_XHR = "monitorXHR";
    private static final String DETAIL_FORMATTERS = "detailFormatters";
    private static final String DISABLE = "disable";
    private static final String CHANGE = "change";
    private static final String REMOVE = "remove";
    private static final String CREATE = "create";
    private static final String RESOLVED = "resolved";
    private static final String DESTROYED = "destroyed";
    private static final String ARGS_SPLIT = "\\*";
    private static final String SUBARGS_SPLIT = "\\|";
    private static final String CREATED = "created";
    private static final String TERMINATE = "terminate";
    private static final String SUSPEND = "suspend";
    private static final String ERROR = "error";
    private static final String COMPLETED = "completed";
    private static final String LOADED = "loaded";
    private static final String SEND = "send";
    private static final String HEADERS = "headers";
    private static final String AUTH = "auth";
    private static final String OPEN = "open";
    private static final String START = "start";
    private static final String LOAD = "load";
    private static final String EXCEPTION = "exception";
    private static final String ERR = "err";
    private static final String TRACE = "trace";
    private static final String SRC = "src";
    private static final String BREAKPOINT = "breakpoint";
    private static final String SCRIPTS = "scripts";
    private static final String CLIENT = "client";
    private static final String XHR = "xhr";
    private static final String LOG = "log";
    private static final String SUCCESS = "success";
    private static final String GET_SOURCE_0 = "getSource*{0}";
    private static final int PROTOCOL_VERSION_MIN = 0;
    private static final int PROTOCOL_VERSION_MAX = 1;
    private static final int STEP_FILTERS_ENABLED = 1;
    private static final int FILTER_CONSTRUCTORS = 2;
    private static final int XOR_MASK = 4095;
    private static boolean checkUpdate = true;
    private DebugConnection connection;
    private int stepFilterMask = 0;
    private String[] stepFilters = null;
    private ILaunch launch;
    private String label;
    private IProcess process;
    private OutputStream out;
    private OutputStream err;
    private LocalResourceMapper resourceMapper;
    private JSDebugThread[] threads = new JSDebugThread[0];
    private IFileContentRetriever fileContentRetriever;
    private XHRService xhrService;
    private Map<String, IJSScriptElement> topScriptElements = new HashMap<String, IJSScriptElement>();
    private Map<Integer, IJSScriptElement> scripts = new HashMap<Integer, IJSScriptElement>();
    private List<IBreakpoint> runToLineBreakpoints = new ArrayList<IBreakpoint>();
    private Map<String, String> sourceResolveCache = new HashMap<String, String>(64);
    private String mainFile = null;
    private IBreakpoint skipOperationOnBreakpoint = null;
    private boolean ignoreBreakpointCreation = false;
    private boolean contentChanged = false;
    private Job updateContentJob = new Job("Debugger Content Update"){
        {
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (JSDebugTarget.this.connection == null || !JSDebugTarget.this.connection.isConnected()) {
                return Status.OK_STATUS;
            }
            try {
                boolean changed = false;
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (JSDebugTarget.this.contentChanged) {
                        changed = true;
                        JSDebugTarget.this.contentChanged = false;
                    }
                }
                if (changed) {
                    JSDebugTarget.this.fireChangeEvent(512);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.schedule(1000L);
            }
        }
    };

    public JSDebugTarget(ILaunch launch, IProcess process, HttpServerProcess httpServer, LocalResourceMapper resourceMapper, DebugConnection connection, boolean debugMode) throws CoreException {
        this(launch, null, process, httpServer, resourceMapper, connection, debugMode);
    }

    public JSDebugTarget(ILaunch launch, String label, IProcess process, HttpServerProcess httpServer, LocalResourceMapper resourceMapper, DebugConnection connection, boolean debugMode) throws CoreException {
        super(null);
        this.launch = launch;
        this.label = label;
        this.process = process;
        this.resourceMapper = resourceMapper;
        this.connection = connection;
        try {
            if (debugMode) {
                launch.addDebugTarget((IDebugTarget)this);
            } else {
                if (process instanceof JSDebugProcess) {
                    ((JSDebugProcess)process).setDebugTarget(this);
                }
                if (httpServer != null) {
                    httpServer.setDebugTarget(this);
                }
            }
            this.init(debugMode);
        }
        catch (CoreException e) {
            this.shutdown();
            throw e;
        }
        catch (Exception e) {
            this.shutdown();
            this.throwDebugException(e);
        }
    }

    DebugConnection getConnection() {
        return this.connection;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFileContentRetriever.class) {
            return this.getFileContentRetriever();
        }
        if (adapter == IXHRService.class) {
            return this.xhrService;
        }
        return super.getAdapter(adapter);
    }

    private IFileContentRetriever getFileContentRetriever() {
        if (this.fileContentRetriever == null) {
            this.fileContentRetriever = new IFileContentRetriever(){

                public InputStream getContents(URI uri) throws CoreException {
                    String[] args = JSDebugTarget.this.connection.sendCommandAndWait(StringUtils.format((String)JSDebugTarget.GET_SOURCE_0, (String)Util.encodeData(uri.toString())));
                    if (args != null && JSDebugTarget.SUCCESS.equals(args[1])) {
                        return new ByteArrayInputStream(Util.decodeData(args[2]).getBytes());
                    }
                    return null;
                }
            };
        }
        return this.fileContentRetriever;
    }

    public void handleMessage(String message) {
        String action;
        String[] args = message.split(ARGS_SPLIT);
        int j = 0;
        if (LOG.equals(action = args[j++])) {
            this.handleLog(args);
            return;
        }
        if (XHR.equals(action)) {
            this.handleXHR(args);
            return;
        }
        if (CLIENT.equals(action)) {
            this.handleClientAction(args);
            return;
        }
        if (SCRIPTS.equals(action)) {
            this.handleScripts(args);
            return;
        }
        if (BREAKPOINT.equals(action)) {
            block31: {
                action = args[j++];
                String sourceFile = this.resolveSourceFile(Util.decodeData(args[j++]));
                int lineNumber = -1;
                try {
                    lineNumber = Integer.parseInt(args[j++]);
                }
                catch (NumberFormatException e) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                }
                try {
                    IBreakpoint breakpoint = this.findBreakpointAt(sourceFile, lineNumber);
                    if (CREATE.equals(action) || CHANGE.equals(action)) {
                        boolean enabled = "1".equals(args[j++]);
                        int hitCount = -1;
                        try {
                            hitCount = Integer.parseInt(args[j++]);
                        }
                        catch (NumberFormatException e) {
                            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                        }
                        String condition = Util.decodeData(args[j++]);
                        boolean conditionOnTrue = "1".equals(args[j++]);
                        if (breakpoint == null) {
                            Object resource;
                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                            attributes.put("org.eclipse.debug.core.enabled", enabled);
                            if (hitCount != -1) {
                                attributes.put("com.aptana.ide.debug.core.breakpointHitCount", new Integer(hitCount));
                            }
                            if (condition.length() != 0) {
                                attributes.put("com.aptana.ide.debug.core.breakpointCondition", condition);
                                attributes.put("com.aptana.ide.debug.core.breakpointConditionEnabled", Boolean.TRUE);
                                attributes.put("com.aptana.ide.debug.core.breakpointConditionSuspendOnTrue", conditionOnTrue);
                            }
                            if ((resource = this.findSourceResource(sourceFile)) instanceof IResource) {
                                try {
                                    this.ignoreBreakpointCreation = true;
                                    breakpoint = JSDebugModel.createLineBreakpoint((IResource)resource, lineNumber, attributes, true);
                                    break block31;
                                }
                                finally {
                                    this.ignoreBreakpointCreation = false;
                                }
                            }
                            if (!(resource instanceof IUniformResource)) break block31;
                            try {
                                this.ignoreBreakpointCreation = true;
                                breakpoint = JSDebugModel.createLineBreakpoint((IUniformResource)resource, lineNumber, attributes, true);
                                break block31;
                            }
                            finally {
                                this.ignoreBreakpointCreation = false;
                            }
                        }
                        if (CHANGE.equals(action)) {
                            if (breakpoint.isEnabled() != enabled) {
                                this.skipOperationOnBreakpoint = breakpoint;
                                breakpoint.setEnabled(enabled);
                            }
                            if (breakpoint instanceof IJSLineBreakpoint) {
                                IJSLineBreakpoint lineBreakpoint = (IJSLineBreakpoint)breakpoint;
                                if (lineBreakpoint.getHitCount() != hitCount) {
                                    this.skipOperationOnBreakpoint = breakpoint;
                                    lineBreakpoint.setHitCount(hitCount);
                                }
                                if (!condition.equals(lineBreakpoint.getCondition())) {
                                    this.skipOperationOnBreakpoint = breakpoint;
                                    lineBreakpoint.setCondition(condition);
                                    lineBreakpoint.setConditionEnabled(condition.length() != 0);
                                }
                                if (lineBreakpoint.isConditionSuspendOnTrue() != conditionOnTrue) {
                                    this.skipOperationOnBreakpoint = breakpoint;
                                    lineBreakpoint.setConditionSuspendOnTrue(conditionOnTrue);
                                }
                            }
                        }
                        break block31;
                    }
                    if (REMOVE.equals(action) && breakpoint != null) {
                        this.skipOperationOnBreakpoint = breakpoint;
                        breakpoint.delete();
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                }
            }
            return;
        }
        if (OPENED.equals(action)) {
            this.mainFile = this.resolveSourceFile(Util.decodeData(args[1]));
            DebugEvent event = new DebugEvent((Object)this, 32, 2);
            event.setData((Object)this.mainFile);
            this.fireEvent(event);
            return;
        }
        if (this.threads.length > 0) {
            this.threads[0].handleMessage(args);
        }
    }

    private void handleLog(String[] args) {
        String log = args[1];
        String text = Util.decodeData(args[2]);
        if (args.length >= 4) {
            StringBuffer sb = new StringBuffer(text);
            String type = args[3];
            if (SRC.equals(type) && args.length >= 6) {
                String fileName = this.resolveSourceFile(Util.decodeData(args[4]));
                IFile file = PathUtils.findWorkspaceFile((String)fileName);
                if (file != null) {
                    fileName = file.getFullPath().makeRelative().toString();
                }
                sb.append(StringUtils.format((String)" ({0}:{1})", (Object[])new String[]{fileName, args[5]}));
            } else if (TRACE.equals(type)) {
                sb.append('\n');
                int i = 4;
                while (i < args.length) {
                    String fileName;
                    IFile file;
                    String[] subargs = args[i].split(SUBARGS_SPLIT);
                    if (subargs[0].length() == 0) {
                        subargs[0] = StringUtils.format((String)"[{0}]", (String)(i == args.length - 1 ? Messages.JSDebugTarget_TopLevelScript : Messages.JSDebugTarget_EvalScript));
                    }
                    if ((file = PathUtils.findWorkspaceFile((String)(fileName = this.resolveSourceFile(Util.decodeData(subargs[2]))))) != null) {
                        fileName = file.getFullPath().makeRelative().toString();
                    }
                    sb.append(StringUtils.format((String)"\tat {0}({1}) ({2}:{3})\n", (Object[])new String[]{Util.decodeData(subargs[0]), Util.decodeData(subargs[1]), fileName, subargs[3]}));
                    ++i;
                }
            }
            text = sb.toString();
        }
        if (!text.endsWith("\n")) {
            text = String.valueOf(text) + "\n";
        }
        try {
            if (ERR.equals(log) || EXCEPTION.equals(log)) {
                if (this.err != null) {
                    this.err.write(text.getBytes());
                }
            } else if (this.out != null) {
                this.out.write(text.getBytes());
            }
        }
        catch (IOException e) {
            JSDebugPlugin.log(e);
        }
    }

    private void handleXHR(String[] args) {
        String cmd;
        int j = 1;
        String rid = args[j++];
        if (START.equals(cmd = args[j++])) {
            String method = args[j++];
            String url = Util.decodeData(args[j++]);
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            String body = Util.decodeData(args[j++]);
            this.xhrService.openRequest(rid, method, url, false);
            this.xhrService.setRequestHeaders(rid, headers);
            this.xhrService.setRequestBody(rid, body);
        } else if (LOAD.equals(cmd)) {
            int statusCode = -1;
            try {
                statusCode = Integer.parseInt(args[j++]);
            }
            catch (NumberFormatException numberFormatException) {}
            String statusText = Util.decodeData(args[j++]);
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            String response = Util.decodeData(args[j++]);
            this.xhrService.setResponseStatus(rid, statusCode, statusText);
            this.xhrService.setResponseHeaders(rid, headers);
            this.xhrService.setResponseBody(rid, response);
        } else if (OPEN.equals(cmd)) {
            String method = args[j++];
            String url = Util.decodeData(args[j++]);
            String auth = args[j++];
            this.xhrService.openRequest(rid, method, url, AUTH.equals(auth));
        } else if (HEADERS.equals(cmd)) {
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            this.xhrService.setRequestHeaders(rid, headers);
        } else if (SEND.equals(cmd)) {
            String body = Util.decodeData(args[j++]);
            this.xhrService.setRequestBody(rid, body);
        } else if (LOADED.equals(cmd)) {
            int statusCode = -1;
            try {
                statusCode = Integer.parseInt(args[j++]);
            }
            catch (NumberFormatException numberFormatException) {}
            String statusText = Util.decodeData(args[j++]);
            String[][] headers = JSDebugTarget.getXHRHeaders(Util.decodeData(args[j++]));
            this.xhrService.setResponseHeaders(rid, headers);
            this.xhrService.setResponseStatus(rid, statusCode, statusText);
        } else if (COMPLETED.equals(cmd)) {
            String response = Util.decodeData(args[j++]);
            this.xhrService.setResponseBody(rid, response);
        } else if (ERROR.equals(cmd)) {
            this.xhrService.setError(rid);
        }
    }

    private static String[][] getXHRHeaders(String string) {
        String[] headers = string.split("\\n");
        ArrayList<String[]> list = new ArrayList<String[]>(headers.length);
        int i = 0;
        while (i < headers.length) {
            String header = headers[i];
            String value = "";
            int pos = header.indexOf(": ");
            if (pos != -1) {
                value = header.substring(pos + 2);
                header = header.substring(0, pos);
            }
            list.add(new String[]{header, value});
            ++i;
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    private void handleClientAction(String[] args) {
        String fileName;
        String action;
        int j = 1;
        if (SUSPEND.equals(action = args[j++])) {
            try {
                if (this.canSuspend()) {
                    this.suspend();
                }
            }
            catch (DebugException debugException) {}
        } else if (TERMINATE.equals(action)) {
            try {
                if (this.canTerminate()) {
                    this.terminate();
                }
            }
            catch (DebugException debugException) {}
        } else if (OPEN.equals(action) && (fileName = this.resolveSourceFile(Util.decodeData(args[j++]))) != null) {
            Object sourceElement = null;
            ISourceLocator locator = this.launch.getSourceLocator();
            if (locator instanceof ISourceLookupDirector) {
                sourceElement = ((ISourceLookupDirector)locator).getSourceElement((Object)fileName);
            }
            if (sourceElement != null) {
                JSDebugPlugin.getDefault().openInEditor(sourceElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleScripts(String[] args) {
        block24: {
            String action;
            block23: {
                action = args[1];
                if (CREATED.equals(action)) {
                    int i22 = 2;
                    while (i22 < args.length) {
                        int j = 0;
                        String[] subargs = args[i22].split(SUBARGS_SPLIT);
                        if (subargs.length < 5) {
                            IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Missing fields in response: <{0}>", (String)args[i22]));
                        } else {
                            int scriptTag = -1;
                            try {
                                scriptTag = Integer.parseInt(subargs[j++]);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            String fileName = Util.decodeData(subargs[j++]);
                            if (fileName.length() != 0 && !"[Eval-script]".equals(fileName) && !fileName.startsWith(JAVASCRIPT_SCHEME)) {
                                fileName = this.resolveSourceFile(fileName);
                                String scriptName = Util.decodeData(subargs[j++]);
                                int baseLine = -1;
                                int lineExtent = -1;
                                try {
                                    baseLine = Integer.parseInt(subargs[j++]);
                                    lineExtent = Integer.parseInt(subargs[j++]);
                                }
                                catch (NumberFormatException numberFormatException) {}
                                if (scriptName.length() != 0) {
                                    JSDebugScriptElement topScriptElement = (JSDebugScriptElement)this.topScriptElements.get(fileName);
                                    if (topScriptElement == null) {
                                        String name = fileName;
                                        IFile file = PathUtils.findWorkspaceFile((String)fileName);
                                        if (file != null) {
                                            name = file.getFullPath().toString();
                                        }
                                        topScriptElement = new JSDebugTopScriptElement(this, name, fileName);
                                        this.topScriptElements.put(fileName, topScriptElement);
                                    }
                                    JSDebugScriptElement scriptElement = new JSDebugScriptElement(this, scriptName, baseLine, lineExtent);
                                    topScriptElement.insertElement(scriptElement);
                                    if (scriptTag > 0) {
                                        this.scripts.put(new Integer(scriptTag), scriptElement);
                                    }
                                }
                            }
                        }
                        ++i22;
                    }
                    Job i22 = this.updateContentJob;
                    synchronized (i22) {
                        this.contentChanged = true;
                    }
                }
                if (!DESTROYED.equals(action)) break block23;
                int j = 0;
                String[] subargs = args[2].split(SUBARGS_SPLIT);
                int scriptTag = -1;
                try {
                    scriptTag = Integer.parseInt(subargs[j++]);
                }
                catch (NumberFormatException numberFormatException) {}
                String fileName = this.resolveSourceFile(Util.decodeData(subargs[j++]));
                JSDebugScriptElement topScriptElement = (JSDebugScriptElement)this.topScriptElements.get(fileName);
                if (scriptTag <= 0) break block24;
                JSDebugScriptElement scriptElement = (JSDebugScriptElement)this.scripts.remove(new Integer(scriptTag));
                if (topScriptElement == null || scriptElement == null) break block24;
                topScriptElement.removeElement(scriptElement);
                break block24;
            }
            if (RESOLVED.equals(action)) {
                int i = 2;
                while (i < args.length) {
                    JSDebugScriptElement scriptElement;
                    int j = 0;
                    String[] subargs = args[i].split(SUBARGS_SPLIT);
                    int scriptTag = -1;
                    try {
                        scriptTag = Integer.parseInt(subargs[j++]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    String scriptName = Util.decodeData(subargs[j++]);
                    if (scriptTag >= 0 && scriptName.length() != 0 && (scriptElement = (JSDebugScriptElement)this.scripts.get(new Integer(scriptTag))) != null) {
                        scriptElement.setName(scriptName);
                        scriptElement.fireChangeEvent(256);
                    }
                    ++i;
                }
            }
        }
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.threads.length > 0;
    }

    public String getName() throws DebugException {
        return this.label != null ? this.label : Messages.JSDebugTarget_JSDebugger;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals(this.getModelIdentifier());
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.connection.isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        this.connection.sendCommand(TERMINATE);
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.threads.length > 0 ? this.threads[0].isSuspended() : false;
    }

    public void resume() throws DebugException {
        this.threads[0].resume();
    }

    public void suspend() throws DebugException {
        if (this.isDisconnected()) {
            return;
        }
        this.threads[0].suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof IJSLineBreakpoint) {
            try {
                if (((IJSLineBreakpoint)breakpoint).isRunToLine()) {
                    this.runToLineBreakpoints.add(breakpoint);
                }
            }
            catch (CoreException coreException) {}
        }
        this.handleBreakpoint(breakpoint, CREATE);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof IJSLineBreakpoint) {
            try {
                if (((IJSLineBreakpoint)breakpoint).isRunToLine()) {
                    this.runToLineBreakpoints.remove(breakpoint);
                }
            }
            catch (CoreException coreException) {}
        }
        this.handleBreakpoint(breakpoint, REMOVE);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.handleBreakpoint(breakpoint, CHANGE);
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.connection.sendCommandAndWait(DISABLE);
        this.stopDebug();
    }

    public boolean isDisconnected() {
        return !this.connection.isConnected();
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.throwNotImplemented();
        return null;
    }

    public boolean isFilterConstructors() {
        return (this.stepFilterMask & 2) > 0;
    }

    public void setFilterConstructors(boolean filter) {
        this.stepFilterMask = filter ? (this.stepFilterMask |= 2) : (this.stepFilterMask &= 0xFFD);
    }

    public boolean isStepFiltersEnabled() {
        return (this.stepFilterMask & 1) > 0;
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.stepFilterMask = enabled ? (this.stepFilterMask |= 1) : (this.stepFilterMask &= 0xFFE);
        try {
            this.setOption("stepFiltersEnabled", Boolean.toString(this.isStepFiltersEnabled()));
        }
        catch (DebugException debugException) {}
    }

    public boolean supportsStepFilters() {
        return !this.isTerminated() && !this.isDisconnected();
    }

    public String[] getStepFilters() {
        return this.stepFilters;
    }

    public void setStepFilters(String[] list) {
        this.stepFilters = list;
    }

    public String getAttribute(String key) {
        return this.getLaunch().getAttribute(key);
    }

    public void setAttribute(String key, String value) {
        this.getLaunch().setAttribute(key, value);
        try {
            this.handleAttribute(key);
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    private void handleAttribute(String key) throws DebugException {
        String value = this.getAttribute(key);
        boolean boolValue = Boolean.valueOf(value);
        if ("suspendOnFirstLine".equals(key)) {
            this.setOption("suspendOnFirstLine", Boolean.toString(boolValue));
        } else if ("suspendOnExceptions".equals(key)) {
            this.setOption("suspendOnExceptions", Boolean.toString(boolValue));
        } else if ("suspendOnErrors".equals(key)) {
            this.setOption("suspendOnErrors", Boolean.toString(boolValue));
        } else if ("suspendOnDebuggerKeywords".equals(key)) {
            this.setOption("suspendOnKeywords", Boolean.toString(boolValue));
        }
    }

    public void detailFormattersChanged() {
        try {
            this.handleDetailFormattersChange();
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    private void handleDetailFormattersChange() throws DebugException {
        Collection detailformatters = JSDetailFormattersManager.getDefault().getDetailFormatters();
        StringBuffer sb = new StringBuffer(DETAIL_FORMATTERS);
        if (!detailformatters.isEmpty()) {
            for (DetailFormatter detailFormatter : detailformatters) {
                if (!detailFormatter.isEnabled()) continue;
                sb.append(StringUtils.format((String)"*{0}|{1}", (Object[])new String[]{detailFormatter.getTypeName(), Util.encodeData(detailFormatter.getSnippet())}));
            }
        }
        this.connection.sendCommandAndWait(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean debugMode) throws CoreException {
        JSDebugTarget jSDebugTarget = this;
        synchronized (jSDebugTarget) {
            this.connection.start(this);
            this.updateContentJob.schedule();
            this.checkVersion();
        }
        this.xhrService = new XHRService();
        this.setOption(MONITOR_XHR, Boolean.toString(true));
        if (this.process instanceof JSDebugProcess) {
            ((JSDebugProcess)this.process).setXHRService(this.xhrService);
        }
        if (debugMode) {
            int i;
            this.fireCreationEvent();
            JSDebugThread thread = new JSDebugThread(this);
            this.threads = new JSDebugThread[]{thread};
            int i2 = 0;
            while (i2 < this.threads.length) {
                this.threads[i2].fireCreationEvent();
                ++i2;
            }
            this.fireChangeEvent(512);
            this.handleAttribute("suspendOnFirstLine");
            this.handleAttribute("suspendOnExceptions");
            this.handleAttribute("suspendOnErrors");
            this.handleAttribute("suspendOnDebuggerKeywords");
            this.setOption("bypassConstructors", Boolean.toString(this.isFilterConstructors()));
            this.setOption("stepFiltersEnabled", Boolean.toString(this.isStepFiltersEnabled()));
            if (this.stepFilters != null && this.stepFilters.length > 0) {
                StringBuffer sb = new StringBuffer(STEP_FILTERS);
                i = 0;
                while (i < this.stepFilters.length) {
                    sb.append(i != 0 ? (char)'|' : '*').append(Util.encodeData(this.stepFilters[i]));
                    ++i;
                }
                this.connection.sendCommandAndWait(sb.toString());
            }
            this.handleDetailFormattersChange();
            JSDetailFormattersManager.getDefault().addChangeListener(this);
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
            i = 0;
            while (i < breakpoints.length) {
                this.breakpointAdded(breakpoints[i]);
                ++i;
            }
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
            this.connection.sendCommandAndWait(ENABLE);
        }
        if (this.process instanceof JSDebugProcess) {
            this.out = ((JSDebugProcess)this.process).getOutputStream();
            this.err = ((JSDebugProcess)this.process).getErrorStream();
        }
    }

    private void checkVersion() throws DebugException {
        int protoVersion = 0;
        String version = null;
        String[] args = this.connection.sendCommandAndWait(VERSION);
        if (args != null && args.length >= 3 && args[1].charAt(0) != '!') {
            IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Extension version: {0}; protocol v{1}", (Object[])new String[]{args[2], args[1]}));
            try {
                protoVersion = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException numberFormatException) {}
            version = args[2];
        }
        if (protoVersion < 0 || protoVersion > 1) {
            this.throwDebugException(StringUtils.format((String)"Incompatible debugger extension protocol version {0} for [{1},{2}]", (Object[])new String[]{Integer.toString(protoVersion), Integer.toString(0), Integer.toString(1)}));
        }
        if (checkUpdate) {
            boolean update = false;
            if (version != null) {
                String pluginVersion = (String)Platform.getBundle((String)"com.aptana.ide.debug.core").getHeaders().get("Bundle-Version");
                int index = pluginVersion.lastIndexOf(46);
                if (index != -1) {
                    if (index >= version.length() || !pluginVersion.substring(0, index).equals(version.substring(0, index))) {
                        update = true;
                    } else if (!pluginVersion.substring(index + 1).equals(version.substring(index + 1))) {
                        try {
                            if (Integer.parseInt(pluginVersion.substring(index + 1)) > Integer.parseInt(version.substring(index + 1))) {
                                update = true;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                if (update && (args = this.connection.sendCommandAndWait(UPDATE)) != null && args.length >= 2) {
                    IdeLog.logInfo((Plugin)JSDebugPlugin.getDefault(), (String)StringUtils.format((String)"Extension update available: {0}", (Object[])new String[]{args[1]}));
                }
            }
            checkUpdate = false;
        }
    }

    private synchronized void setOption(String option, String value) throws DebugException {
        if (this.connection.isConnected()) {
            this.connection.sendCommandAndWait(StringUtils.format((String)OPTION_0_1, (Object[])new String[]{option, value}));
        }
    }

    public void openURL(URL url) throws DebugException {
        if (this.connection.isConnected()) {
            try {
                DebugEvent event = new DebugEvent((Object)this, 32, 1);
                URL fileUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
                event.setData((Object)this.resolveSourceFile(fileUrl.toExternalForm()));
                this.fireEvent(event);
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
            this.mainFile = null;
            this.connection.sendCommandAndWait(StringUtils.format((String)OPEN_URL_0, (String)Util.encodeData(url.toString())));
        }
    }

    private void stopDebug() throws DebugException {
        if (this.connection == null || !this.connection.isConnected()) {
            return;
        }
        this.connection.stop();
        this.updateContentJob.cancel();
        if (this.threads.length > 0) {
            int i = 0;
            while (i < this.threads.length) {
                this.threads[i].fireTerminateEvent();
                ++i;
            }
            this.threads = new JSDebugThread[0];
            this.topScriptElements.clear();
            this.scripts.clear();
            this.fireChangeEvent(512);
            JSDetailFormattersManager.getDefault().removeChangeListener(this);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        }
    }

    public void handleShutdown() {
        try {
            this.shutdown();
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    private void shutdown() throws DebugException {
        try {
            try {
                this.stopDebug();
                if (this.connection != null) {
                    this.connection.dispose();
                }
            }
            catch (IOException e) {
                this.throwDebugException(e);
            }
        }
        finally {
            if (DebugPlugin.getDefault() != null) {
                this.fireTerminateEvent();
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (enabled) {
                this.breakpointAdded(breakpoint);
            } else {
                this.breakpointRemoved(breakpoint, null);
            }
            ++i;
        }
    }

    protected IVariable[] loadVariables(String qualifier) throws DebugException {
        if (!this.isSuspended()) {
            return new IVariable[0];
        }
        ArrayList<JSDebugVariable> list = new ArrayList<JSDebugVariable>();
        String[] args = this.connection.sendCommandAndWait(StringUtils.format((String)VARIABLES_0, (String)Util.encodeData(qualifier)));
        if (args != null) {
            int i = 1;
            while (i < args.length) {
                int j = 0;
                String varData = args[i];
                if (varData.length() == 0) break;
                if (varData.endsWith("|")) {
                    varData = String.valueOf(varData) + "| ";
                }
                String[] subargs = varData.split(SUBARGS_SPLIT);
                String name = Util.decodeData(subargs[j++]);
                String type = Util.decodeData(subargs[j++]);
                String flags = subargs[j++];
                String stringValue = Util.decodeData(subargs[j++]);
                boolean complex = flags.indexOf(111) != -1;
                String q = StringUtils.format((String)"{0}.{1}", (Object[])new String[]{qualifier, name});
                JSDebugValue ivalue = new JSDebugValue(this, q, type, complex, stringValue);
                list.add(new JSDebugVariable(this, q, name, ivalue, JSDebugTarget.convertVariableFlags(flags)));
                ++i;
            }
        }
        return list.toArray(new IVariable[list.size()]);
    }

    protected Object evaluateExpression(String expression, IDebugElement context) throws DebugException {
        String status;
        String qualifier;
        if (!this.isSuspended()) {
            return null;
        }
        Object result = null;
        if (context instanceof JSDebugStackFrame) {
            qualifier = StringUtils.format((String)FRAME_0, (int)((JSDebugStackFrame)context).getFrameId());
        } else if (context instanceof JSDebugVariable) {
            qualifier = ((JSDebugVariable)context).getQualifier();
        } else {
            return result;
        }
        String[] args = this.connection.sendCommandAndWait(StringUtils.format((String)EVAL_0_1, (Object[])new String[]{Util.encodeData(qualifier), Util.encodeData(expression)}));
        String string = status = args != null && args.length > 1 ? args[1] : null;
        if (RESULT.equals(status)) {
            String evalId = args[2];
            String varData = args[3];
            if (varData.endsWith("|")) {
                varData = String.valueOf(varData) + "| ";
            }
            String[] subargs = varData.split(SUBARGS_SPLIT);
            int j = 0;
            String type = subargs[j++];
            String flags = subargs[j++];
            String stringValue = Util.decodeData(subargs[j++]);
            boolean complex = flags.indexOf(111) != -1;
            result = new JSDebugValue(this, StringUtils.format((String)EVAL_0, (String)evalId), type, complex, stringValue);
        } else if (EXCEPTION.equals(status)) {
            result = new String[]{args[2]};
        }
        return result;
    }

    protected Object setValue(IVariable variable, IValue newValue) throws DebugException {
        if (!this.isSuspended()) {
            return null;
        }
        Object result = null;
        if (!(variable instanceof JSDebugVariable)) {
            return result;
        }
        String qualifier = ((JSDebugVariable)variable).getQualifier();
        if (!(newValue instanceof JSDebugValue)) {
            return result;
        }
        String vqualifier = ((JSDebugValue)newValue).getQualifier();
        String[] args = this.connection.sendCommandAndWait(StringUtils.format((String)SET_VALUE_0_1, (Object[])new String[]{Util.encodeData(qualifier), vqualifier}));
        if (args != null && args.length >= 3) {
            String status = args[1];
            if (RESULT.equals(status)) {
                String[] subargs = args[2].split(SUBARGS_SPLIT);
                int j = 0;
                String type = subargs[j++];
                String flags = subargs[j++];
                String stringValue = Util.decodeData(subargs[j++]);
                boolean complex = flags.indexOf(111) != -1;
                result = new JSDebugValue(this, qualifier, type, complex, stringValue);
            } else if (EXCEPTION.equals(status)) {
                result = new String[]{args[2]};
            }
        }
        return result;
    }

    public String computeValueDetails(IValue value) throws DebugException {
        String status;
        if (!this.isSuspended()) {
            return "";
        }
        String result = null;
        if (!(value instanceof JSDebugValue)) {
            return value.getValueString();
        }
        String qualifier = ((JSDebugValue)value).getQualifier();
        String[] args = this.connection.sendCommandAndWait(StringUtils.format((String)DETAILS_0, (String)Util.encodeData(qualifier)));
        if (args != null && args.length >= 3 && RESULT.equals(status = args[1])) {
            result = Util.decodeData(args[2]);
        }
        if (result == null) {
            result = value.getValueString();
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    protected IVariable findVariable(String variableName, IDebugElement context) throws DebugException {
        Object result;
        if (Util.checkVariable(variableName) && (result = this.evaluateExpression(variableName, context)) instanceof IValue) {
            return new JSDebugVariable((IDebugTarget)this, null, variableName, (IValue)result);
        }
        return null;
    }

    private void handleBreakpoint(IBreakpoint breakpoint, String operation) {
        if (this.isDisconnected()) {
            return;
        }
        if (breakpoint.equals(this.skipOperationOnBreakpoint)) {
            this.skipOperationOnBreakpoint = null;
            return;
        }
        if (CREATE.equals(operation) && this.ignoreBreakpointCreation) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            if (breakpoint instanceof IJSLineBreakpoint) {
                this.handleLineBreakpoint((IJSLineBreakpoint)breakpoint, operation);
            } else if (breakpoint instanceof IJSExceptionBreakpoint) {
                this.handleExceptionBreakpoint((IJSExceptionBreakpoint)breakpoint, operation);
            } else if (breakpoint instanceof IJSWatchpoint) {
                this.handleWatchpoint((IJSWatchpoint)breakpoint, operation);
            }
        }
    }

    private void handleLineBreakpoint(IJSLineBreakpoint breakpoint, String operation) {
        int lineNumber;
        IMarker marker = breakpoint.getMarker();
        URL url = null;
        String properties = "";
        try {
            IResource resource;
            URI uri = null;
            uri = marker instanceof IUniformResourceMarker ? ((IUniformResourceMarker)marker).getUniformResource().getURI() : ((resource = marker.getResource()) instanceof IWorkspaceRoot ? (URI)marker.getAttribute("com.aptana.ide.debug.core.breakpointLocation") : resource.getLocation().makeAbsolute().toFile().toURI());
            if (uri != null && this.resourceMapper != null) {
                uri = this.resourceMapper.resolveLocalURI(uri);
            }
            if (uri != null) {
                url = "dbgsource".equals(uri.getScheme()) ? new URL(null, uri.toString(), DbgSourceURLStreamHandler.getDefault()) : uri.toURL();
            }
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        if ((lineNumber = marker.getAttribute("lineNumber", -1)) == -1) {
            return;
        }
        boolean remove = REMOVE.equals(operation);
        if (!remove) {
            boolean enabled = false;
            try {
                enabled = breakpoint.isEnabled();
            }
            catch (CoreException coreException) {}
            int hitCount = marker.getAttribute("com.aptana.ide.debug.core.breakpointHitCount", 0);
            boolean conditionEnabled = marker.getAttribute("com.aptana.ide.debug.core.breakpointConditionEnabled", false);
            String condition = conditionEnabled ? marker.getAttribute("com.aptana.ide.debug.core.breakpointCondition", "") : "";
            String suspendOnTrue = marker.getAttribute("com.aptana.ide.debug.core.breakpointConditionSuspendOnTrue", true) ? "1" : "0";
            properties = StringUtils.format((String)"*{0}*{1}*{2}*{3}", (Object[])new String[]{enabled ? "1" : "0", Integer.toString(hitCount), Util.encodeData(condition), suspendOnTrue});
        }
        try {
            String[] args = this.connection.sendCommandAndWait(StringUtils.format((String)BREAKPOINT_0_1_2_3, (Object[])new String[]{operation, Util.encodeData(url.toString()), Integer.toString(lineNumber), properties}));
            if (!(remove || args != null && args.length >= 2 && (String.valueOf(operation) + 'd').equals(args[1]))) {
                breakpoint.setEnabled(false);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    private void handleExceptionBreakpoint(IJSExceptionBreakpoint breakpoint, String operation) {
        IMarker marker = breakpoint.getMarker();
        String exceptionTypeName = marker.getAttribute("com.aptana.ide.debug.core.exceptionTypeName", "");
        if (exceptionTypeName == null || exceptionTypeName.length() == 0) {
            return;
        }
        boolean enabled = false;
        try {
            enabled = breakpoint.isEnabled();
        }
        catch (CoreException coreException) {}
        if (!enabled) {
            operation = REMOVE;
        }
        enabled = !REMOVE.equals(operation);
        try {
            String[] args = this.connection.sendCommandAndWait(StringUtils.format((String)EXCEPTION_0_1, (Object[])new String[]{operation, exceptionTypeName}));
            if (enabled && (args == null || !(String.valueOf(operation) + 'd').equals(args[1]))) {
                breakpoint.setEnabled(false);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    private void handleWatchpoint(IJSWatchpoint watchpoint, String operation) {
        IMarker marker = watchpoint.getMarker();
        String variableName = marker.getAttribute("com.aptana.ide.debug.core.watchpointVariableAccessor", "");
        boolean enabled = false;
        try {
            enabled = watchpoint.isEnabled();
        }
        catch (CoreException coreException) {}
        if (!enabled) {
            if (CREATE.equals(operation)) {
                return;
            }
            operation = REMOVE;
        }
        enabled = !REMOVE.equals(operation);
        String kind = "";
        if (enabled) {
            try {
                if (watchpoint.isAccess()) {
                    kind = String.valueOf(kind) + 'r';
                }
                if (watchpoint.isModification()) {
                    kind = String.valueOf(kind) + 'w';
                }
            }
            catch (CoreException coreException) {}
        }
        try {
            String[] args = this.connection.sendCommandAndWait(StringUtils.format((String)WATCHPOINT_0_1_2, (Object[])new String[]{operation, Util.encodeData(variableName), kind}));
            if (enabled && (args == null || args.length < 2 || !(String.valueOf(operation) + 'd').equals(args[1]))) {
                watchpoint.setEnabled(false);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
    }

    protected IBreakpoint findBreakpointAt(String filename, int lineNumber) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        IBreakpoint breakpoint = this.findBreakpointIn(filename, lineNumber, breakpoints);
        if (breakpoint != null) {
            return breakpoint;
        }
        if (!this.runToLineBreakpoints.isEmpty()) {
            return this.findBreakpointIn(filename, lineNumber, this.runToLineBreakpoints.toArray(new IBreakpoint[this.runToLineBreakpoints.size()]));
        }
        return null;
    }

    protected IBreakpoint findBreakpointIn(String filename, int lineNumber, IBreakpoint[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (this.getDebugTarget().supportsBreakpoint(breakpoint) && breakpoint instanceof ILineBreakpoint) {
                try {
                    URI breakpointURI;
                    IMarker marker = breakpoint.getMarker();
                    boolean fileMatched = false;
                    if (marker instanceof IUniformResourceMarker) {
                        breakpointURI = ((IUniformResourceMarker)marker).getUniformResource().getURI();
                        fileMatched = new URI(Util.fixupURI(filename)).equals(breakpointURI);
                    } else if (marker.getResource() instanceof IWorkspaceRoot) {
                        breakpointURI = (URI)marker.getAttribute("com.aptana.ide.debug.core.breakpointLocation");
                        fileMatched = new URI(Util.fixupURI(filename)).equals(breakpointURI);
                    } else {
                        IFile file = PathUtils.findWorkspaceFile((String)filename);
                        if (file != null) {
                            fileMatched = file.equals((Object)marker.getResource());
                        } else {
                            File breakpointFile = marker.getResource().getLocation().toFile();
                            fileMatched = new File(filename).equals(breakpointFile);
                        }
                    }
                    if (fileMatched && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                        return breakpoint;
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
                }
            }
            ++i;
        }
        return null;
    }

    protected String resolveSourceFile(String sourceFile) {
        String resolved = this.sourceResolveCache.get(sourceFile);
        if (resolved != null) {
            return resolved;
        }
        try {
            block15: {
                URI uri = new URI(sourceFile);
                String scheme = uri.getScheme();
                if (FILE.equals(scheme)) {
                    try {
                        File osFile = new File(uri.getSchemeSpecificPart());
                        Path canonicalPath = new Path(osFile.getCanonicalPath());
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)canonicalPath);
                        if (file != null) {
                            resolved = file.getLocation().toString();
                            break block15;
                        }
                        resolved = osFile.getAbsolutePath();
                    }
                    catch (IOException iOException) {}
                } else if (HTTP.equals(scheme) && this.resourceMapper != null) {
                    File osFile = this.resourceMapper.resolveServerURL(uri.toURL());
                    if (osFile != null) {
                        resolved = osFile.getAbsolutePath();
                    }
                } else if (JAVASCRIPT.equals(scheme) && this.mainFile != null) {
                    return this.mainFile;
                }
            }
            if (resolved != null) {
                this.sourceResolveCache.put(sourceFile, resolved);
                return resolved;
            }
        }
        catch (URISyntaxException e) {
            if (sourceFile.startsWith(JAVASCRIPT_SCHEME) && this.mainFile != null) {
                return this.mainFile;
            }
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        return sourceFile;
    }

    private Object findSourceResource(String sourceFile) throws CoreException {
        ISourceLookupDirector lookupDirector;
        Object[] result;
        ISourceLocator locator = this.launch.getSourceLocator();
        if (locator instanceof ISourceLookupDirector && (result = (lookupDirector = (ISourceLookupDirector)locator).findSourceElements((Object)sourceFile)) != null && result.length > 0) {
            Object adopted;
            Object resource = result[0];
            if (resource instanceof IResource) {
                return resource;
            }
            if (!(resource instanceof IUniformResource) && resource instanceof IAdaptable && (adopted = ((IAdaptable)resource).getAdapter(IUniformResource.class)) != null) {
                resource = adopted;
            }
            return resource;
        }
        return null;
    }

    private static int convertVariableFlags(String string) {
        int flags = 0;
        char[] chars = string.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case 'w': {
                    flags |= 1;
                    break;
                }
                case 'c': {
                    flags |= 0x10;
                    break;
                }
                case 'l': {
                    flags |= 2;
                    break;
                }
                case 'a': {
                    flags |= 4;
                    break;
                }
                case 'e': {
                    flags |= 8;
                    break;
                }
            }
            ++i;
        }
        return flags;
    }

    public IJSScriptElement[] getTopScriptElements() {
        return this.topScriptElements.values().toArray(new IJSScriptElement[this.topScriptElements.size()]);
    }
}

