/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.internal.core.model.JSDebugElement;
import com.aptana.ide.debug.internal.core.model.JSDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class JSDebugValue
extends JSDebugElement
implements IValue {
    private String qualifier;
    private String typeName;
    private boolean hasVariables;
    private String valueString;
    private IVariable[] variables;

    public JSDebugValue(IDebugTarget target, String qualifier, String typeName, boolean hasVariables, String valueString) {
        super(target);
        this.qualifier = qualifier;
        this.typeName = typeName;
        this.hasVariables = hasVariables;
        this.valueString = valueString;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.typeName;
    }

    public String getValueString() throws DebugException {
        return this.valueString != null ? this.valueString : StringUtils.format((String)"'''{'{0}}", (String)this.typeName);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.hasVariables) {
            this.getVariables0();
        }
        return this.variables != null ? this.variables : new IVariable[]{};
    }

    public boolean hasVariables() throws DebugException {
        return this.hasVariables;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    private void getVariables0() throws DebugException {
        if (this.variables != null) {
            return;
        }
        this.variables = ((JSDebugTarget)this.getDebugTarget()).loadVariables(this.qualifier);
        this.hasVariables = this.variables != null && this.variables.length > 0;
    }
}

