/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.model;

import com.aptana.ide.debug.internal.core.model.JSDebugTarget;
import com.aptana.ide.debug.internal.core.model.Messages;
import com.aptana.ide.debug.internal.core.model.WatchExpressionResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class WatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        IDebugTarget target = context.getDebugTarget();
        if (target.isSuspended() && target instanceof JSDebugTarget) {
            EvaluationJob job = new EvaluationJob((JSDebugTarget)target, expression, context, listener);
            job.schedule();
            return;
        }
        listener.watchEvaluationFinished(null);
    }

    private final class EvaluationJob
    extends Job {
        private JSDebugTarget target;
        private String expression;
        private IDebugElement context;
        private IWatchExpressionListener listener;

        public EvaluationJob(JSDebugTarget target, String expression, IDebugElement context, IWatchExpressionListener listener) {
            super(Messages.WatchExpressionDelegate_ExpressionEvaluation);
            this.setSystem(true);
            this.target = target;
            this.expression = expression;
            this.context = context;
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            WatchExpressionResult watchResult = null;
            try {
                Object result = this.target.evaluateExpression(this.expression, this.context);
                if (result instanceof IValue) {
                    watchResult = new WatchExpressionResult(this.expression, (IValue)result);
                } else if (result instanceof String[]) {
                    watchResult = new WatchExpressionResult(this.expression, null, (String[])result);
                }
            }
            catch (DebugException e) {
                watchResult = new WatchExpressionResult(this.expression, e, null);
            }
            this.listener.watchEvaluationFinished((IWatchExpressionResult)watchResult);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)WatchExpressionDelegate.this, 2, 128)});
            return Status.OK_STATUS;
        }
    }
}

