/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.core.sourcelookup;

import com.aptana.ide.core.resources.LocalFileStorage;
import com.aptana.ide.debug.internal.core.sourcelookup.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class JSSourceContainer
extends AbstractSourceContainer {
    private IWorkspaceRoot fRoot = ResourcesPlugin.getWorkspace().getRoot();

    public Object[] findSourceElements(String path) throws CoreException {
        ArrayList<Object> sources = new ArrayList<Object>();
        Path ipath = new Path(path);
        if (ipath.isAbsolute()) {
            File osFile = new File(path);
            if (osFile.exists()) {
                try {
                    Path canonicalPath = new Path(osFile.getCanonicalPath());
                    IFile[] files = this.fRoot.findFilesForLocation((IPath)canonicalPath);
                    if (files.length > 0) {
                        int i = 0;
                        while (i < files.length) {
                            sources.add(files[i]);
                            ++i;
                        }
                    } else {
                        sources.add(new LocalFileStorage(osFile));
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            IResource res = this.fRoot.findMember((IPath)ipath);
            if (res instanceof IFile) {
                sources.add(res);
            }
        }
        return sources.toArray();
    }

    public String getName() {
        return Messages.JSSourceContainer_LocalFileSourceContainer;
    }

    public ISourceContainerType getType() {
        return null;
    }
}

