/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editor.xml.validator.ColorizationValidator;
import com.aptana.ide.editor.xml.validator.LexerValidator;
import com.aptana.ide.editor.xml.validator.XMLValidator;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.Messages;
import com.aptana.ide.editors.unified.errors.UnifiedErrorManager;
import com.aptana.ide.editors.validator.ValidatorBase;
import java.io.IOException;
import java.util.Locale;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class XMLErrorManager
extends UnifiedErrorManager
implements IErrorManager {
    private ColorizationValidator _colorizationValidator;
    private LexerValidator _lexerValidator;
    private XMLValidator _xmlValidator;

    public XMLErrorManager(FileService fileService) {
        super(fileService, "text/xml");
    }

    public ColorizationValidator getColorizationValidator() {
        if (this._colorizationValidator == null) {
            this._colorizationValidator = new ColorizationValidator();
        }
        return this._colorizationValidator;
    }

    public LexerValidator getLexerValidator() {
        if (this._lexerValidator == null) {
            this._lexerValidator = new LexerValidator();
        }
        return this._lexerValidator;
    }

    public XMLValidator getXMLValidator() {
        if (this._xmlValidator == null) {
            this._xmlValidator = new XMLValidator();
        }
        return this._xmlValidator;
    }

    protected IPreferenceStore getPreferenceStore() {
        return XMLPlugin.getDefault().getPreferenceStore();
    }

    public void onContentChanged(FileContextContentEvent evt) {
        IFileService fileService = evt.getSource();
        IFileSourceProvider sourceProvider = fileService.getSourceProvider();
        String path = CoreUIUtils.getPathFromURI((String)sourceProvider.getSourceURI());
        String lowercasePath = path.toLowerCase(Locale.getDefault());
        try {
            String sourceString = sourceProvider.getSource();
            if (sourceProvider instanceof DocumentSourceProvider) {
                ValidatorBase validator = null;
                if (lowercasePath.endsWith(".lxr")) {
                    validator = this.getLexerValidator();
                } else if (lowercasePath.endsWith(".col")) {
                    validator = this.getColorizationValidator();
                } else {
                    super.onContentChanged(evt);
                    return;
                }
                if (validator != null) {
                    IFileError[] errors = validator.parseForErrors(path, sourceString, sourceProvider, true, true, false);
                    fileService.setFileErrors(errors);
                }
            }
        }
        catch (IOException e1) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedErrorManager_Error, (Throwable)e1);
        }
    }
}

