/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.xml.XMLEnvironmentRegistry;
import com.aptana.ide.editor.xml.XMLOffsetMapper;
import com.aptana.ide.editor.xml.formatting.XMLUtils;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.metadata.IMetadataItem;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import java.util.Hashtable;

public class XMLFileLanguageService
extends BaseFileLanguageService {
    private boolean isProfileMember;
    private XMLOffsetMapper offsetMapper;

    protected XMLFileLanguageService(FileService fileService, IParseState parseState, IParser parser, IParentOffsetMapper mapper) {
        super(fileService, parseState, parser, mapper);
        this.createOffsetMapper(mapper);
    }

    public String getDefaultLanguage() {
        return "text/xml";
    }

    public boolean isProfileMember() {
        return this.isProfileMember;
    }

    public void setProfileMember(boolean isProfileMember) {
        this.isProfileMember = isProfileMember;
    }

    public void reset(boolean resetFileIndex) {
    }

    public IOffsetMapper getOffsetMapper() {
        return this.offsetMapper;
    }

    public void createOffsetMapper(IParentOffsetMapper parent) {
        this.offsetMapper = new XMLOffsetMapper(parent);
    }

    public String getDocumentationFromLexeme(Lexeme lexeme) {
        LexemeList lexemeList = this.getParseState().getLexemeList();
        IMetadataEnvironment environment = XMLEnvironmentRegistry.getEnvironment(lexemeList, lexeme.getStartingOffset());
        if (lexeme == null) {
            return "";
        }
        String docs = "";
        String lowerName = lexeme.getText().toLowerCase();
        if (lexeme.typeIndex == 40) {
            ElementMetadata el = environment.getElement(lowerName = lowerName.replaceAll("<", ""));
            docs = el != null ? String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableHTML, (Object[])new String[]{el.getName(), el.getDescription()}) : String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_NoInformationAvailableHTML, (String)lexeme.getType());
        } else if (lexeme.typeIndex == 27) {
            ElementMetadata el = environment.getElement(lowerName = lowerName.replaceAll("</", ""));
            docs = el != null ? String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableEndTagHTML, (Object[])new String[]{el.getName(), el.getDescription()}) : String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_NoInformationAvailableHTML, (String)lexeme.getType());
        } else if (lexeme.typeIndex == 42) {
            FieldMetadata el;
            Lexeme tagOpenLexeme = XMLUtils.getTagOpenLexeme(lexeme, lexemeList);
            String stripTagEndings = XMLUtils.stripTagEndings(tagOpenLexeme.getText());
            ElementMetadata element = environment.getElement(stripTagEndings);
            if (element != null) {
                IMetadataItem metadataItem;
                Hashtable fields = element.getFields();
                if (fields != null && (metadataItem = (IMetadataItem)fields.get(lowerName)) != null) {
                    docs = String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableHTML, (Object[])new String[]{metadataItem.getName(), metadataItem.getDescription()});
                }
                if ((fields = element.getEvents()) != null && (metadataItem = (IMetadataItem)fields.get(lowerName)) != null) {
                    docs = String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableHTML, (Object[])new String[]{metadataItem.getName(), metadataItem.getDescription()});
                }
            }
            if ((el = (FieldMetadata)environment.getGlobalFields().get(lowerName)) != null) {
                docs = String.valueOf(docs) + StringUtils.format((String)Messages.HTMLFileLanguageService_InformationAvailableHTML, (Object[])new String[]{el.getName(), el.getDescription()});
            }
        } else if (lexeme.typeIndex == 43) {
            docs = String.valueOf(docs) + Messages.HTMLFileLanguageService_StringLiteralHTML;
            docs = String.valueOf(docs) + lexeme.getText();
        } else {
            docs = String.valueOf(docs);
        }
        return docs;
    }
}

