/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.formatting;

import com.aptana.ide.editor.xml.XMLFileLanguageService;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editor.xml.formatting.XMLUtils;
import com.aptana.ide.editor.xml.parsing.XMLParseState;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.UnifiedAutoIndentStrategy;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class XMLAutoIndentStrategy
extends UnifiedAutoIndentStrategy {
    public XMLAutoIndentStrategy(EditorFileContext context, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(context, configuration, sourceViewer);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        IPreferenceStore store = XMLPlugin.getDefault().getPreferenceStore();
        IParseState parseState = this.context.getParseState();
        XMLParseState xmlParseState = (XMLParseState)parseState.getParseState("text/xml");
        this.indentOnNewLine(document, command, store, xmlParseState);
        super.customizeDocumentCommand(document, command);
    }

    private void indentOnNewLine(IDocument document, DocumentCommand command, IPreferenceStore store, XMLParseState xmlParseState) {
        if (command.text == null || command.length > 0) {
            return;
        }
        if (store != null && store.getBoolean("com.aptana.ide.editor.html.AUTO_INDENT_ON_CARRIAGE_RETURN") && UnifiedConfiguration.isNewlineString((String)command.text) && this.indentNextTag(document, command, xmlParseState)) {
            return;
        }
    }

    protected IFileLanguageService getLanguageService() {
        XMLFileLanguageService ls = (XMLFileLanguageService)this.context.getLanguageService("text/xml");
        return ls;
    }

    protected LexemeList getLexemeList() {
        XMLFileLanguageService ls = (XMLFileLanguageService)this.context.getLanguageService("text/xml");
        return ls.getFileContext().getLexemeList();
    }

    public IPreferenceStore getPreferenceStore() {
        return XMLPlugin.getDefault().getPreferenceStore();
    }

    protected boolean isValidAutoInsertLocation(IDocument d, DocumentCommand c) {
        Lexeme l;
        boolean isString = false;
        LexemeList ll = this.getLexemeList();
        if (c.offset > 0 && ll != null && (l = ll.getLexemeFromOffset(c.offset)) != null && l.typeIndex == 43) {
            isString = true;
        }
        return XMLUtils.insideOpenTag(c.offset, ll) && !isString;
    }

    private boolean indentNextTag(IDocument d, DocumentCommand c, XMLParseState parseState) {
        IFileLanguageService ls = this.getLanguageService();
        LexemeList ll = ls.getFileContext().getLexemeList();
        if (ll == null) {
            return false;
        }
        int floorIndex = ll.getLexemeFloorIndex(c.offset - 1);
        if (floorIndex < 0) {
            return false;
        }
        Lexeme lexeme = ll.get(floorIndex);
        if (lexeme == null) {
            return false;
        }
        if (!lexeme.getText().equals(">")) {
            return false;
        }
        int position = floorIndex - 1;
        while (position >= 0) {
            lexeme = ll.get(position);
            if (lexeme == null) {
                return false;
            }
            if (lexeme.typeIndex == 30 || lexeme.typeIndex == 38 || lexeme.typeIndex == 27) {
                return false;
            }
            if (lexeme.typeIndex == 40) break;
            --position;
        }
        String returnVal = c.text;
        String spaces = this.getIndentForCurrentLine(d, c);
        String newIndent = "\t";
        if (this.configuration instanceof UnifiedConfiguration) {
            UnifiedConfiguration uc = (UnifiedConfiguration)this.configuration;
            newIndent = uc.getIndent();
        }
        String nextText = String.valueOf(returnVal) + spaces;
        int ceilingIndex = ll.getLexemeCeilingIndex(c.offset);
        if (ceilingIndex < 0) {
            nextText = "";
        } else {
            Lexeme nextLexeme = ll.get(ceilingIndex);
            if (nextLexeme.typeIndex != 27) {
                nextText = "";
            }
        }
        String beginText = String.valueOf(returnVal) + spaces + newIndent;
        c.text = String.valueOf(beginText) + nextText;
        c.shiftsCaret = false;
        c.caretOffset = c.offset + beginText.length();
        return true;
    }
}

