/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.validator;

import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.validator.ValidatorBase;
import com.aptana.ide.lexer.matcher.MatcherLexerBuilder;
import com.aptana.ide.lexer.matcher.model.LexerElement;
import com.aptana.xml.DocumentNode;
import com.aptana.xml.IErrorHandler;
import com.aptana.xml.INode;
import com.aptana.xml.Parser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class LexerValidator
extends ValidatorBase
implements IErrorHandler {
    private UnifiedErrorReporter _reporter;
    private String _path;
    private boolean _collectErrors;
    private boolean _collectWarnings;
    private boolean _collectInfos;

    public Parser getLexerParser() {
        Parser lexerParser = MatcherLexerBuilder.createLexerParser();
        lexerParser.setCacheClasses(false);
        return lexerParser;
    }

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider, boolean collectErrors, boolean collectWarnings, boolean collectInfos) {
        INode node;
        this._path = path;
        this._collectErrors = collectErrors;
        this._collectWarnings = collectWarnings;
        this._collectInfos = collectInfos;
        this._reporter = new UnifiedErrorReporter(sourceProvider);
        Parser lexerParser = this.getLexerParser();
        lexerParser.setErrorHandler((IErrorHandler)this);
        ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes());
        DocumentNode result = lexerParser.loadXML((InputStream)in);
        if (result != null && (node = result.getRootNode()) != null && node instanceof LexerElement) {
            LexerElement lexerElement = (LexerElement)node;
            lexerElement.validate();
        }
        return this._reporter.getErrors();
    }

    public void handleError(int line, int column, String message) {
        if (this._collectErrors) {
            this._reporter.error(message, this._path, line, "", column);
        }
    }

    public void handleInfo(int line, int column, String message) {
        if (this._collectInfos) {
            this._reporter.info(message, this._path, line, "", column);
        }
    }

    public void handleWarning(int line, int column, String message) {
        if (this._collectWarnings) {
            this._reporter.warning(message, this._path, line, "", column);
        }
    }
}

