/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.update;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.core.ui.update.SchedulerStartup;
import com.aptana.ide.update.Activator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.update.internal.core.UpdateCore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class UpdateUrlPatcher {
    private static final String DEFAULT_APTANA_URL = "http://update.aptana.com/install/studio/3.2/";
    private static String USER_URL_PREFIX = "";

    private UpdateUrlPatcher() {
    }

    public static File getPolicyFile() {
        File fl = new File(Activator.getDefault().getStateLocation().toFile(), "updatePolicy.xml");
        return fl;
    }

    static boolean createDefaultUpdatePolicyFile() {
        String userSpecificId;
        PrintStream ps;
        block3: {
            try {
                ps = new PrintStream(UpdateUrlPatcher.getPolicyFile());
                ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                ps.println("<update-policy>");
                ps.print("<url-map pattern=\"com.aptana\" url=\"");
                ps.print(DEFAULT_APTANA_URL);
                userSpecificId = UpdateUrlPatcher.getUserSpecificId();
                if (userSpecificId != null) break block3;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ps.print(userSpecificId);
        ps.print('/');
        ps.println("\"/>");
        ps.println("</update-policy>");
        ps.close();
        return true;
    }

    private static boolean storeDocument(Document document) {
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(UpdateUrlPatcher.getPolicyFile()));
            return true;
        }
        catch (TransformerConfigurationException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"error while storing Aptana policy file", (Throwable)e);
            return false;
        }
        catch (TransformerException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"error while storing Aptana policy file", (Throwable)e);
            return false;
        }
        catch (TransformerFactoryConfigurationError e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"error while storing Aptana policy file", (Throwable)e);
            return false;
        }
    }

    private static Document getDocument(URL url) {
        Document document;
        InputStream openStream = url.openStream();
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(openStream);
        }
        catch (Throwable throwable) {
            try {
                openStream.close();
                throw throwable;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"error while loading Aptana policy file", (Throwable)e);
                return null;
            }
        }
        openStream.close();
        return document;
    }

    private static String getUserSpecificId() {
        ApplicationPreferences preferences = ApplicationPreferences.getInstance();
        SchedulerStartup.updateAnonymousId();
        StringBuilder bld = new StringBuilder();
        String id = preferences.getString("ide-id");
        bld.append(USER_URL_PREFIX);
        bld.append(id);
        return bld.toString();
    }

    public static URL getNewPolicyURL(URL currentUrl) {
        boolean patch = UpdateCore.getPlugin().getPluginPreferences().getBoolean("path_url");
        if (patch) {
            if (currentUrl == null) {
                if (UpdateUrlPatcher.createDefaultUpdatePolicyFile()) {
                    try {
                        return UpdateUrlPatcher.getPolicyFile().toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (String)"incorrect url returned for policy file", (Throwable)e);
                        return currentUrl;
                    }
                }
            } else {
                String id = UpdateUrlPatcher.getUserSpecificId();
                if (id == null || id.length() == 0) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (String)"unable to obtain user specific id");
                    return currentUrl;
                }
                Document ds = UpdateUrlPatcher.getDocument(currentUrl);
                if (ds == null) {
                    return currentUrl;
                }
                UpdateUrlPatcher.patch(ds, id);
                if (!UpdateUrlPatcher.storeDocument(ds)) {
                    return currentUrl;
                }
                try {
                    return UpdateUrlPatcher.getPolicyFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (String)"incorrect url returned for policy file", (Throwable)e);
                    return currentUrl;
                }
            }
        }
        return currentUrl;
    }

    private static void patch(Document ds, String id) {
        Element ls = ds.getDocumentElement();
        UpdateUrlPatcher.patchHierarchically(ls, id);
    }

    private static void patchHierarchically(Element ls, String id) {
        int lastIndex;
        boolean patch;
        String atr = ls.getAttribute("url");
        if (atr.length() > 0 && (patch = atr.contains("aptana.com")) && (lastIndex = atr.lastIndexOf(47)) != -1) {
            String pref = atr.substring(0, lastIndex + 1);
            String suffix = atr.substring(lastIndex);
            StringBuilder newUrl = new StringBuilder();
            newUrl.append(pref);
            newUrl.append(id);
            newUrl.append(suffix);
            ls.setAttribute("url", newUrl.toString());
        }
        NodeList childs = ls.getChildNodes();
        int length = childs.getLength();
        int a = 0;
        while (a < length) {
            Node node = childs.item(a);
            if (node instanceof Element) {
                Element el = (Element)node;
                UpdateUrlPatcher.patchHierarchically(el, id);
            }
            ++a;
        }
    }
}

