/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.feature.update.uninstall;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.feature.update.uninstall.LogicalFeature;
import com.aptana.ide.update.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.core.ISiteFeatureReference;

public class UninstallLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    boolean useNameVersion;
    private Image featureImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)Activator.getDefault().getBundle().getSymbolicName(), (String)"/icons/feature_obj.gif").createImage();

    public Image getImage(Object element) {
        return this.featureImage;
    }

    public String getText(Object element) {
        if (element instanceof String) {
            String sm = (String)element;
            int pos = sm.indexOf(64);
            return sm.substring(pos + 1);
        }
        if (element instanceof LogicalFeature) {
            LogicalFeature ls = (LogicalFeature)element;
            return String.valueOf(ls.getName()) + "(" + ls.getId() + ")";
        }
        if (element instanceof ISiteFeatureReference) {
            ISiteFeatureReference sr = (ISiteFeatureReference)element;
            try {
                return String.valueOf(sr.getName()) + ' ' + sr.getVersionedIdentifier().getVersion().toString();
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"core exception during aquiring label for feature ", (Throwable)e);
            }
        }
        return super.getText(element);
    }

    public void dispose() {
        this.featureImage.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.useNameVersion) {
            return this.getText(element);
        }
        if (element instanceof String) {
            if (columnIndex == 1) {
                return "*";
            }
            return this.getText(element);
        }
        if (columnIndex == 0) {
            ISiteFeatureReference fr = (ISiteFeatureReference)element;
            return fr.getName();
        }
        if (columnIndex == 1) {
            ISiteFeatureReference fr = (ISiteFeatureReference)element;
            try {
                return fr.getVersionedIdentifier().getVersion().toString();
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"core exception during aquiring label for feature ", (Throwable)e);
            }
        }
        return null;
    }
}

