/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.profiles;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.Trace;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.profiles.IProfileAppliedListener;
import com.aptana.ide.editors.profiles.IProfileChangeListener;
import com.aptana.ide.editors.profiles.Messages;
import com.aptana.ide.editors.profiles.Profile;
import com.aptana.ide.editors.profiles.ProfileFileTypeInfo;
import com.aptana.ide.editors.profiles.ProfileFileTypeManager;
import com.aptana.ide.editors.profiles.ProfileURI;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.FileSourceProvider;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.ILanguageEnvironment;
import com.aptana.ide.editors.unified.utils.IUpdaterThreadUpdateable;
import com.aptana.ide.editors.unified.utils.UpdaterThread;
import com.aptana.ide.parsing.IParseState;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class ProfileManager
implements IUpdaterThreadUpdateable {
    public static int APPLY_PROFILE_DELAY = 1000;
    public static final String DEFAULT_PROFILE_NAME = "Default Profile";
    static final String staticProtocol = "static://";
    static final String titleLabel = " (Auto-created)";
    public static final String DEFAULT_PROFILE_PATH = "static://Default Profile";
    Profile currentProfile = null;
    ArrayList listeners = new ArrayList();
    ArrayList appliedListeners = new ArrayList();
    HashMap profiles = new HashMap();
    private HashMap languageEnvironments = new HashMap();
    private HashMap languageFactories = new HashMap();
    private UpdaterThread _applyProfilesThread = null;
    private HashMap changeListenerHash = new HashMap();

    public ProfileManager() {
        this(true);
    }

    public ProfileManager(boolean threaded) {
        if (threaded) {
            this.startProfileThread();
        }
        this.loadStaticProfiles();
    }

    private void startProfileThread() {
        this._applyProfilesThread = new UpdaterThread(this, APPLY_PROFILE_DELAY, Messages.ProfileManager_ApplyProfiles);
        this._applyProfilesThread.start();
    }

    private void loadStaticProfiles() {
        String profilesList;
        boolean defaultCreated;
        block10: {
            block11: {
                defaultCreated = false;
                Preferences prefs = UnifiedEditorsPlugin.getDefault().getPluginPreferences();
                profilesList = prefs.getString(Profile.getProfileListKey());
                if (profilesList.length() != 0) break block10;
                if (defaultCreated) break block11;
                this.createProfile(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_PATH);
            }
            this.setCurrentProfile(DEFAULT_PROFILE_PATH);
            return;
        }
        try {
            try {
                String[] list = profilesList.split(",");
                int i = 0;
                while (i < list.length) {
                    if (list[i].length() > 0) {
                        Trace.info((String)(String.valueOf(Messages.ProfileManager_LoadingProfile) + list[i]));
                        String[] parts = list[i].split("=");
                        String name = parts[0];
                        String path = parts[1];
                        this.createProfile(name, path);
                        if (list[i].equals(DEFAULT_PROFILE_NAME)) {
                            defaultCreated = true;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!defaultCreated) {
                this.createProfile(DEFAULT_PROFILE_NAME, DEFAULT_PROFILE_PATH);
            }
            this.setCurrentProfile(DEFAULT_PROFILE_PATH);
        }
    }

    public Profile createProfile(String name, String path) {
        return this.createProfile(name, path, false);
    }

    public Profile createProfile(String name, String path, boolean dynamic) {
        Profile profile = new Profile(name, path, dynamic);
        this.addProfile(profile);
        return profile;
    }

    public void addProfile(Profile profile) {
        IProfileChangeListener pcl = new IProfileChangeListener(){

            public void onProfileChanged(Profile p) {
                ProfileManager.this.fireProfileChangeEvent(p);
                ProfileManager.this.applyProfiles();
            }
        };
        this.changeListenerHash.put(profile.getURI(), pcl);
        profile.addProfileChangeListener(pcl);
        this.profiles.put(profile.getURI(), profile);
        this.fireProfileChangeEvent(profile);
    }

    public void removeProfile(String path) {
        IProfileChangeListener pcl = null;
        if (this.changeListenerHash.containsKey(path)) {
            pcl = (IProfileChangeListener)this.changeListenerHash.get(path);
            this.changeListenerHash.remove(path);
        }
        if (this.profiles.containsKey(path)) {
            Profile p = this.getProfile(path);
            p.clear();
            if (pcl != null) {
                p.removeProfileChangeListener(pcl);
            }
            this.profiles.remove(path);
            this.fireProfileChangeEvent(p);
            this.applyProfiles();
        }
    }

    public void setCurrentProfile(String path) {
        Profile p = this.getProfile(path);
        if (p == null) {
            p = this.getDefaultProfile();
        }
        this.setCurrentProfile(p);
    }

    public Profile getDefaultProfile() {
        return (Profile)this.profiles.get(DEFAULT_PROFILE_PATH);
    }

    public void setCurrentProfile(Profile profile) {
        this.currentProfile = profile;
        this.fireProfileChangeEvent(this.currentProfile);
        this.applyProfiles();
    }

    public Profile getCurrentProfile() {
        return this.currentProfile;
    }

    public boolean isCurrentProfile(Profile profile) {
        return this.currentProfile == profile;
    }

    public void addLanguageSupport(String mimeType, ILanguageEnvironment lang, IFileServiceFactory factory) {
        this.languageEnvironments.put(mimeType, lang);
        if (!this.languageFactories.containsKey(mimeType)) {
            this.languageFactories.put(mimeType, factory);
        }
    }

    public Profile[] getProfiles() {
        Profile[] array = this.profiles.values().toArray(new Profile[0]);
        return array;
    }

    public String[] getProfilePaths() {
        return this.profiles.keySet().toArray(new String[0]);
    }

    public Profile getProfile(String path) {
        return (Profile)this.profiles.get(path);
    }

    public int getTotalFileCount() {
        Profile[] profiles = this.getProfiles();
        int count = 0;
        int i = 0;
        while (i < profiles.length) {
            count += profiles[i].getURIs().length;
            ++i;
        }
        return count;
    }

    public void fireProfileChangeEvent(Profile p) {
        int i = 0;
        while (i < this.listeners.size()) {
            IProfileChangeListener listener = (IProfileChangeListener)this.listeners.get(i);
            listener.onProfileChanged(p);
            ++i;
        }
    }

    public void addProfileChangeListener(IProfileChangeListener l) {
        this.listeners.add(l);
    }

    public void removeProfileChangeListener(IProfileChangeListener l) {
        this.listeners.remove(l);
    }

    public void fireProfileAppliedEvent(ProfileURI p, boolean state) {
        int i = 0;
        while (i < this.listeners.size()) {
            IProfileAppliedListener listener = (IProfileAppliedListener)this.appliedListeners.get(i);
            listener.onProfileApplied(p, state);
            ++i;
        }
    }

    public void addProfileAppliedListener(IProfileAppliedListener l) {
        this.appliedListeners.add(l);
    }

    public void removeProfileChangeListener(IProfileAppliedListener l) {
        this.appliedListeners.remove(l);
    }

    public void onUpdaterThreadUpdate() {
        this.resetIconStatus();
        this.resetEnvironment();
        this.resetAndApply();
    }

    private void resetIconStatus() {
        if (this.currentProfile != null) {
            ProfileURI[] paths = this.currentProfile.getURIsIncludingChildren();
            int i = 0;
            while (i < paths.length) {
                this.fireProfileAppliedEvent(paths[i], false);
                ++i;
            }
        }
    }

    public void resetEnvironment() {
        Collection langs = this.languageEnvironments.values();
        for (ILanguageEnvironment lang : langs) {
            lang.cleanEnvironment();
        }
        ProfileFileTypeInfo[] profileFileTypeInfoArray = ProfileFileTypeManager.getInstance().getAllInfos();
        int n = 0;
        int n2 = profileFileTypeInfoArray.length;
        while (n < n2) {
            ProfileFileTypeInfo info = profileFileTypeInfoArray[n];
            if (info.processor != null) {
                info.processor.cleanEnvironment();
            }
            ++n;
        }
    }

    private void resetAndApply() {
        if (this.currentProfile == null) {
            return;
        }
        HashSet allURIs = new HashSet(Arrays.asList(FileContextManager.getKeySet()));
        String activeEditorURI = CoreUIUtils.getActiveEditorURI();
        HashSet currentProfileURIs = new HashSet(Arrays.asList(this.currentProfile.getURIsIncludingChildrenAsStrings()));
        allURIs.remove(activeEditorURI);
        allURIs.remove(currentProfileURIs);
        this.deactivateFileContexts(allURIs);
        this.reindexCurrentProfile();
        this.reindexActiveEditor(activeEditorURI, currentProfileURIs);
    }

    private void deactivateFileContexts(HashSet allURIs) {
        for (String uri : allURIs) {
            IParseState parseState;
            FileService fileContext = FileContextManager.get(uri);
            if (fileContext == null || (parseState = fileContext.getParseState()) == null) continue;
            parseState.setFileIndex(-1);
        }
    }

    private void reindexActiveEditor(String activeEditorURI, HashSet currentProfileURIs) {
        FileService activeFileContext = FileContextManager.get(activeEditorURI);
        if (activeFileContext != null && !currentProfileURIs.contains(activeEditorURI)) {
            IParseState parseState = activeFileContext.getParseState();
            if (parseState != null) {
                parseState.setFileIndex(Integer.MAX_VALUE);
            }
            activeFileContext.forceContentChangedEvent();
        }
    }

    private void reindexCurrentProfile() {
        int fileIndex = 0;
        String[] currentProfileURIs = this.currentProfile.getURIsIncludingChildrenAsStrings();
        String[] openEditorsArray = CoreUIUtils.getOpenEditorPaths();
        HashSet openEditors = new HashSet(Arrays.asList(openEditorsArray));
        String[] stringArray = currentProfileURIs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            block5: {
                String uri;
                block3: {
                    FileService fileContext;
                    block7: {
                        IFileServiceFactory factory;
                        block8: {
                            String mimeType;
                            block6: {
                                block4: {
                                    uri = stringArray[n];
                                    if (openEditorsArray.length <= 0) break block3;
                                    String extension = FileUtils.getExtension((String)uri);
                                    ProfileFileTypeInfo info = ProfileFileTypeManager.getInstance().getInfo(extension);
                                    if (info == null || info.processor == null || !info.processor.processFile(uri, fileIndex++)) break block4;
                                    this.fireProfileAppliedEvent(new ProfileURI(uri, this.currentProfile), true);
                                    break block5;
                                }
                                mimeType = this.computeMIMEType(uri);
                                if (mimeType != null) break block6;
                                IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.ProfileManager_MimeTypeError, (String)uri));
                                break block3;
                            }
                            fileContext = FileContextManager.get(uri);
                            if (fileContext != null && (!(fileContext.getSourceProvider() instanceof DocumentSourceProvider) || openEditors.contains(uri))) break block7;
                            factory = (IFileServiceFactory)this.languageFactories.get(mimeType);
                            if (factory != null) break block8;
                            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.ProfileManager_ServiceFactoryError, (String)mimeType));
                            break block5;
                        }
                        String path = CoreUIUtils.getPathFromURI((String)uri);
                        File file = new File(path);
                        if (!file.exists()) break block5;
                        FileSourceProvider fsp = new FileSourceProvider(file);
                        fileContext = factory.createFileService(fsp);
                        FileContextManager.add(uri, fileContext);
                    }
                    fileContext.getParseState().setFileIndex(fileIndex++);
                    fileContext.doFullParse();
                    fileContext.forceContentChangedEvent();
                }
                this.fireProfileAppliedEvent(new ProfileURI(uri, this.currentProfile), true);
            }
            ++n;
        }
    }

    private String computeMIMEType(String uri) {
        String mimeType = null;
        if (uri.toLowerCase().endsWith(".js") || uri.toLowerCase().endsWith(".sdoc")) {
            mimeType = "text/javascript";
        }
        return mimeType;
    }

    public void applyProfiles() {
        if (this._applyProfilesThread != null) {
            this._applyProfilesThread.setDirty();
        } else {
            this.onUpdaterThreadUpdate();
        }
    }

    public void refreshEnvironment() {
        Profile[] profiles = this.getProfiles();
        int i = 0;
        while (i < profiles.length) {
            this.fireProfileChangeEvent(profiles[i]);
            ++i;
        }
        this.applyProfiles();
    }

    public Profile makeProfileStatic(Profile profile) {
        String profileName = profile.getName();
        String[] fileListArray = profile.getURIsAsStrings();
        String path = profile.getURI();
        boolean wasSelected = false;
        if (path == this.getCurrentProfile().getURI()) {
            wasSelected = true;
        }
        String newPath = staticProtocol + path;
        this.removeProfile(path);
        if (profileName.indexOf(titleLabel) != -1) {
            profileName = profileName.substring(0, profileName.length() - titleLabel.length());
        }
        Profile newProfile = this.createProfile(profileName, newPath);
        newProfile.addURIs(fileListArray);
        if (wasSelected) {
            this.setCurrentProfile(newProfile.getURI());
        }
        return newProfile;
    }
}

