/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.formatting.IUnifiedBracketInserter;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.ITextTripleClickStrategy;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedTripleClickStrategy;
import com.aptana.ide.editors.unified.hover.LexemeTextHover;
import java.util.ArrayList;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public abstract class BaseContributor
implements IUnifiedEditorContributor {
    private String language;
    protected IUnifiedEditorContributor parent;
    private String[] contentTypes;
    private EditorFileContext fileService;
    private String[] indentPrefixes = new String[]{"\t", "    "};
    private SourceViewerConfiguration parentConfiguration;
    private ITextDoubleClickStrategy doubleClickStrategy;
    private ITextTripleClickStrategy tripleClickStrategy;

    protected BaseContributor(String language) {
        this.language = language;
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.dispose();
            this.parent = null;
        }
        this.fileService = null;
        this.parentConfiguration = null;
        this.doubleClickStrategy = null;
    }

    public boolean isAutoActivateContentAssist() {
        return false;
    }

    public String getLocalContentType() {
        return this.language;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (contentType == null || contentType.equals("") || contentType.equals(this.getLocalContentType())) {
            return this.getLocalIndentPrefixes();
        }
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null) {
            int i = 0;
            while (i < ccs.length) {
                if (ccs[i].getLocalContentType().equals(contentType) && ccs[i] instanceof BaseContributor) {
                    ((BaseContributor)ccs[i]).getLocalIndentPrefixes();
                    break;
                }
                ++i;
            }
        }
        return this.indentPrefixes;
    }

    public String getIndentString(ISourceViewer sourceViewer, String contentType) {
        String[] indents = this.getIndentPrefixes(sourceViewer, contentType);
        boolean hasIndents = indents == null || indents.length == 0;
        String indentString = hasIndents ? "\t" : indents[0];
        return indentString;
    }

    protected String[] getLocalIndentPrefixes() {
        return this.indentPrefixes;
    }

    protected void setLocalIndentPrefixes(String[] prefixes) {
        this.indentPrefixes = prefixes;
    }

    public void setIndentPrefixes(String[] prefixes, ISourceViewer sourceViewer, String contentType) {
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null) {
            int i = 0;
            while (i < ccs.length) {
                if (ccs[i].getLocalContentType().equals(contentType) && ccs[i] instanceof BaseContributor) {
                    ((BaseContributor)ccs[i]).setLocalIndentPrefixes(prefixes);
                    sourceViewer.setIndentPrefixes(prefixes, contentType);
                    break;
                }
                ++i;
            }
        }
    }

    public void setAllIndentPrefixes(String[] prefixes, ISourceViewer sourceViewer) {
        this.indentPrefixes = prefixes;
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null) {
            int i = 0;
            while (i < ccs.length) {
                if (ccs[i] instanceof BaseContributor) {
                    ((BaseContributor)ccs[i]).setLocalIndentPrefixes(prefixes);
                    sourceViewer.setIndentPrefixes(prefixes, ccs[i].getLocalContentType());
                }
                ++i;
            }
        }
        sourceViewer.setIndentPrefixes(prefixes, this.getLocalContentType());
    }

    public IUnifiedEditorContributor[] getChildContributors() {
        return null;
    }

    public IUnifiedEditorContributor findChildContributor(String contentType) {
        if (contentType.equals(this.getLocalContentType())) {
            return this;
        }
        IUnifiedEditorContributor[] contributors = this.getChildContributors();
        if (contributors != null) {
            int i = 0;
            while (i < contributors.length) {
                IUnifiedEditorContributor child = contributors[i].findChildContributor(contentType);
                if (child != null) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    public void configLocalPresentationReconciler(PresentationReconciler reconciler) {
    }

    public IAutoEditStrategy[] getLocalAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return null;
    }

    public IContentAssistProcessor getLocalContentAssistProcessor(ISourceViewer sourceViewer, String contentType) {
        return null;
    }

    public final void configPresentationReconciler(PresentationReconciler reconciler) {
    }

    public final String[] getContentTypes() {
        if (this.contentTypes == null) {
            IUnifiedEditorContributor[] ccs;
            ArrayList<String[]> al = new ArrayList<String[]>();
            String localCTS = this.getLocalContentType();
            int len = 0;
            if (localCTS != null) {
                al.add(new String[]{localCTS});
                len = 1;
            }
            if ((ccs = this.getChildContributors()) != null) {
                int i = 0;
                while (i < ccs.length) {
                    String[] ct = ccs[i].getContentTypes();
                    if (ct != null) {
                        al.add(ct);
                        len += ct.length;
                    }
                    ++i;
                }
            }
            this.contentTypes = new String[len];
            int index = 0;
            int i = 0;
            while (i < al.size()) {
                String[] types = (String[])al.get(i);
                int j = 0;
                while (j < types.length) {
                    this.contentTypes[index] = types[j];
                    ++index;
                    ++j;
                }
                ++i;
            }
        }
        return this.contentTypes;
    }

    public final IContentAssistProcessor getContentAssistProcessor(ISourceViewer sourceViewer, String contentType) {
        IContentAssistProcessor localCA = this.getLocalContentAssistProcessor(sourceViewer, contentType);
        if (localCA != null) {
            return localCA;
        }
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null) {
            int i = 0;
            while (i < ccs.length) {
                IContentAssistProcessor ca = ccs[i].getContentAssistProcessor(sourceViewer, contentType);
                if (ca != null) {
                    return ca;
                }
                ++i;
            }
        }
        return null;
    }

    public final IUnifiedBracketInserter getBracketInserter(ISourceViewer sourceViewer, String contentType) {
        IUnifiedBracketInserter localCA = this.getLocalBracketInserter(sourceViewer, contentType);
        if (localCA != null) {
            return localCA;
        }
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null) {
            int i = 0;
            while (i < ccs.length) {
                IUnifiedBracketInserter ca = ccs[i].getBracketInserter(sourceViewer, contentType);
                if (ca != null) {
                    return ca;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return false;
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return false;
    }

    public final ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        ITextHover localHover = this.getLocalTextHover(sourceViewer, contentType);
        if (localHover != null) {
            return localHover;
        }
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null) {
            int i = 0;
            while (i < ccs.length) {
                ITextHover hover = ccs[i].getTextHover(sourceViewer, contentType);
                if (hover != null) {
                    return hover;
                }
                ++i;
            }
        }
        return null;
    }

    public final IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IUnifiedEditorContributor[] ccs;
        ArrayList<IAutoEditStrategy[]> al = new ArrayList<IAutoEditStrategy[]>();
        IAutoEditStrategy[] localAES = this.getLocalAutoEditStrategies(sourceViewer, contentType);
        int len = 0;
        if (localAES != null) {
            al.add(localAES);
            len = localAES.length;
        }
        if ((ccs = this.getChildContributors()) != null && ccs.length > 0) {
            int i = 0;
            while (i < ccs.length) {
                IAutoEditStrategy[] ct = ccs[i].getAutoEditStrategies(sourceViewer, contentType);
                if (ct != null && ct.length > 0) {
                    al.add(ct);
                    len += ct.length;
                }
                ++i;
            }
        }
        IAutoEditStrategy[] autoEditStrategies = new IAutoEditStrategy[len];
        int index = 0;
        int i = 0;
        while (i < al.size()) {
            IAutoEditStrategy[] aes = (IAutoEditStrategy[])al.get(i);
            int j = 0;
            while (j < aes.length) {
                autoEditStrategies[index] = aes[j];
                ++index;
                ++j;
            }
            ++i;
        }
        return autoEditStrategies;
    }

    public final EditorFileContext getFileContext() {
        if (this.fileService == null && this.parent != null) {
            return this.parent.getFileContext();
        }
        return this.fileService;
    }

    public void setFileContext(EditorFileContext fileContext) {
        this.fileService = fileContext;
    }

    public final void setParent(IUnifiedEditorContributor parent) {
        this.parent = parent;
    }

    public ITextHover getLocalTextHover(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals(this.getLocalContentType())) {
            return new LexemeTextHover(this.getFileContext());
        }
        return null;
    }

    public SourceViewerConfiguration getParentConfiguration() {
        if (this.parentConfiguration != null) {
            return this.parentConfiguration;
        }
        if (this.parent != null) {
            return this.parent.getParentConfiguration();
        }
        return null;
    }

    public void setParentConfiguration(SourceViewerConfiguration parentConfiguration) {
        this.parentConfiguration = parentConfiguration;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null && ccs.length > 0) {
            int i = 0;
            while (i < ccs.length) {
                ITextDoubleClickStrategy dcs = ccs[i].getDoubleClickStrategy(sourceViewer, contentType);
                if (dcs != null) {
                    return dcs;
                }
                ++i;
            }
        }
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DefaultTextDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public ITextTripleClickStrategy getTripleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        IUnifiedEditorContributor[] ccs = this.getChildContributors();
        if (ccs != null && ccs.length > 0) {
            int i = 0;
            while (i < ccs.length) {
                ITextTripleClickStrategy dcs = ccs[i].getTripleClickStrategy(sourceViewer, contentType);
                if (dcs != null) {
                    return dcs;
                }
                ++i;
            }
        }
        if (this.tripleClickStrategy == null) {
            this.tripleClickStrategy = new UnifiedTripleClickStrategy();
        }
        return this.tripleClickStrategy;
    }

    public IUnifiedBracketInserter getLocalBracketInserter(ISourceViewer sourceViewer, String contentType) {
        return null;
    }
}

