/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IChildOffsetMapper;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.ICodeLocation;

public class ChildOffsetMapper
implements IChildOffsetMapper {
    private IParentOffsetMapper parent;
    private boolean isDisposing = false;

    public ChildOffsetMapper(IParentOffsetMapper parent) {
        if (parent == null) {
            throw new IllegalStateException(Messages.ChildOffsetMapper_NonNullParent);
        }
        this.parent = parent;
    }

    public IParentOffsetMapper getParent() {
        return this.parent;
    }

    public void calculateCurrentLexeme(int offset) {
        this.parent.calculateCurrentLexeme(offset);
    }

    public FileService getFileService() {
        return this.parent.getFileService();
    }

    public Lexeme getCurrentLexeme() {
        return this.parent.getCurrentLexeme();
    }

    public int getCurrentLexemeIndex() {
        return this.parent.getCurrentLexemeIndex();
    }

    public Lexeme getLexemeAtIndex(int index) {
        return this.parent.getLexemeAtIndex(index);
    }

    public int getLexemeIndexFromDocumentOffset(int offset) {
        return this.parent.getLexemeIndexFromDocumentOffset(offset);
    }

    public LexemeList getLexemeList() {
        return this.parent.getLexemeList();
    }

    public Lexeme getNextLexeme() {
        LexemeList lexemeList = this.getFileService().getLexemeList();
        if (lexemeList != null && lexemeList.size() > this.getCurrentLexemeIndex() + 1) {
            return lexemeList.get(this.getCurrentLexemeIndex() + 1);
        }
        return null;
    }

    public Lexeme getPreviousLexeme() {
        LexemeList lexemeList = this.getFileService().getLexemeList();
        if (lexemeList != null && lexemeList.size() > 1 && this.getCurrentLexemeIndex() > 1) {
            return lexemeList.get(this.getCurrentLexemeIndex() - 1);
        }
        return null;
    }

    public ICodeLocation findTarget(Lexeme lexeme) {
        return null;
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        this.parent.dispose();
    }
}

