/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ICodeFormatter;
import com.aptana.ide.editors.unified.IPairFinder;
import com.aptana.ide.editors.unified.InstanceCreator;
import com.aptana.ide.editors.unified.colorizer.ColorizerReader;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.Messages;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.LexerPlugin;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.lexer.matcher.MatcherLexerBuilder;
import com.aptana.ide.parsing.IParser;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguageRegistry {
    private static final String TOKEN_LIST_ID = "com.aptana.ide.editors.tokenList";
    private static final String PARSER_ID = "com.aptana.ide.editors.parser";
    private static final String SCANNER_ID = "com.aptana.ide.editors.scanner";
    private static final String PAIRFINDER_ID = "com.aptana.ide.editors.pairfinder";
    private static final String FORMATTER_ID = "com.aptana.ide.editors.formatter";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_RESOURCE = "resource";
    private static final String ATTR_EXTENSION = "extension";
    private static final String TAG_PARSER = "parser";
    private static final String TAG_SCANNER = "scanner";
    private static final String TAG_PAIR_FINDER = "pairFinder";
    private static final String TAG_FORMATTER = "formatter";
    private static final String TAG_TOKEN_LIST = "tokenList";
    private static final String TAG_TEXT_MATCHER = "textMatcher";
    private static Map<String, LanguageColorizer> languageColorizers = new HashMap<String, LanguageColorizer>();
    private static Map<String, InstanceCreator> languageTokenLists = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> extensionTokenLists = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> languageParsers = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> languageScanners = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> pairFinders = new HashMap<String, InstanceCreator>();
    private static Map<String, InstanceCreator> formatters = new HashMap<String, InstanceCreator>();
    private static ColorizerReader colorizerReader;

    static {
        LanguageRegistry.loadTokenLists();
        LanguageRegistry.loadColorizations();
        LanguageRegistry.loadParsers();
        LanguageRegistry.loadScanners();
        LanguageRegistry.loadPairFinders();
        LanguageRegistry.loadCodeFormatters();
    }

    private LanguageRegistry() {
    }

    public static LanguageColorizer getLanguageColorizer(String language) {
        LanguageColorizer original = null;
        if (languageColorizers.containsKey(language)) {
            original = languageColorizers.get(language);
        } else if (colorizerReader.getInstanceCreator(language) != null) {
            InstanceCreator creator = colorizerReader.getInstanceCreator(language);
            original = (LanguageColorizer)creator.getCachedInstance();
        } else {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.LanguageRegistry_NO_COLORIZER, (String)language));
        }
        return original;
    }

    public static LanguageColorizer getLanguageColorizer(String language, ColorizerReader reader) {
        LanguageColorizer original = null;
        if (languageColorizers.containsKey(language)) {
            original = languageColorizers.get(language);
        } else if (reader.getInstanceCreator(language) != null) {
            InstanceCreator creator = reader.getInstanceCreator(language);
            original = (LanguageColorizer)creator.getCachedInstance();
        } else {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.LanguageRegistry_NO_COLORIZER, (String)language));
        }
        return original;
    }

    public static List<LanguageColorizer> getLanguageColorizers() {
        return new ArrayList<LanguageColorizer>(languageColorizers.values());
    }

    public static String getPreferenceId(String language) {
        return colorizerReader.getPreferenceId(language);
    }

    public static IParser getParser(String language) {
        IParser result = null;
        if (languageParsers.containsKey(language)) {
            InstanceCreator creator = languageParsers.get(language);
            result = (IParser)creator.getCachedInstance();
        } else {
            String message = MessageFormat.format(Messages.LanguageRegistry_No_Associated_Parser, language);
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
        }
        return result;
    }

    public static IParser getScanner(String language) {
        IParser result = null;
        if (languageScanners.containsKey(language)) {
            InstanceCreator creator = languageScanners.get(language);
            result = (IParser)creator.getCachedInstance();
        } else {
            String message = MessageFormat.format(Messages.LanguageRegistry_No_Associated_Parser, language);
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
        }
        return result;
    }

    public static IPairFinder getPairFinder(String language) {
        IPairFinder result = null;
        if (pairFinders.containsKey(language)) {
            InstanceCreator creator = pairFinders.get(language);
            result = (IPairFinder)creator.getCachedInstance();
        } else {
            String message = MessageFormat.format(Messages.LanguageRegistry_No_Associated_Finder, language);
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
        }
        return result;
    }

    public static ICodeFormatter getCodeFormatter(String language) {
        ICodeFormatter result = null;
        if (formatters.containsKey(language)) {
            InstanceCreator creator = formatters.get(language);
            result = (ICodeFormatter)creator.getCachedInstance();
        } else {
            String message = MessageFormat.format(Messages.LanguageRegistry_No_Associated_Finder, language);
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
        }
        return result;
    }

    public static TokenList getTokenList(String language) {
        TokenList result = null;
        if (languageTokenLists.containsKey(language)) {
            InstanceCreator creator = languageTokenLists.get(language);
            result = (TokenList)creator.getCachedInstance();
        } else {
            String message = MessageFormat.format(Messages.LanguageRegistry_No_Associate_Token_List, language);
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
        }
        return result;
    }

    public static TokenList getTokenListByExtension(String extension) {
        TokenList result = null;
        if (extension != null && extension.length() > 0) {
            if (extension.startsWith(".")) {
                extension = extension.substring(1);
            }
            if (extensionTokenLists.containsKey(extension)) {
                InstanceCreator creator = extensionTokenLists.get(extension);
                result = (TokenList)creator.getCachedInstance();
            } else {
                String message = MessageFormat.format(Messages.LanguageRegistry_No_Associate_Token_List, extension);
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)message);
            }
        }
        return result;
    }

    public static IParser createParser(String language) {
        IParser result = null;
        if (languageParsers.containsKey(language)) {
            InstanceCreator creator = languageParsers.get(language);
            result = (IParser)creator.createInstance();
        }
        return result;
    }

    public static IParser createScanner(String language) {
        IParser result = null;
        if (languageScanners.containsKey(language)) {
            InstanceCreator creator = languageScanners.get(language);
            result = (IParser)creator.createInstance();
        }
        return result;
    }

    public static TokenList createTokenList(InputStream input) {
        TokenList result = null;
        if (input != null) {
            try {
                MatcherLexerBuilder builder = new MatcherLexerBuilder();
                builder.loadXML(input);
                ILexer lexer = builder.buildLexer();
                String[] languages = lexer.getLanguages();
                if (languages != null && languages.length > 0) {
                    result = (TokenList)lexer.getTokenList(languages[0]);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.LanguageRegistry_Cannot_Create_Token_List, (Throwable)e);
            }
        }
        return result;
    }

    public static TokenList createTokenList(String language) {
        TokenList result = null;
        if (languageTokenLists.containsKey(language)) {
            InstanceCreator creator = languageTokenLists.get(language);
            result = (TokenList)creator.createInstance();
        }
        return result;
    }

    public static boolean hasLanguageColorizer(String language) {
        return languageColorizers.containsKey(language);
    }

    public static boolean hasParser(String language) {
        return languageParsers.containsKey(language);
    }

    public static boolean hasScanner(String language) {
        return languageScanners.containsKey(language);
    }

    public static boolean hasTokenList(String language) {
        return languageTokenLists.containsKey(language);
    }

    public static void importColorization(File file, String language) {
        colorizerReader.importColorization(file, language);
    }

    private static void loadColorizations() {
        colorizerReader = new ColorizerReader();
        colorizerReader.loadExtensionPointColorizers();
    }

    private static void loadTokenLists() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(TOKEN_LIST_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    InstanceCreator instance = null;
                    String language = null;
                    String fileExtension = null;
                    if (elementName.equals(TAG_TOKEN_LIST) && LexerPlugin.useCodeBasedLexer()) {
                        String tokenListClass = element.getAttribute(ATTR_CLASS);
                        language = element.getAttribute(ATTR_LANGUAGE);
                        fileExtension = element.getAttribute(ATTR_EXTENSION);
                        if (fileExtension != null && fileExtension.startsWith(".")) {
                            fileExtension = fileExtension.substring(1);
                        }
                        if (tokenListClass != null && language != null && language.length() > 0) {
                            instance = new InstanceCreator(element, ATTR_CLASS);
                        }
                    } else if (elementName.equals(TAG_TEXT_MATCHER) && LexerPlugin.useMatcherLexer()) {
                        String resourceName = element.getAttribute(ATTR_RESOURCE);
                        language = element.getAttribute(ATTR_LANGUAGE);
                        fileExtension = element.getAttribute(ATTR_EXTENSION);
                        if (fileExtension != null && fileExtension.startsWith(".")) {
                            fileExtension = fileExtension.substring(1);
                        }
                        if (resourceName != null && language != null && language.length() > 0) {
                            instance = new InstanceCreator(element, resourceName){

                                public Object createInstance() {
                                    TokenList result = null;
                                    IExtension ext = this.element.getDeclaringExtension();
                                    String pluginId = ext.getNamespaceIdentifier();
                                    Bundle bundle = Platform.getBundle((String)pluginId);
                                    URL resource = bundle.getResource(this.attributeName);
                                    if (resource == null) {
                                        resource = bundle.getEntry(this.attributeName);
                                    }
                                    try {
                                        InputStream input = resource.openStream();
                                        result = LanguageRegistry.createTokenList(input);
                                    }
                                    catch (Exception e) {
                                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.LanguageRegistry_Cannot_Load_Token_List, (Throwable)e);
                                    }
                                    return result;
                                }
                            };
                        }
                    }
                    if (instance != null) {
                        languageTokenLists.put(language, instance);
                        if (fileExtension != null) {
                            extensionTokenLists.put(fileExtension, instance);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void loadPairFinders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(PAIRFINDER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(TAG_PAIR_FINDER)) {
                        String finderClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (finderClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            pairFinders.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void loadCodeFormatters() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(FORMATTER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(TAG_FORMATTER)) {
                        String finderClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (finderClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            formatters.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void loadParsers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(PARSER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(TAG_PARSER)) {
                        String parserClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (parserClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            languageParsers.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void loadScanners() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(SCANNER_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(TAG_SCANNER)) {
                        String parserClass = element.getAttribute(ATTR_CLASS);
                        String language = element.getAttribute(ATTR_LANGUAGE);
                        if (parserClass != null && language != null && language.length() > 0) {
                            InstanceCreator creator = new InstanceCreator(element, ATTR_CLASS);
                            languageScanners.put(language, creator);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void registerLanguageColorizer(String language, LanguageColorizer colorizer) {
        if (!languageColorizers.containsKey(language)) {
            languageColorizers.put(language, colorizer);
        } else {
            LanguageColorizer curr = languageColorizers.get(language);
            curr.setCategoryColorizers(colorizer);
            curr.setTokenColorizers(colorizer);
            curr.setBackground(colorizer.getBackground());
            curr.setCaretColor(colorizer.getCaretColor());
            curr.setLineHighlightColor(colorizer.getLineHighlightColor());
            curr.setSelectionBackground(colorizer.getSelectionBackground());
            curr.setSelectionForeground(colorizer.getSelectionForeground());
            curr.setFoldingBg(colorizer.getFoldingBg());
            curr.setFoldingFg(colorizer.getFoldingFg());
        }
    }

    public static void registerParser(String language, IParser parser) {
        if (!languageParsers.containsKey(language)) {
            InstanceCreator creator = new InstanceCreator(null, null);
            creator.setCache(parser);
            languageParsers.put(language, creator);
        } else {
            InstanceCreator creator = languageParsers.get(language);
            creator.setCache(parser);
        }
    }

    public static void registerScanner(String language, IParser parser) {
        if (!languageScanners.containsKey(language)) {
            InstanceCreator creator = new InstanceCreator(null, null);
            creator.setCache(parser);
            languageScanners.put(language, creator);
        } else {
            InstanceCreator creator = languageScanners.get(language);
            creator.setCache(parser);
        }
    }

    public static void registerTokenList(TokenList tokenList) {
        LanguageRegistry.registerTokenList(tokenList, null);
    }

    public static void registerTokenList(TokenList tokenList, String fileExtension) {
        InstanceCreator creator;
        String language = tokenList.getLanguage();
        if (!languageTokenLists.containsKey(language)) {
            creator = new InstanceCreator(null, null);
            creator.setCache(tokenList);
            languageTokenLists.put(language, creator);
        } else {
            creator = languageTokenLists.get(language);
            creator.setCache(tokenList);
        }
        if (fileExtension != null && fileExtension.length() > 0) {
            if (fileExtension.startsWith(".")) {
                fileExtension = fileExtension.substring(1);
            }
            if (!extensionTokenLists.containsKey(fileExtension)) {
                creator = new InstanceCreator(null, null);
                creator.setCache(tokenList);
                extensionTokenLists.put(fileExtension, creator);
            } else {
                creator = extensionTokenLists.get(fileExtension);
                creator.setCache(tokenList);
            }
        }
    }

    public static void restoreDefaultColorization(String language) {
        colorizerReader.restoreDefault(language);
    }

    public static void setPreferenceId(String language, String preferenceId) {
        colorizerReader.setPreferenceId(language, preferenceId);
    }

    public static void unregisterLanguageColorizer(String language) {
        LanguageColorizer curr = languageColorizers.remove(language);
        if (curr != null) {
            LanguageColorizer colorizer = new LanguageColorizer(curr.getLanguage());
            curr.setCategoryColorizers(colorizer);
            curr.setTokenColorizers(colorizer);
            curr.setBackground(colorizer.getBackground());
            curr.setCaretColor(colorizer.getCaretColor());
            curr.setLineHighlightColor(colorizer.getLineHighlightColor());
            curr.setSelectionBackground(colorizer.getSelectionBackground());
            curr.setSelectionForeground(colorizer.getSelectionForeground());
        }
    }

    public static void unregisterParser(String language) {
        languageParsers.remove(language);
    }

    public static void unregisterScanner(String language) {
        languageScanners.remove(language);
    }

    public static void clearTokenList(String language) {
        if (languageTokenLists.containsKey(language)) {
            InstanceCreator creator = languageTokenLists.get(language);
            creator.setCache(null);
        }
    }

    public static void unregisterTokenList(TokenList tokenList) {
        languageTokenLists.remove(tokenList.getLanguage());
    }
}

