/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ILexemeColorMapper;
import com.aptana.ide.editors.unified.ILexemeColorMapperEx;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.lexer.Lexeme;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnifiedColorizerBase
implements ILexemeColorMapper,
ILexemeColorMapperEx {
    private IPropertyChangeListener _propertyChangeListener = new PropertyChangeListener();
    private boolean isDisposing = false;
    protected TextAttribute _occurrenceHighlight;

    public UnifiedColorizerBase(String mimeType) {
        this.getPluginPreferenceStore().addPropertyChangeListener(this._propertyChangeListener);
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this._propertyChangeListener);
        this.initializeColorTables();
        this.initializeBaseColorTable();
    }

    private void initializeBaseColorTable() {
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        RGB color = PreferenceConverter.getColor((IPreferenceStore)store, (String)"com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_BACKGROUND_COLOR");
        if (color != null) {
            Color newColor = UnifiedColorManager.getInstance().getColor(color);
            this._occurrenceHighlight = new TextAttribute(UnifiedColorManager.getInstance().getColor(new RGB(32, 32, 32)), newColor, 0);
        }
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        if (this._propertyChangeListener != null) {
            this.getPluginPreferenceStore().removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
    }

    protected abstract void initializeColorTables();

    protected void addRange(Vector<StyleRange> styles, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            styles.add(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
        }
    }

    public TextAttribute getColorPreference(String preferenceKey) {
        return this.getColorPreference(preferenceKey, 0);
    }

    public TextAttribute getColorPreference(String preferenceKey, int style) {
        IPreferenceStore store = this.getPluginPreferenceStore();
        RGB color = PreferenceConverter.getColor((IPreferenceStore)store, (String)preferenceKey);
        if (color != null) {
            Color newColor = UnifiedColorManager.getInstance().getColor(color);
            return new TextAttribute(newColor, null, style);
        }
        return null;
    }

    public TextAttribute getHighlightColorPreference() {
        return this._occurrenceHighlight;
    }

    public void highlightMarkedElement(Vector<StyleRange> styles, Lexeme lx) {
        this.addRange(styles, lx.offset, lx.length, this.getHighlightColorPreference());
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if ("com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_BACKGROUND_COLOR".equals(event.getProperty())) {
            this.initializeBaseColorTable();
        } else {
            this.initializeColorTables();
        }
    }

    @Override
    public void createStyleEx(Lexeme lx, Vector<StyleRange> styles) {
        if (lx.isHighlighted()) {
            this.highlightMarkedElement(styles, lx);
        }
    }

    protected abstract IPreferenceStore getPluginPreferenceStore();

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            UnifiedColorizerBase.this.handlePreferenceStoreChanged(event);
        }
    }
}

