/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.formatting.IUnifiedBracketInserter;
import com.aptana.ide.editors.formatting.UnifiedBracketInserterManager;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.ITextTripleClickStrategy;
import com.aptana.ide.editors.unified.UnifiedAnnotationHover;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedInformationControl;
import com.aptana.ide.editors.unified.UnifiedInformationPresenter;
import com.aptana.ide.editors.unified.UnifiedInformationProvider;
import com.aptana.ide.editors.unified.UnifiedReconcilingStrategy;
import com.aptana.ide.editors.unified.contentassist.IUnifiedContentAssistant;
import com.aptana.ide.editors.unified.hyperlinks.UnifiedHyperlinkDetector;
import com.aptana.ide.editors.unified.utils.HTMLTextPresenter;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class UnifiedConfiguration
extends SourceViewerConfiguration {
    public static final String CLASS_ATTR = "class";
    public static final String NAME_ATTR = "name";
    public static final String UNIFIED_PARTITIONING = "__unified_partitioning";
    public static final int HISTORY_BUFFER_SIZE = 500;
    UnifiedEditor editor;
    UnifiedColorManager colorManager;
    protected IPreferenceStore fPreferenceStore;
    private boolean useSpaces = false;
    private int tabWidth = 4;
    private MonoReconciler _reconciler;
    private UnifiedReconcilingStrategy _strategy;
    private static String LINE_DELIM = System.getProperty("line.separator", "\r\n");

    public UnifiedConfiguration(UnifiedEditor editor, IPreferenceStore preferenceStore) {
        this.editor = editor;
        this.editor.getBaseContributor().setParentConfiguration(this);
        this.fPreferenceStore = preferenceStore;
        this.useSpaces = this.fPreferenceStore.getBoolean("com.aptana.ide.editor.INSERT_SPACES_FOR_TABS");
        this.tabWidth = this.fPreferenceStore.getInt("tabWidth");
    }

    public void dispose() {
        if (this._strategy != null) {
            this._strategy.dispose();
        }
        this._strategy = null;
        this._reconciler = null;
        if (this.editor.getBaseContributor() != null) {
            this.editor.getBaseContributor().setParentConfiguration(null);
        }
        this.editor = null;
        this.colorManager = null;
        this.fPreferenceStore = null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return this.editor.getBaseContributor().getAutoEditStrategies(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.editor.getBaseContributor().getContentTypes();
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return UNIFIED_PARTITIONING;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant assistant = this.loadExtensionContentAssistant();
        if (assistant instanceof IUnifiedContentAssistant) {
            IUnifiedContentAssistant uAssist = (IUnifiedContentAssistant)assistant;
            uAssist.setEditor(this.editor);
            String[] contentTypes = this.editor.getBaseContributor().getContentTypes();
            String docPart = this.getConfiguredDocumentPartitioning(sourceViewer);
            uAssist.setDocumentPartitioning(docPart);
            int j = 0;
            while (j < contentTypes.length) {
                IContentAssistProcessor processor = this.editor.getBaseContributor().getContentAssistProcessor(sourceViewer, contentTypes[j]);
                if (processor != null) {
                    uAssist.setContentAssistProcessor(processor, contentTypes[j]);
                }
                ++j;
            }
            IInformationControlCreator icc = this.getInformationControlCreator(sourceViewer);
            uAssist.setInformationControlCreator(icc);
            if (this.fPreferenceStore != null) {
                int delay = this.fPreferenceStore.getInt("com.aptana.ide.editor.CONTENT_ASSIST_DELAY");
                uAssist.setAutoActivationDelay(delay);
            }
            boolean activation = this.editor.autoActivateCodeAssist();
            uAssist.enableAutoActivation(activation);
            uAssist.setContextInformationPopupOrientation(21);
        }
        return assistant;
    }

    public UnifiedBracketInserterManager getBracketInserterManager(ISourceViewer sourceViewer) {
        UnifiedBracketInserterManager assistant = new UnifiedBracketInserterManager(sourceViewer);
        String[] contentTypes = this.editor.getBaseContributor().getContentTypes();
        String docPart = this.getConfiguredDocumentPartitioning(sourceViewer);
        assistant.setDocumentPartitioning(docPart);
        int j = 0;
        while (j < contentTypes.length) {
            IUnifiedBracketInserter processor = this.editor.getBaseContributor().getBracketInserter(sourceViewer, contentTypes[j]);
            if (processor != null) {
                assistant.setBracketInserter(processor, contentTypes[j]);
            }
            ++j;
        }
        return assistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new UnifiedInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public static IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 20;
                int style = 0;
                return new UnifiedInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] supers = super.getHyperlinkDetectors(sourceViewer);
        EditorFileContext fs = this.editor.getFileContext();
        IFileLanguageService fileEnvironment = fs.getLanguageService(fs.getDefaultLanguage());
        UnifiedHyperlinkDetector detector = new UnifiedHyperlinkDetector(fileEnvironment);
        IHyperlinkDetector[] plusUnified = new IHyperlinkDetector[supers.length + 1];
        System.arraycopy(supers, 0, plusUnified, 0, supers.length);
        plusUnified[plusUnified.length - 1] = detector;
        return plusUnified;
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return UnifiedConfiguration.getInformationPresenterControlCreator();
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        UnifiedInformationPresenter informationPresenter = new UnifiedInformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        informationPresenter.setDocumentPartitioning(UNIFIED_PARTITIONING);
        UnifiedInformationProvider provider = new UnifiedInformationProvider(sourceViewer, this.editor.getBaseContributor().getFileContext());
        String[] types = this.getConfiguredContentTypes(sourceViewer);
        informationPresenter.setInformationProvider(provider, UNIFIED_PARTITIONING);
        int j = 0;
        while (j < types.length) {
            informationPresenter.setInformationProvider(provider, types[j]);
            ++j;
        }
        informationPresenter.setSizeConstraints(60, 10, true, true);
        return informationPresenter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return this.editor.getBaseContributor().getDoubleClickStrategy(sourceViewer, contentType);
    }

    public ITextTripleClickStrategy getTripleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return this.editor.getBaseContributor().getTripleClickStrategy(sourceViewer, contentType);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        this.editor.getBaseContributor().configPresentationReconciler(reconciler);
        reconciler.setDocumentPartitioning(UNIFIED_PARTITIONING);
        return reconciler;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return this.editor.getBaseContributor().getTextHover(sourceViewer, contentType);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.editor.getBaseContributor().getTextHover(sourceViewer, contentType);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new UnifiedAnnotationHover();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        this._strategy = this.editor.getBaseContributor().getReconcilingStrategy();
        if (this._strategy == null) {
            return null;
        }
        this._strategy.setEditor(this.editor);
        this._reconciler = new MonoReconciler((IReconcilingStrategy)this._strategy, false);
        this._reconciler.setDelay(1000);
        return this._reconciler;
    }

    public static String getNewlineString() {
        return LINE_DELIM;
    }

    public static boolean isNewlineString(String string) {
        return string.equals("\r") || string.equals("\n") || string.equals("\r\n");
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return super.getDefaultPrefixes(sourceViewer, contentType);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (this.useSpacesAsTabs()) {
            return this.getSpacesIndexPrefix();
        }
        return this.getTabsIndexPrefix();
    }

    public String[] getSpacesIndexPrefix() {
        String spaces = this.getTabAsSpaces();
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.addAll((Collection)Arrays.asList(StringUtils.getArrayOfSpaces((int)spaces.length())));
        prefixes.add("\t");
        return prefixes.toArray(new String[0]);
    }

    public String[] getTabsIndexPrefix() {
        String spaces = this.getTabAsSpaces();
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("\t");
        prefixes.addAll((Collection)Arrays.asList(StringUtils.getArrayOfSpaces((int)spaces.length())));
        return prefixes.toArray(new String[0]);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("tabWidth");
    }

    public boolean useSpacesAsTabs() {
        return this.useSpaces;
    }

    public String getTabAsSpaces() {
        return StringUtils.getSpaces((int)this.tabWidth);
    }

    public String getIndent() {
        if (this.useSpacesAsTabs()) {
            return this.getTabAsSpaces();
        }
        return "\t";
    }

    public void setTabWidth(int tabWidth, boolean useSpaces, ISourceViewer sourceViewer) {
        this.useSpaces = useSpaces;
        this.tabWidth = tabWidth;
        String[] prefixes = useSpaces ? this.getSpacesIndexPrefix() : this.getTabsIndexPrefix();
        this.editor.getBaseContributor().setAllIndentPrefixes(prefixes, sourceViewer);
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
        int historySize = store.getInt("undoHistorySize");
        if (historySize <= 0) {
            historySize = 500;
        }
        return new DefaultUndoManager(historySize);
    }

    public UnifiedReconcilingStrategy getStrategy() {
        return this._strategy;
    }

    public IContentAssistant loadExtensionContentAssistant() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.contentassistant");
        if (ep == null) {
            return new ContentAssistant();
        }
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            try {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String assistantType = elements[j].getAttribute(CLASS_ATTR);
                    if (assistantType != null) {
                        return (IContentAssistant)elements[j].createExecutableExtension(CLASS_ATTR);
                    }
                    ++j;
                }
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Unable to load content assistant");
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
            }
            ++i;
        }
        return new ContentAssistant();
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        DefaultHyperlinkPresenter pr = new DefaultHyperlinkPresenter(new RGB(0, 0, 255)){
            private IRange range;

            public void applyTextPresentation(TextPresentation textPresentation) {
                super.applyTextPresentation(textPresentation);
            }

            public void hideHyperlinks() {
                if (this.range == null || UnifiedConfiguration.this.editor.getViewer().getDocument().getLength() > this.range.getEndingOffset()) {
                    UnifiedConfiguration.this.editor.setUnderlinedRange(this.range);
                }
                super.hideHyperlinks();
                this.range = null;
            }

            public void showHyperlinks(IHyperlink[] hyperlinks) {
                if (hyperlinks.length == 1) {
                    if (this.range != null && UnifiedConfiguration.this.editor.getViewer().getDocument().getLength() > this.range.getEndingOffset()) {
                        UnifiedConfiguration.this.editor.setUnderlinedRange(this.range);
                    }
                    IRegion hyperlinkRegion = hyperlinks[0].getHyperlinkRegion();
                    this.range = new Range(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength() + hyperlinkRegion.getOffset());
                    UnifiedConfiguration.this.editor.removeUnderlinedRange(this.range);
                }
                super.showHyperlinks(hyperlinks);
            }
        };
        return pr;
    }
}

