/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UnifiedInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
DisposeListener {
    private static final int OUTER_BORDER = 1;
    private static final int INNER_BORDER = 3;
    private Shell fShell;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private int fMaxHeight = -1;
    private String statusFieldText = null;
    private Font fStatusTextFont;

    public UnifiedInformationControl(Shell parent, int shellStyle, int style, DefaultInformationControl.IInformationPresenter presenter) {
        this(parent, shellStyle, style, presenter, null);
    }

    public UnifiedInformationControl(Shell parent, int shellStyle, int style, DefaultInformationControl.IInformationPresenter presenter, String statusFieldText) {
        int border;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (shellStyle & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite = new Composite((Composite)composite, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setForeground(display.getSystemColor(28));
        composite.setBackground(display.getSystemColor(29));
        this.fText = new StyledText((Composite)composite, 0xA | style);
        gd = new GridData(1809);
        gd.horizontalIndent = 3;
        gd.verticalIndent = 3;
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(display.getSystemColor(28));
        this.fText.setBackground(display.getSystemColor(29));
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    UnifiedInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fPresenter = presenter;
        this.statusFieldText = statusFieldText;
        if (statusFieldText != null) {
            Label separator = new Label((Composite)composite, 259);
            separator.setLayoutData((Object)new GridData(768));
            Label statusField = new Label((Composite)composite, 131072);
            statusField.setText(statusFieldText);
            Font font = statusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)statusField.getDisplay(), fontDatas);
            statusField.setFont(this.fStatusTextFont);
            gd = new GridData(802);
            statusField.setLayoutData((Object)gd);
            statusField.setForeground(display.getSystemColor(17));
            statusField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
    }

    public UnifiedInformationControl(Shell parent, int style, DefaultInformationControl.IInformationPresenter presenter) {
        this(parent, 12, style, presenter);
    }

    public UnifiedInformationControl(Shell parent, int style, DefaultInformationControl.IInformationPresenter presenter, String statusFieldText) {
        this(parent, 12, style, presenter, statusFieldText);
    }

    public UnifiedInformationControl(Shell parent) {
        this(parent, 0, null);
    }

    public UnifiedInformationControl(Shell parent, DefaultInformationControl.IInformationPresenter presenter) {
        this(parent, 0, presenter);
    }

    public UnifiedInformationControl(Shell parent, DefaultInformationControl.IInformationPresenter presenter, String status) {
        this(parent, 0, presenter, status);
    }

    public void setInformation(String content) {
        if (this.fPresenter == null) {
            this.fText.setText(content);
        } else {
            this.fPresentation.clear();
            content = this.fPresenter.updatePresentation(this.fShell.getDisplay(), content, this.fPresentation, 260, this.fMaxHeight);
            if (content != null) {
                this.fText.setText(content);
                TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
            } else {
                this.fText.setText("");
            }
        }
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fShell = null;
        this.fText = null;
        this.fStatusTextFont = null;
    }

    public void setSize(int width, int height) {
        int extraLines = this.statusFieldText == null ? 1 : 2;
        int computedHeight = (this.fText.getLineCount() + extraLines) * this.fText.getLineHeight();
        this.fShell.setSize(width, computedHeight);
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fText.getLocation();
        location.x += trim.x - textLocation.x + 3;
        location.y += trim.y - textLocation.y + 3;
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public Rectangle computeTrim() {
        return this.fShell.computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return true;
    }

    public StyledText getStyledTextWidget() {
        return this.fText;
    }

    public Shell getShell() {
        return this.fShell;
    }
}

