/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.DocumentationHelper;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.UnifiedInformationControl;
import com.aptana.ide.editors.unified.hover.LexemeHoverRegion;
import com.aptana.ide.editors.unified.utils.HTMLTextPresenter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;

public class UnifiedInformationProvider
implements IInformationProvider,
IInformationProviderExtension2 {
    ISourceViewer sourceViewer;
    EditorFileContext context;

    public UnifiedInformationProvider(ISourceViewer sourceViewer, EditorFileContext context) {
        this.sourceViewer = sourceViewer;
        this.context = context;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new UnifiedInformationControl(parent, 20, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        LexemeList lexemes = this.context.getLexemeList();
        if (lexemes == null) {
            return null;
        }
        Lexeme currentLexeme = lexemes.getLexemeFromOffset(offset);
        return new LexemeHoverRegion(currentLexeme);
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        LexemeHoverRegion hr = (LexemeHoverRegion)subject;
        Lexeme lexeme = hr.getLexeme();
        if (lexeme == null) {
            return "";
        }
        IFileLanguageService langService = this.context.getLanguageService(lexeme.getToken().getLanguage());
        boolean showDebug = false;
        try {
            IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
            if (store.getBoolean("com.aptana.ide.editors.SHOW_DEBUG_HOVER")) {
                showDebug = true;
            }
        }
        catch (Exception exception) {}
        if (langService != null) {
            if (showDebug) {
                return DocumentationHelper.generateLexemeDebugInfo(langService.getFileContext(), lexeme);
            }
            return langService.getDocumentationFromLexeme(lexeme);
        }
        return "";
    }
}

