/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.actions;

import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class InformationDispatchAction
extends TextEditorAction {
    private TextOperationAction fTextOperationAction;
    private InformationPresenter fInformationPresenter;

    public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction, ITextEditor editor) {
        super(resourceBundle, prefix, editor);
        if (textOperationAction == null) {
            throw new IllegalArgumentException();
        }
        this.fTextOperationAction = textOperationAction;
    }

    public void run() {
        ITextViewerExtension4 extension4;
        ISourceViewer sourceViewer = ((IUnifiedEditor)this.getTextEditor()).getViewer();
        if (sourceViewer == null) {
            this.fTextOperationAction.run();
            return;
        }
        if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
            return;
        }
        if (!(sourceViewer instanceof ITextViewerExtension2)) {
            this.fTextOperationAction.run();
            return;
        }
        ITextViewerExtension2 textViewerExtension2 = (ITextViewerExtension2)sourceViewer;
        ITextHover textHover = textViewerExtension2.getCurrentTextHover();
        if (textHover == null) {
            this.fTextOperationAction.run();
            return;
        }
        Point hoverEventLocation = textViewerExtension2.getHoverEventLocation();
        int offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
        if (offset == -1) {
            this.fTextOperationAction.run();
            return;
        }
        try {
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)"__unified_partitioning", (int)offset, (boolean)true);
            IRegion hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
            if (hoverRegion == null) {
                return;
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            class InformationProvider
            implements IInformationProvider,
            IInformationProviderExtension2 {
                private IRegion fHoverRegion;
                private String fHoverInfo;
                private IInformationControlCreator fControlCreator;

                InformationProvider(IRegion hoverRegion, String hoverInfo, IInformationControlCreator controlCreator) {
                    this.fHoverRegion = hoverRegion;
                    this.fHoverInfo = hoverInfo;
                    this.fControlCreator = controlCreator;
                }

                public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
                    return this.fHoverRegion;
                }

                public String getInformation(ITextViewer textViewer, IRegion subject) {
                    return this.fHoverInfo;
                }

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return this.fControlCreator;
                }
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            InformationPresenter presenter = this.getInformationPresenter();
            presenter.setOffset(offset);
            presenter.setDocumentPartitioning("__unified_partitioning");
            presenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            presenter.showInformation();
        }
        catch (BadLocationException badLocationException) {}
    }

    private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
        StyledText styledText = textViewer.getTextWidget();
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return -1;
        }
        try {
            int widgetLocation = styledText.getOffsetAtLocation(new Point(x, y));
            if (textViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                return extension.widgetOffset2ModelOffset(widgetLocation);
            }
            IRegion visibleRegion = textViewer.getVisibleRegion();
            return widgetLocation + visibleRegion.getOffset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    private InformationPresenter getInformationPresenter() {
        if (this.fInformationPresenter == null) {
            IInformationControlCreator informationControlCreator = UnifiedConfiguration.getInformationPresenterControlCreator();
            this.fInformationPresenter = new InformationPresenter(informationControlCreator);
            this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
            this.fInformationPresenter.install((ITextViewer)((IUnifiedEditor)this.getTextEditor()).getViewer());
        }
        return this.fInformationPresenter;
    }

    public void dispose() {
        this.fTextOperationAction = null;
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.dispose();
            this.fInformationPresenter = null;
        }
    }
}

