/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UnifiedColorizerBase;
import com.aptana.ide.editors.unified.colorizer.CategoryColorizer;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.IColorizerHandler;
import com.aptana.ide.editors.unified.colorizer.IExtendedColorizerHandler;
import com.aptana.ide.editors.unified.colorizer.TokenColorizer;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.IParseState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageColorizer
extends UnifiedColorizerBase {
    private List<IColorizerHandler> handlers;
    private Map<String, TokenColorizer> tokenColorizers;
    private Map<String, CategoryColorizer> categoryColorizers;
    private TextAttribute DEFAULT;
    private String mimeType;
    private Color background;
    private Color selectionBg;
    private Color selectionFg;
    private Color caretColor;
    private Color lineHighlightColor;
    private Color foldingBg;
    private Color foldingFg;

    public static String hashToken(IToken token) {
        return String.valueOf(token.getLanguage()) + "::" + token.getCategory() + "::" + token.getType();
    }

    public static void fireColorizationEvent() {
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().firePropertyChangeEvent("Colorization saved", (Object)"Colorization saved", (Object)"Colorization saved");
    }

    public LanguageColorizer(String mimeType) {
        super(mimeType);
        this.mimeType = mimeType;
        this.tokenColorizers = new HashMap<String, TokenColorizer>();
        this.categoryColorizers = new HashMap<String, CategoryColorizer>();
        this.handlers = new ArrayList<IColorizerHandler>();
        RGB fgRGB = new RGB(0, 0, 0);
        Color fgColor = UnifiedColorManager.getInstance().getColor(fgRGB);
        this.DEFAULT = new TextAttribute(fgColor, null, 0);
        this.background = null;
        this.selectionBg = null;
        this.selectionFg = null;
        this.caretColor = null;
        this.lineHighlightColor = null;
    }

    public void addHandler(IColorizerHandler handler) {
        this.handlers.add(handler);
    }

    public List<IColorizerHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    protected IPreferenceStore getPluginPreferenceStore() {
        return UnifiedEditorsPlugin.getDefault().getPreferenceStore();
    }

    @Override
    protected void initializeColorTables() {
    }

    @Override
    public void createStyle(IParseState parseState, Lexeme lx, Vector<StyleRange> styles) {
        IToken token = lx.getToken();
        TokenColorizer tc = this.getTokenColorizer(token);
        IColorizerHandler handler = null;
        StyleRange handlerStyleRange = null;
        int i = 0;
        while (i < this.handlers.size()) {
            handler = this.handlers.get(i);
            handlerStyleRange = handler.getStyleRange(parseState, lx);
            if (handlerStyleRange != null) break;
            ++i;
        }
        if (handlerStyleRange != null) {
            styles.add(handlerStyleRange);
        } else if (tc != null) {
            tc.colorize(styles, lx.offset, lx.length);
        } else if (this.categoryColorizers.containsKey(token.getCategory())) {
            CategoryColorizer colorizer = this.categoryColorizers.get(token.getCategory());
            ColorizationStyle style = colorizer.getStyle();
            int bold = style.isBold() ? 1 : 0;
            int italic = style.isItalic() ? 2 : 0;
            StyleRange sr = new StyleRange(lx.offset, lx.length, style.getForegroundColor(), style.getBackgroundColor(), bold | italic);
            sr.underline = style.isUnderline();
            styles.add(sr);
        } else {
            StyleRange sr = new StyleRange(lx.offset, lx.length, this.DEFAULT.getForeground(), this.DEFAULT.getBackground(), this.DEFAULT.getStyle());
            styles.add(sr);
        }
        i = 0;
        while (i < this.handlers.size()) {
            IExtendedColorizerHandler cm;
            StyleRange[] styleRanges;
            handler = this.handlers.get(i);
            if (handler instanceof IExtendedColorizerHandler && (styleRanges = (cm = (IExtendedColorizerHandler)handler).getStyleRanges(parseState, lx)) != null) {
                styles.addAll((Collection<StyleRange>)Arrays.asList(styleRanges));
            }
            ++i;
        }
    }

    public void addTokenColorizer(TokenColorizer colorizer) {
        IToken token = colorizer.getToken();
        this.tokenColorizers.put(LanguageColorizer.hashToken(token), colorizer);
    }

    public TokenColorizer removeTokenColorizer(IToken token) {
        TokenColorizer retVal = null;
        String key = LanguageColorizer.hashToken(token);
        if (this.tokenColorizers.containsKey(key)) {
            retVal = this.tokenColorizers.remove(key);
        }
        return retVal;
    }

    public TokenColorizer getTokenColorizer(IToken token) {
        if (this.tokenColorizers.containsKey(LanguageColorizer.hashToken(token))) {
            return this.tokenColorizers.get(LanguageColorizer.hashToken(token));
        }
        return null;
    }

    public Collection getTokenColorizers() {
        return this.tokenColorizers.values();
    }

    public void addTokenColorizers(Collection colorizers) {
        Iterator iter = colorizers.iterator();
        while (iter.hasNext()) {
            this.addTokenColorizer((TokenColorizer)iter.next());
        }
    }

    public void retainTokens(Iterator tokens) {
        ArrayList<String> keys = new ArrayList<String>();
        while (tokens.hasNext()) {
            IToken token = (IToken)tokens.next();
            keys.add(LanguageColorizer.hashToken(token));
        }
        this.tokenColorizers.keySet().retainAll(keys);
    }

    public void addCategoryColorizer(CategoryColorizer colorizer) {
        this.categoryColorizers.put(colorizer.getName(), colorizer);
    }

    public CategoryColorizer getCategoryColorizer(String category) {
        if (this.categoryColorizers.containsKey(category)) {
            return this.categoryColorizers.get(category);
        }
        return null;
    }

    public Collection getCategories() {
        return this.categoryColorizers.keySet();
    }

    public Collection getCategoryColorizers() {
        return this.categoryColorizers.values();
    }

    public void setTokenColorizers(LanguageColorizer colorizer) {
        this.tokenColorizers = colorizer.tokenColorizers;
    }

    public void setCategoryColorizers(LanguageColorizer colorizer) {
        this.categoryColorizers = colorizer.categoryColorizers;
    }

    public String getLanguage() {
        return this.mimeType;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getBackground(IParseState state, Lexeme lexeme) {
        Color bg = null;
        IColorizerHandler handler = null;
        int i = 0;
        while (i < this.handlers.size()) {
            handler = this.handlers.get(i);
            bg = handler.getBackground(state, lexeme);
            if (bg != null) break;
            ++i;
        }
        if (bg == null) {
            bg = this.background;
        }
        return bg;
    }

    public Color getEmptyLineBackground(IParseState state, int offset) {
        Color bg = null;
        IColorizerHandler handler = null;
        int i = 0;
        while (i < this.handlers.size()) {
            handler = this.handlers.get(i);
            bg = handler.getEmptyLineColor(state, offset);
            if (bg != null) break;
            ++i;
        }
        if (bg == null) {
            bg = this.background;
        }
        return bg;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
    }

    public Color getSelectionBackground() {
        return this.selectionBg;
    }

    public void setSelectionBackground(Color selectionBg) {
        this.selectionBg = selectionBg;
    }

    public Color getSelectionForeground() {
        return this.selectionFg;
    }

    public void setSelectionForeground(Color selectionFg) {
        this.selectionFg = selectionFg;
    }

    public Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
    }

    public Color getFoldingBg() {
        return this.foldingBg;
    }

    public void setFoldingBg(Color foldingBg) {
        this.foldingBg = foldingBg;
    }

    public Color getFoldingFg() {
        return this.foldingFg;
    }

    public void setFoldingFg(Color foldingFg) {
        this.foldingFg = foldingFg;
    }
}

