/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;

public class Region {
    private int offset;
    private int length;
    private ColorizationStyle style;
    private boolean relativeOffset;
    private boolean relativeLength;
    private String name;
    private String offsetString;
    private String lengthString;

    public Region(int offset, boolean relativeOffset, int length, boolean relativeLength, ColorizationStyle style) {
        this.offset = offset;
        this.length = length;
        this.style = style;
        this.relativeLength = relativeLength;
        this.relativeOffset = relativeOffset;
    }

    public Region(Region region) {
        this.offset = region.offset;
        this.length = region.length;
        this.style = region.style;
        this.relativeLength = region.relativeLength;
        this.relativeOffset = region.relativeOffset;
        this.offsetString = region.offsetString;
        this.lengthString = region.lengthString;
    }

    public int getLength(int lexemeLength) {
        if (this.relativeLength) {
            return lexemeLength + this.length;
        }
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getOffset(int lexemeLength) {
        if (this.relativeOffset) {
            return lexemeLength + this.offset;
        }
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public ColorizationStyle getStyle() {
        return this.style;
    }

    public void setStyle(ColorizationStyle style) {
        this.style = style;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLengthString() {
        return this.lengthString;
    }

    public void setLengthString(String lengthString) {
        this.lengthString = lengthString;
    }

    public String getOffsetString() {
        return this.offsetString;
    }

    public void setOffsetString(String offsetString) {
        this.offsetString = offsetString;
    }

    public boolean isRelativeLength() {
        return this.relativeLength;
    }

    public void setRelativeLength(boolean relativeLength) {
        this.relativeLength = relativeLength;
    }

    public boolean isRelativeOffset() {
        return this.relativeOffset;
    }

    public void setRelativeOffset(boolean relativeOffset) {
        this.relativeOffset = relativeOffset;
    }
}

