/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.errors;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.errors.ErrorMarker;
import com.aptana.ide.editors.unified.errors.FileErrorListener;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.Messages;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ExternalFileErrorListener
extends FileErrorListener {
    private IAnnotationModel annotationModel;
    private IDocument document;

    public ExternalFileErrorListener(IAnnotationModel annotationModel, IDocument document) {
        this.annotationModel = annotationModel;
        this.document = document;
    }

    public void onErrorsChanged(final IFileError[] errors) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                ExternalFileErrorListener.this.updateErrors(errors);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ExternalFileErrorListener_Error, (Throwable)e);
        }
    }

    public ErrorMarker createMarker(IFileError error) {
        MarkerInfo info = new MarkerInfo();
        info.setType("org.eclipse.core.resources.problemmarker");
        info.setCreationTime(System.currentTimeMillis());
        ErrorMarker marker = new ErrorMarker(info, error.getOffset(), error.getLength());
        this.setMarkerAttributes(marker, error, this.document);
        return marker;
    }

    private String createAnnotationKey(Annotation annotation, int offset, int length) {
        return String.valueOf(offset) + ":" + length + ":" + annotation.getText() + ":" + annotation.getType();
    }

    public void updateErrors(IFileError[] errors) {
        Hashtable<String, Annotation> h = new Hashtable<String, Annotation>();
        Iterator it = this.annotationModel.getAnnotationIterator();
        while (it.hasNext()) {
            String key;
            Annotation element = (Annotation)it.next();
            Position p = this.annotationModel.getPosition(element);
            if (p == null || h.containsKey(key = this.createAnnotationKey(element, p.offset, p.length))) continue;
            h.put(key, element);
        }
        int i = 0;
        while (i < errors.length) {
            SimpleMarkerAnnotation a = new SimpleMarkerAnnotation((IMarker)this.createMarker(errors[i]));
            String key = this.createAnnotationKey((Annotation)a, errors[i].getOffset(), errors[i].getLength());
            if (!h.containsKey(key)) {
                this.annotationModel.addAnnotation((Annotation)a, new Position(errors[i].getOffset(), errors[i].getLength()));
            } else {
                h.remove(key);
            }
            ++i;
        }
        Collection vals = h.values();
        for (Annotation element : vals) {
            SimpleMarkerAnnotation sma;
            if (!(element instanceof SimpleMarkerAnnotation) || !((sma = (SimpleMarkerAnnotation)element).getMarker() instanceof ErrorMarker)) continue;
            this.annotationModel.removeAnnotation(element);
        }
    }
}

