/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.errors;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.actions.ShowErrors;
import com.aptana.ide.editors.actions.ShowInfos;
import com.aptana.ide.editors.actions.ShowWarnings;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.ErrorDescriptor;
import com.aptana.ide.editors.unified.errors.FileError;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.Messages;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.validator.ValidatorManager;
import com.aptana.ide.editors.validator.ValidatorRef;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class UnifiedErrorManager
implements IErrorManager,
IPropertyChangeListener {
    ErrorDescriptor[] _errorDescriptors;
    protected FileService fileService;
    String mimeType;
    ValidatorRef[] validators;

    public UnifiedErrorManager(FileService fileService, String mimeType) {
        this.fileService = fileService;
        this.mimeType = mimeType;
        if (this.getPreferenceStore() != null) {
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.initializeValidators();
    }

    public void onContentChanged(FileContextContentEvent evt) {
        if (evt.getSource() != this.fileService) {
            return;
        }
        IFileSourceProvider sourceProvider = this.fileService.getSourceProvider();
        String path = CoreUIUtils.getPathFromURI((String)sourceProvider.getSourceURI());
        String sourceString = null;
        try {
            sourceString = sourceProvider.getSource();
        }
        catch (IOException e1) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedErrorManager_Error, (Throwable)e1);
            return;
        }
        if (sourceProvider instanceof DocumentSourceProvider) {
            IFileError[] errors = this.parseForErrors(path, sourceString, sourceProvider);
            this.fileService.setFileErrors(errors);
        }
    }

    public boolean showInfos() {
        return ShowInfos.isInstanceChecked();
    }

    public boolean showWarnings() {
        return ShowWarnings.isInstanceChecked();
    }

    public boolean showErrors() {
        return ShowErrors.isInstanceChecked();
    }

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider) {
        this.loadErrorDescriptors();
        IFileError[] errors = new IFileError[]{};
        UnifiedErrorReporter reporter = new UnifiedErrorReporter(sourceProvider);
        reporter.addErrors(errors);
        if (this.validators != null) {
            int i = 0;
            while (i < this.validators.length) {
                ValidatorRef validatorRef = this.validators[i];
                try {
                    errors = validatorRef.parseForErrors(path, source, sourceProvider, this.showErrors(), this.showWarnings(), this.showInfos());
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedErrorManager_ValidatorRefParseDelegationError, (Throwable)ex);
                }
                if (errors != null & errors.length > 0) {
                    reporter.addErrors(errors);
                }
                ++i;
            }
        }
        errors = this.filterMessages(reporter.getErrors());
        return errors;
    }

    private IFileError[] filterMessages(IFileError[] errors) {
        ArrayList<IFileError> newErrors = new ArrayList<IFileError>();
        int i = 0;
        while (i < errors.length) {
            IFileError error = errors[i];
            if (this.filterMessage(error.getMessage()) != null) {
                newErrors.add(error);
            }
            ++i;
        }
        return newErrors.toArray(new IFileError[0]);
    }

    public String filterMessage(String msg) {
        if (this.isFiltered(0, msg)) {
            return null;
        }
        return msg;
    }

    private void loadErrorDescriptors() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            String editors = store.getString("com.aptana.ide.editors.HTMLEDITOR_IGNORE_PROBLEMS");
            this._errorDescriptors = ErrorDescriptor.deserializeErrorDescriptors(editors);
        }
    }

    protected boolean isFiltered(int severity, String message) {
        if (this._errorDescriptors == null) {
            return false;
        }
        FileError fe = new FileError();
        fe.setMessage(message);
        int i = 0;
        while (i < this._errorDescriptors.length) {
            ErrorDescriptor ed = this._errorDescriptors[i];
            if (ed.matchesError(fe)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.aptana.ide.editors.HTMLEDITOR_IGNORE_PROBLEMS".equals(property) && this.fileService != null) {
            this.fileService.forceContentChangedEvent();
        } else if ("com.aptana.ide.editors.VALIDATORS_LIST".equals(property)) {
            this.initializeValidators();
            this.fileService.forceContentChangedEvent();
        }
    }

    private void initializeValidators() {
        ValidatorRef[] registeredValidators = ValidatorManager.getInstance().getValidators(this.mimeType);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore != null) {
            String property = preferenceStore.getString("com.aptana.ide.editors.VALIDATORS_LIST");
            if (property != null && property.length() > 0) {
                String[] preferredValidators = property.split(",");
                ArrayList<ValidatorRef> newValidators = new ArrayList<ValidatorRef>();
                int i = 0;
                while (i < preferredValidators.length) {
                    int j = 0;
                    while (j < registeredValidators.length) {
                        if (preferredValidators[i].equals(registeredValidators[j].getName())) {
                            newValidators.add(registeredValidators[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                this.validators = newValidators.toArray(new ValidatorRef[0]);
            } else {
                this.validators = registeredValidators;
            }
        } else {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedErrorManager_PreferenceRetrievalError);
            this.validators = registeredValidators;
        }
    }

    public String processLanguagePartition(ITypedRegion partition, String source) {
        return source;
    }

    protected String stripChars(String source, int start, int length) {
        int end = start + length;
        char[] c = source.toCharArray();
        if (end > c.length) {
            end = c.length;
        }
        int i = start;
        while (i < end) {
            if (c[i] != '\r' && c[i] != '\n') {
                c[i] = 32;
            }
            ++i;
        }
        return new String(c);
    }
}

