/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.help;

import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.help.LexemeHelpContext;
import com.aptana.ide.editors.unified.help.Messages;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.ui.IWorkbenchPart;

public class LexemeUIHelp {
    public static final String APTANA_DOCS_KEYWORD = "aptana_docs";

    protected LexemeUIHelp() {
    }

    public static void setHelp(IUnifiedEditor editor, StyledText text, IFileService fileService) {
        LexemeHelpListener listener = new LexemeHelpListener(editor, fileService);
        text.addHelpListener((HelpListener)listener);
    }

    public static IContextProvider getHelpContextProvider(IWorkbenchPart part, IFileService fileService) {
        Lexeme lexeme = null;
        int offset = 0;
        IFileLanguageService fileLanguageService = null;
        if (part instanceof IUnifiedEditor) {
            IUnifiedEditor editor = (IUnifiedEditor)part;
            lexeme = LexemeUIHelp.getLexeme(editor, fileService);
            offset = editor.getViewer().getTextWidget().getCaretOffset();
            if (lexeme != null) {
                fileLanguageService = fileService.getLanguageService(lexeme.getToken().getLanguage());
            }
        }
        return new LexemeHelpContextProvider(fileLanguageService, lexeme, offset);
    }

    public static boolean isValidLexeme(Lexeme lexeme) {
        return lexeme != null;
    }

    public static Lexeme getLexeme(IUnifiedEditor editor, IFileService fileService) {
        int offset = editor.getViewer().getTextWidget().getCaretOffset();
        LexemeList lexemes = fileService.getLexemeList();
        if (lexemes == null) {
            return null;
        }
        int floorIndex = lexemes.getLexemeFloorIndex(offset);
        Lexeme lexeme = null;
        if (floorIndex >= 0) {
            lexeme = lexemes.get(floorIndex);
        }
        int ceilingIndex = lexemes.getLexemeCeilingIndex(offset);
        if (lexeme == null && ceilingIndex >= 0) {
            lexemes.get(lexemes.getLexemeCeilingIndex(offset));
        }
        if (LexemeUIHelp.isValidLexeme(lexeme)) {
            return lexeme;
        }
        return null;
    }

    private static class LexemeHelpListener
    implements HelpListener {
        private IUnifiedEditor fEditor;
        private IFileService fileService;

        public LexemeHelpListener(IUnifiedEditor editor, IFileService fileService) {
            this.fEditor = editor;
            this.fileService = fileService;
        }

        public void helpRequested(HelpEvent e) {
            Lexeme lexeme = null;
            int offset = 0;
            if (this.fEditor != null) {
                lexeme = LexemeUIHelp.getLexeme(this.fEditor, this.fileService);
                offset = this.fEditor.getViewer().getTextWidget().getCaretOffset();
                if (lexeme != null) {
                    String language = lexeme.getToken().getLanguage();
                    LexemeHelpContext.displayHelp("com.aptana.ide.editors.HTMLEditor", this.fileService.getLanguageService(language), lexeme, offset);
                }
            }
        }
    }

    private static class LexemeHelpContextProvider
    implements IContextProvider {
        private String fId = "com.aptana.ide.editors.HTMLEditor";
        private IFileLanguageService fileLanguageService;
        private Lexeme fLexeme;
        private int offset = 0;

        public LexemeHelpContextProvider(IFileLanguageService fileLanguageService, Lexeme lexeme, int offset) {
            this.fileLanguageService = fileLanguageService;
            this.fLexeme = lexeme;
            this.offset = offset;
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object target) {
            Object context = null;
            if (this.fileLanguageService == null) {
                return context;
            }
            if (this.fileLanguageService.getOffsetMapper() == null) {
                return HelpSystem.getContext((String)this.fId);
            }
            Lexeme lexeme = this.fileLanguageService.getOffsetMapper().getCurrentLexeme();
            context = lexeme != null ? new LexemeHelpContext((IContext)context, this.fileLanguageService, lexeme, this.offset) : HelpSystem.getContext((String)this.fId);
            return context;
        }

        public String getSearchExpression(Object target) {
            if (this.fLexeme != null) {
                String lexemeLanguage = this.fLexeme.getLanguage();
                if (lexemeLanguage != null) {
                    lexemeLanguage = lexemeLanguage.replace('/', '_');
                }
                return String.valueOf(lexemeLanguage) + " " + this.fLexeme.getText() + " " + LexemeUIHelp.APTANA_DOCS_KEYWORD;
            }
            return Messages.LexemeUIHelp_Editor;
        }
    }
}

