/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.actions;

import com.aptana.ide.editors.views.actions.Action;
import com.aptana.ide.editors.views.actions.ActionSet;
import com.aptana.ide.editors.views.actions.IAction;
import com.aptana.ide.editors.views.actions.IActionChangeListener;
import java.util.ArrayList;
import java.util.HashMap;

public class ActionsManager {
    private ArrayList _listeners = new ArrayList();
    private ArrayList _actions = new ArrayList();
    private HashMap _actionSets = new HashMap();

    public ActionSet getActionSet(String name) {
        return (ActionSet)this._actionSets.get(name);
    }

    public IAction[] getAll() {
        Action[] actions = this._actions.toArray(new Action[0]);
        ActionSet[] sets = this.getActionSets();
        IAction[] results = new IAction[actions.length + sets.length];
        int index = 0;
        int i = 0;
        while (i < actions.length) {
            results[index++] = actions[i];
            ++i;
        }
        i = 0;
        while (i < sets.length) {
            results[index++] = sets[i];
            ++i;
        }
        return results;
    }

    public void fireActionsChangeEvent(IAction a) {
        int i = 0;
        while (i < this._listeners.size()) {
            IActionChangeListener listener = (IActionChangeListener)this._listeners.get(i);
            listener.onActionChanged(a);
            ++i;
        }
    }

    public void addActionsChangeListener(IActionChangeListener l) {
        this._listeners.add(l);
    }

    public void removeActionsChangeListener(IActionChangeListener l) {
        this._listeners.remove(l);
    }

    public Action addAction(String name, String filename) {
        Action a = new Action(name, filename);
        this._actions.add(a);
        this.fireActionsChangeEvent(a);
        return a;
    }

    public ActionSet createActionSet(String name) {
        ActionSet a;
        if (this._actionSets.containsKey(name)) {
            a = (ActionSet)this._actionSets.get(name);
        } else {
            a = new ActionSet(name);
            this._actionSets.put(name, a);
            this.fireActionsChangeEvent(a);
        }
        return a;
    }

    public void removeActionSet(String name) {
        if (this._actionSets.containsKey(name)) {
            ActionSet a = (ActionSet)this._actionSets.remove(name);
            this.fireActionsChangeEvent(a);
        }
    }

    public ActionSet[] getActionSets() {
        return this._actionSets.values().toArray(new ActionSet[0]);
    }
}

