/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.outline.propertyManager;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.views.outline.propertyManager.EditableProperty;
import com.aptana.ide.editors.views.outline.propertyManager.INumericProperty;
import com.aptana.ide.editors.views.outline.propertyManager.Messages;
import com.aptana.ide.editors.views.outline.propertyManager.SerializableValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class EditableIntegerProperty
extends EditableProperty
implements INumericProperty {
    private static final long serialVersionUID = 1L;
    private int maximum = Integer.MAX_VALUE;
    private int minimum = Integer.MIN_VALUE;
    private int increment = 1;

    public EditableIntegerProperty(String id, String name, int defaultValue) {
        super(id, name);
        this.setDefaultValue(defaultValue);
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public void setMinimumMaximum(int minimum, int maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public void setDefaultValue(int i) {
        this.setUnderlyingDefaultValue(String.valueOf(i));
    }

    public void setValue(int i) {
        this.setUnderlyingValue(String.valueOf(i));
    }

    public ICellEditorValidator getValidator() {
        if (this.validator == null) {
            this.validator = new SerializableValidator(){
                private static final long serialVersionUID = -5817169248707618007L;

                public String isValid(Object value) {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Messages.EditableNumberProperty_NotANumber;
                    }
                    if (intValue > EditableIntegerProperty.this.maximum) {
                        return StringUtils.format((String)Messages.EditableNumberProperty_ValueMustBeLessThan, (int)EditableIntegerProperty.this.maximum);
                    }
                    if (intValue < EditableIntegerProperty.this.minimum) {
                        return StringUtils.format((String)Messages.EditableNumberProperty_ValueMustBeGreaterThan, (int)EditableIntegerProperty.this.minimum);
                    }
                    return null;
                }
            };
        }
        return this.validator;
    }

    public Integer getIntegerValue() {
        return this.getInteger(this.getUnderlyingValue());
    }

    public int getIntValue() {
        return this.getIntegerValue();
    }

    private Integer getInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            try {
                return new Integer(Integer.parseInt(str));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return (Integer)this.getDefaultValue();
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public Number getNumberValue() {
        return this.getIntegerValue();
    }

    public void setNumberValue(Number value) {
        this.setValue(value.intValue());
    }
}

