/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.views.outline;

import com.aptana.ide.lexer.IRange;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.views.outline.Messages;

public class OutlineItem {
    private String _label;
    private String _language;
    private int _type;
    private IRange _sourceRange;
    private int _childCount;
    private IParseNode _referenceNode;

    public OutlineItem(String label, String language, int type, IRange sourceRange, IParseNode referenceNode, int childCount) {
        if (label == null || label.length() == 0) {
            throw new IllegalArgumentException(Messages.JSOutlineItem_Label_Not_Defined);
        }
        if (sourceRange == null) {
            throw new IllegalArgumentException(Messages.JSOutlineItem_Source_Range_Not_Defined);
        }
        this._label = label;
        this._language = language;
        this._type = type;
        this._sourceRange = sourceRange;
        this._referenceNode = referenceNode;
        this._childCount = childCount;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof OutlineItem) {
            OutlineItem that = (OutlineItem)obj;
            result = this.getLabel().equals(that.getLabel());
        } else {
            result = super.equals(obj);
        }
        return result;
    }

    public int getChildCount() {
        return this._childCount;
    }

    public IParseNode getReferenceNode() {
        return this._referenceNode;
    }

    public int getType() {
        return this._type;
    }

    public String getLabel() {
        return this._label;
    }

    public String getLanguage() {
        return this._language;
    }

    public int getEndingOffset() {
        return this._sourceRange.getEndingOffset();
    }

    public int getStartingOffset() {
        return this._sourceRange.getStartingOffset();
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

