/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.VirtualFile;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.core.ui.io.file.ILocalFile;
import com.aptana.ide.core.ui.io.file.InfoDialog;
import com.aptana.ide.core.ui.io.file.LocalFileManager;
import com.aptana.ide.core.ui.io.file.LocalProtocolManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class LocalFile
extends VirtualFile
implements ILocalFile {
    protected static FileSystemView filesys;
    private File _file;
    private LocalFileManager _manager;
    private long _permissions = 0L;
    private Image _image = null;

    static {
        if (!CoreUIUtils.runningOnMac) {
            filesys = FileSystemView.getFileSystemView();
        }
    }

    public LocalFile(LocalFileManager manager, File file) {
        this._file = file;
        this._manager = manager;
    }

    public boolean canRead() {
        boolean result = false;
        if (this._file != null) {
            result = this._file.canRead();
        }
        return result;
    }

    public boolean canWrite() {
        boolean result = false;
        if (this._file != null) {
            result = this._file.canWrite();
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o instanceof LocalFile) {
            return this.getName().compareToIgnoreCase(((LocalFile)o).getName());
        }
        return 0;
    }

    public boolean delete() {
        return this._file.delete();
    }

    public void editProperties(Shell shell) {
        InfoDialog nld = new InfoDialog(shell, 2160);
        nld.setItem(this);
        nld.open();
    }

    public boolean equals(Object arg0) {
        String s;
        boolean result = false;
        if (arg0 instanceof LocalFile && (s = ((LocalFile)arg0).getAbsolutePath()).equals(this.getAbsolutePath())) {
            result = true;
        }
        return result;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public String getAbsolutePath() {
        try {
            return this._file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this._file.getAbsolutePath();
        }
    }

    public long getCreationMillis() {
        return 0L;
    }

    public String getExtension() {
        String result = "";
        String path = this._file.getName();
        int lastDot = path.lastIndexOf(".");
        if (lastDot > -1 && lastDot < path.length() - 2) {
            result = path.substring(lastDot);
        }
        return result;
    }

    public File getFile() {
        return this._file;
    }

    public IVirtualFileManager getFileManager() {
        return this._manager;
    }

    public IVirtualFile[] getFiles() throws IOException {
        return this._manager.getFiles(this);
    }

    public IVirtualFile[] getFiles(boolean recurse, boolean includeCloakedFiles) throws IOException {
        return this._manager.getFiles(this, recurse, includeCloakedFiles);
    }

    public String getGroup() {
        return "";
    }

    public Image getImage() {
        if (this._image == null) {
            return ImageUtils.getIcon(this._file, null);
        }
        return this._image;
    }

    public long getModificationMillis() {
        return this._file.lastModified();
    }

    public String getName() {
        String tempFileName;
        String fileName = this._file.getName();
        if (!(CoreUIUtils.runningOnMac || fileName != null && !"".equals(fileName) && filesys.isFileSystem(this._file) || (tempFileName = filesys.getSystemDisplayName(this._file)) == null)) {
            fileName = tempFileName;
        }
        return fileName;
    }

    public String getOwner() {
        return null;
    }

    public IVirtualFile getParentFile() {
        File parent;
        LocalFile result = null;
        File file = parent = !CoreUIUtils.runningOnMac ? filesys.getParentDirectory(this._file) : this._file.getParentFile();
        if (parent != null) {
            result = new LocalFile(this._manager, parent);
        }
        return result;
    }

    public String getPath() {
        return this._file.getPath();
    }

    public long getPermissions() {
        return this._permissions;
    }

    public String getRelativePath() {
        String basePath = "";
        String path = this.getFileManager().getBasePath();
        if (path != null) {
            basePath = this.getFileManager().getBaseFile().getAbsolutePath();
            if (path.equals(LocalProtocolManager.FileSystemRoots)) {
                basePath = basePath.substring(0, basePath.length() - path.length());
            }
        }
        if (basePath.length() <= this.getAbsolutePath().length()) {
            return this.getAbsolutePath().substring(basePath.length());
        }
        return this.getAbsolutePath();
    }

    public long getSize() {
        return this._file.length();
    }

    public InputStream getStream() {
        return this._manager.getStream(this);
    }

    public boolean hasFiles() {
        return this.hasFiles(false);
    }

    public boolean hasFiles(boolean includeCloakedFiles) {
        return this.isDirectory();
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    public boolean isCloaked() {
        return this._manager.isFileCloaked(this);
    }

    public boolean isDirectory() {
        if (CoreUIUtils.runningOnWindows && (this._file.getName().endsWith(".zip") || this._file.getName().endsWith(".rar"))) {
            return false;
        }
        return this._file.isDirectory();
    }

    public boolean isFile() {
        return this._file.isFile();
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isLink() {
        return false;
    }

    public void putStream(InputStream input, IFileProgressMonitor monitor) throws IOException {
        this._manager.putStream(input, this, monitor);
    }

    public boolean rename(String newName) {
        return this._manager.renameFile(this, newName);
    }

    public void setCloaked(boolean cloak) {
        if (cloak) {
            this._manager.addCloakedFile(this);
        } else {
            this._manager.removeCloakedFile(this);
        }
    }

    public void setGroup(String group) {
    }

    public void setImage(Image image) {
        this._image = image;
    }

    void setInternalFile(File file) {
        this._file = file;
    }

    public void setModificationMillis(long modificationTime) {
        this._file.setLastModified(modificationTime);
    }

    public void setOwner(String owner) {
    }

    public void setPermissions(long permissions) {
        this._permissions = permissions;
    }
}

