/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.io.file.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PermissionsGroup {
    private Group fGroup;
    private Button fUserRead;
    private Button fUserWrite;
    private Button fUserExecute;
    private Button fGroupRead;
    private Button fGroupWrite;
    private Button fGroupExecute;
    private Button fAllRead;
    private Button fAllWrite;
    private Button fAllExecute;

    public PermissionsGroup(Composite parent) {
        this.fGroup = this.createContents(parent);
    }

    public Control getControl() {
        return this.fGroup;
    }

    public int getPermissions() {
        return this.getUserPermission() * 64 + this.getGroupPermission() * 8 + this.getAllPermission();
    }

    public void setPermissions(int permissions) {
        this.setUserPermission(permissions / 64);
        int remainder = permissions % 64;
        this.setGroupPermission(remainder / 8);
        this.setAllPermission(remainder % 8);
    }

    public void setText(String title) {
        if (!this.isDisposed()) {
            this.fGroup.setText(title);
        }
    }

    private Group createContents(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.PermissionsGroup_Title);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText(StringUtils.makeFormLabel((String)Messages.PermissionsGroup_User));
        this.fUserRead = new Button((Composite)group, 32);
        this.fUserRead.setText(Messages.PermissionsGroup_Read);
        this.fUserWrite = new Button((Composite)group, 32);
        this.fUserWrite.setText(Messages.PermissionsGroup_Write);
        this.fUserExecute = new Button((Composite)group, 32);
        this.fUserExecute.setText(Messages.PermissionsGroup_Execute);
        label = new Label((Composite)group, 0);
        label.setText(StringUtils.makeFormLabel((String)Messages.PermissionsGroup_Group));
        this.fGroupRead = new Button((Composite)group, 32);
        this.fGroupRead.setText(Messages.PermissionsGroup_Read);
        this.fGroupWrite = new Button((Composite)group, 32);
        this.fGroupWrite.setText(Messages.PermissionsGroup_Write);
        this.fGroupExecute = new Button((Composite)group, 32);
        this.fGroupExecute.setText(Messages.PermissionsGroup_Execute);
        label = new Label((Composite)group, 0);
        label.setText(StringUtils.makeFormLabel((String)Messages.PermissionsGroup_All));
        this.fAllRead = new Button((Composite)group, 32);
        this.fAllRead.setText(Messages.PermissionsGroup_Read);
        this.fAllWrite = new Button((Composite)group, 32);
        this.fAllWrite.setText(Messages.PermissionsGroup_Write);
        this.fAllExecute = new Button((Composite)group, 32);
        this.fAllExecute.setText(Messages.PermissionsGroup_Execute);
        return group;
    }

    private boolean isDisposed() {
        return this.fGroup == null || this.fGroup.isDisposed();
    }

    private int getUserPermission() {
        return PermissionsGroup.boolToInt(this.fUserRead.getSelection()) * 4 + PermissionsGroup.boolToInt(this.fUserWrite.getSelection()) * 2 + PermissionsGroup.boolToInt(this.fUserExecute.getSelection());
    }

    private int getGroupPermission() {
        return PermissionsGroup.boolToInt(this.fGroupRead.getSelection()) * 4 + PermissionsGroup.boolToInt(this.fGroupWrite.getSelection()) * 2 + PermissionsGroup.boolToInt(this.fGroupExecute.getSelection());
    }

    private int getAllPermission() {
        return PermissionsGroup.boolToInt(this.fAllRead.getSelection()) * 4 + PermissionsGroup.boolToInt(this.fAllWrite.getSelection()) * 2 + PermissionsGroup.boolToInt(this.fAllExecute.getSelection());
    }

    private void setUserPermission(int permission) {
        this.fUserRead.setSelection(PermissionsGroup.intToBool(permission / 4));
        int remainder = permission % 4;
        this.fUserWrite.setSelection(PermissionsGroup.intToBool(remainder / 2));
        this.fUserExecute.setSelection(PermissionsGroup.intToBool(remainder % 2));
    }

    private void setGroupPermission(int permission) {
        this.fGroupRead.setSelection(PermissionsGroup.intToBool(permission / 4));
        int remainder = permission % 4;
        this.fGroupWrite.setSelection(PermissionsGroup.intToBool(remainder / 2));
        this.fGroupExecute.setSelection(PermissionsGroup.intToBool(remainder % 2));
    }

    private void setAllPermission(int permission) {
        this.fAllRead.setSelection(PermissionsGroup.intToBool(permission / 4));
        int remainder = permission % 4;
        this.fAllWrite.setSelection(PermissionsGroup.intToBool(remainder / 2));
        this.fAllExecute.setSelection(PermissionsGroup.intToBool(remainder % 2));
    }

    private static int boolToInt(boolean value) {
        return value ? 1 : 0;
    }

    private static boolean intToBool(int value) {
        return value == 1;
    }
}

