/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.ProtocolManager;
import com.aptana.ide.core.io.VirtualFile;
import com.aptana.ide.core.resources.IProjectProvider;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.io.file.CompressedFile;
import com.aptana.ide.core.ui.io.file.LocalFileManager;
import com.aptana.ide.core.ui.io.file.ProjectFile;
import com.aptana.ide.core.ui.io.file.ProjectProtocolManager;
import com.aptana.ide.io.file.FilePlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileManager
extends LocalFileManager
implements IProjectProvider {
    private static Image fSiteErrorImage = null;
    private static IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private IContainer baseContainer;

    static {
        ImageDescriptor desc = CoreUIPlugin.getImageDescriptor((String)"icons/error.png");
        if (desc != null) {
            fSiteErrorImage = desc.createImage();
        }
    }

    public ProjectFileManager(ProtocolManager protocolManager) {
        super(protocolManager);
    }

    @Override
    public Image getImage() {
        if (this.getBasePath() == null) {
            return fSiteErrorImage;
        }
        return super.getImage();
    }

    @Override
    public String getBasePath() {
        if (this.baseContainer != null && this.baseContainer.getLocation() != null) {
            return this.baseContainer.getLocation().toOSString();
        }
        return super.getBasePath();
    }

    public String getRelativePath() {
        if (this.baseContainer != null && this.baseContainer.getLocation() != null) {
            return this.baseContainer.getFullPath().toPortableString();
        }
        return super.getBasePath();
    }

    @Override
    public void setBasePath(String pathString) {
        try {
            Path path = new Path(pathString);
            this.baseContainer = workspaceRoot.getContainerForLocation((IPath)path);
            if (this.baseContainer == null) {
                this.baseContainer = path.segmentCount() == 1 ? workspaceRoot.getProject(path.segment(0)) : workspaceRoot.getFolder((IPath)path);
            }
            if (this.baseContainer != null) {
                pathString = this.baseContainer.getFullPath().toOSString();
            }
        }
        catch (IllegalStateException illegalStateException) {}
        super.setBasePath(pathString);
    }

    @Override
    public String getHashString() {
        String result = "";
        result = String.valueOf(result) + this.getNickName() + "%%%%";
        result = String.valueOf(result) + this.getRelativePath() + "%%%%";
        result = String.valueOf(result) + this.getId() + "%%%%";
        result = String.valueOf(result) + this.isAutoCalculateServerTimeOffset() + "%%%%";
        try {
            result = String.valueOf(result) + this.getTimeOffset() + "%%%%";
        }
        catch (ConnectionException connectionException) {
            result = String.valueOf(result) + "0%%%%";
        }
        result = String.valueOf(result) + this.serializeCloakedFiles(this.getCloakedFiles()) + "%%%%";
        result = String.valueOf(result) + StringUtils.join((String)"}}}}", (String[])this.getCloakedFileExpressions()) + "%%%%";
        return result;
    }

    public static IVirtualFile[] convertResourcesToFiles(Object[] objects) {
        ArrayList<IVirtualFile> newFiles = new ArrayList<IVirtualFile>();
        int i = 0;
        while (i < objects.length) {
            IVirtualFile file = ProjectFileManager.convertResourceToFile(objects[i]);
            if (file != null) {
                newFiles.add(file);
            }
            ++i;
        }
        return newFiles.toArray(new IVirtualFile[newFiles.size()]);
    }

    public static IVirtualFile convertResourceToFile(Object object) {
        ProjectFile result = null;
        if (object != null && object instanceof IResource) {
            IResource resource = (IResource)object;
            ProjectFileManager tempManager = (ProjectFileManager)ProjectProtocolManager.getInstance().createTemporaryFileManager(true);
            tempManager.setBasePath(resource.getProject().getLocation().toOSString());
            result = new ProjectFile(tempManager, resource);
        }
        return result;
    }

    @Override
    public IVirtualFileManager cloneManager() {
        ProjectFileManager manager = new ProjectFileManager(this.getProtocolManager());
        manager.setId(this.getId());
        manager.setBasePath(this.getBasePath());
        manager.setCloakedFiles(this.getCloakedFiles());
        manager.setImage(this.getImage());
        manager.setDisabledImage(this.getDisabledImage());
        manager.setTransient(this.isTransient());
        return manager;
    }

    @Override
    public void fromSerializableString(String s) {
        super.fromSerializableString(s);
        if (this.getBasePath() == null) {
            this.getProtocolManager().removeFileManager((IVirtualFileManager)this);
        }
    }

    public IProject getProject() {
        if (this.baseContainer != null) {
            return this.baseContainer.getProject();
        }
        return null;
    }

    @Override
    public IVirtualFile[] getFiles(IVirtualFile file, boolean recurse, boolean includeCloakedFiles) {
        if (file instanceof ProjectFile) {
            ArrayList<IVirtualFile> list = new ArrayList<IVirtualFile>();
            IResource resource = ((ProjectFile)file).getResource();
            try {
                this.getFiles(resource, recurse, list, includeCloakedFiles);
            }
            catch (CoreException e) {
                IdeLog.logImportant((Plugin)FilePlugin.getDefault(), (String)"getFiles failed", (Throwable)e);
            }
            return list.toArray(new IVirtualFile[0]);
        }
        return super.getFiles(file, recurse, includeCloakedFiles);
    }

    @Override
    public boolean containsFile(IVirtualFile file) {
        if (file instanceof ProjectFile && this.baseContainer != null) {
            return this.baseContainer.getFullPath().isPrefixOf(((ProjectFile)file).getResource().getFullPath());
        }
        return super.containsFile(file);
    }

    @Override
    public IVirtualFile createVirtualDirectory(String pathString) {
        return this.createVirtualFile(pathString);
    }

    @Override
    public IVirtualFile createVirtualFile(String pathString) {
        Path path = new Path(pathString);
        if (Path.ROOT.equals((Object)path)) {
            return new ProjectFile(this, (IResource)workspaceRoot);
        }
        Object resource = null;
        File file = path.toFile();
        if (file.exists()) {
            try {
                resource = file.isDirectory() ? workspaceRoot.getContainerForLocation((IPath)path) : workspaceRoot.getFileForLocation((IPath)path);
            }
            catch (Exception exception) {}
        }
        if (resource == null) {
            try {
                resource = path.segmentCount() == 1 ? workspaceRoot.getProject(path.segment(0)) : workspaceRoot.findMember((IPath)path);
            }
            catch (Exception exception) {}
        }
        if (resource != null && resource.getLocation() != null) {
            return new ProjectFile(this, (IResource)resource);
        }
        IdeLog.logInfo((Plugin)FilePlugin.getDefault(), (String)("ProjectFileManager: failed to resolve path: " + pathString));
        return super.createVirtualFile(pathString);
    }

    @Override
    public IVirtualFile getBaseFile() {
        if (this.baseContainer != null && this.baseContainer.getLocation() != null) {
            return new ProjectFile(this, (IResource)this.baseContainer);
        }
        return super.getBaseFile();
    }

    private void getFiles(IResource resource, boolean recurse, List<IVirtualFile> list, boolean includeCloakedFiles) throws CoreException {
        block7: {
            this.fireGetFilesEvent(resource.getLocation().toOSString());
            if (!(resource instanceof IContainer)) break block7;
            IContainer container = (IContainer)resource;
            if (!container.isSynchronized(1)) {
                container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            IResource[] children = container.members();
            int i = 0;
            while (i < children.length) {
                block10: {
                    VirtualFile localFile;
                    IResource child;
                    block9: {
                        block8: {
                            child = children[i];
                            if (!CoreUIPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.core.ui.PREF_FILE_EXPLORER_SHOW_COMPRESSED") || !child.getName().endsWith(".zip") && !child.getName().endsWith(".jar") && !child.getName().endsWith(".gz")) break block8;
                            localFile = new CompressedFile(this, child.getLocation().toFile());
                            break block9;
                        }
                        if (child.getLocation() == null) break block10;
                        localFile = new ProjectFile(this, child);
                    }
                    boolean addingFile = false;
                    if (includeCloakedFiles || !localFile.isCloaked()) {
                        list.add((IVirtualFile)localFile);
                        addingFile = true;
                    }
                    if (recurse && child instanceof IContainer && addingFile) {
                        this.getFiles(child, recurse, list, includeCloakedFiles);
                    }
                }
                ++i;
            }
        }
    }
}

