/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.views.fileexplorer;

import com.aptana.ide.core.ui.views.fileexplorer.DrillFrame;
import com.aptana.ide.core.ui.views.fileexplorer.DrillStack;
import com.aptana.ide.core.ui.views.fileexplorer.Messages;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class DrillDownAdapter
implements ISelectionChangedListener {
    private TreeViewer fChildTree;
    private DrillStack fDrillStack = new DrillStack();
    private Action homeAction;
    private Action backAction;
    private Action forwardAction;
    static final String forwardActionString = Messages.DrillDownAdapter_BrowseFromHere;
    static final String backActionString = Messages.DrillDownAdapter_BrowseFromPrevious;
    static final String homeActionString = Messages.DrillDownAdapter_BrowseFromRoot;

    public DrillDownAdapter(TreeViewer tree) {
        this.fChildTree = tree;
    }

    public void addNavigationActions(IMenuManager manager) {
        this.createActions();
        manager.add((IAction)this.homeAction);
        manager.add((IAction)this.backAction);
        manager.add((IAction)this.forwardAction);
        this.updateNavigationButtons();
    }

    public void addNavigationActions(IToolBarManager toolBar) {
        this.createActions();
        toolBar.add((IAction)this.homeAction);
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        this.updateNavigationButtons();
    }

    public boolean canExpand(Object element) {
        return this.fChildTree.isExpandable(element);
    }

    public boolean canGoBack() {
        return this.fDrillStack.canGoBack();
    }

    public boolean canGoHome() {
        return this.fDrillStack.canGoHome();
    }

    public boolean canGoInto() {
        IStructuredSelection oSelection = (IStructuredSelection)this.fChildTree.getSelection();
        if (oSelection == null || oSelection.size() != 1) {
            return false;
        }
        Object anElement = oSelection.getFirstElement();
        return this.canExpand(anElement);
    }

    private void createActions() {
        if (this.homeAction != null) {
            return;
        }
        this.homeAction = new Action(homeActionString){

            public void run() {
                DrillDownAdapter.this.goHome();
            }
        };
        this.homeAction.setToolTipText(homeActionString);
        ImageDescriptor id = WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_HOME_NAV");
        if (id != null) {
            this.homeAction.setImageDescriptor(id);
        }
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.backAction = new Action(backActionString){

            public void run() {
                DrillDownAdapter.this.goBack();
            }
        };
        this.backAction.setToolTipText(backActionString);
        this.backAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
        this.backAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.forwardAction = new Action(forwardActionString){

            public void run() {
                DrillDownAdapter.this.goInto();
            }
        };
        this.forwardAction.setToolTipText(forwardActionString);
        this.forwardAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.forwardAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.fChildTree.addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateNavigationButtons();
    }

    private void expand(List items) {
        this.fChildTree.setExpandedElements(items.toArray());
    }

    private List getExpanded() {
        return Arrays.asList(this.fChildTree.getExpandedElements());
    }

    public void goBack() {
        Object currentInput = this.fChildTree.getInput();
        DrillFrame oFrame = this.fDrillStack.goBack();
        Object input = oFrame.getElement();
        this.fChildTree.setInput(input);
        this.expand(oFrame.getExpansion());
        if (this.fChildTree.getSelection().isEmpty()) {
            this.fChildTree.setSelection((ISelection)new StructuredSelection(currentInput), true);
        }
        this.updateNavigationButtons();
    }

    public void goHome() {
        Object currentInput = this.fChildTree.getInput();
        DrillFrame oFrame = this.fDrillStack.goHome();
        Object input = oFrame.getElement();
        this.fChildTree.setInput(input);
        this.expand(oFrame.getExpansion());
        if (this.fChildTree.getSelection().isEmpty()) {
            this.fChildTree.setSelection((ISelection)new StructuredSelection(currentInput), true);
        }
        this.updateNavigationButtons();
    }

    public void goInto() {
        IStructuredSelection sel = (IStructuredSelection)this.fChildTree.getSelection();
        Object element = sel.getFirstElement();
        this.goInto(element);
    }

    public void goInto(Object newInput) {
        if (this.canExpand(newInput)) {
            Object oldInput = this.fChildTree.getInput();
            List expandedList = this.getExpanded();
            this.fDrillStack.add(new DrillFrame(oldInput, "null", expandedList));
            this.fChildTree.setInput(newInput);
            this.expand(expandedList);
            this.updateNavigationButtons();
        }
    }

    public void reset() {
        this.fDrillStack.reset();
        this.updateNavigationButtons();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNavigationButtons();
    }

    protected void updateNavigationButtons() {
        if (this.homeAction != null) {
            this.homeAction.setEnabled(this.canGoHome());
            this.backAction.setEnabled(this.canGoBack());
            this.forwardAction.setEnabled(this.canGoInto());
        }
    }
}

