/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.views.fileexplorer;

import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.ProtocolManager;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.core.ui.views.fileexplorer.FileTreeContentProvider;
import com.aptana.ide.core.ui.views.fileexplorer.Messages;
import com.aptana.ide.io.file.FilePlugin;
import java.util.HashMap;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class FileLabelProvider
extends LabelProvider {
    private HashMap<IEditorDescriptor, Image> images = new HashMap();

    public void dispose() {
        super.dispose();
        for (Image image : this.images.values()) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
    }

    public String getText(Object element) {
        String retVal = null;
        if (element instanceof ProtocolManager) {
            ProtocolManager pm = (ProtocolManager)element;
            retVal = pm.getDisplayName();
        } else if (element instanceof IVirtualFileManager) {
            retVal = ((IVirtualFileManager)element).getDescriptiveLabel();
        } else if (element instanceof IVirtualFile) {
            IVirtualFile f = (IVirtualFile)element;
            retVal = f.getName();
        }
        if (element == FileTreeContentProvider.LOADING) {
            return "Loading...";
        }
        if (retVal == null) {
            retVal = Messages.FileExplorerView_UnknownElement;
        }
        return retVal;
    }

    public Image getImage(Object element) {
        IVirtualFile f;
        Image image = null;
        if (element instanceof ProtocolManager) {
            ProtocolManager pm = (ProtocolManager)element;
            image = pm.getImage();
        } else if (element instanceof IVirtualFileManager) {
            IVirtualFileManager fm = (IVirtualFileManager)element;
            image = fm.getImage();
        } else if (element instanceof IVirtualFile && (image = (f = (IVirtualFile)element).getImage()) == null) {
            IEditorDescriptor desc = EclipseUIUtils.getWorkbenchEditorRegistry().getDefaultEditor(f.getName());
            if (desc == null || desc.getImageDescriptor() == null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    ISharedImages sharedImages = workbench.getSharedImages();
                    if (f.isDirectory()) {
                        image = sharedImages.getImage("IMG_OBJ_FOLDER");
                    } else {
                        image = ImageUtils.getIcon(f.getExtension());
                        if (image == null) {
                            image = sharedImages.getImage("IMG_OBJ_FILE");
                        }
                    }
                }
            } else if (this.images.containsKey(desc)) {
                image = this.images.get(desc);
            } else {
                image = desc.getImageDescriptor().createImage();
                this.images.put(desc, image);
            }
        }
        if (element == FileTreeContentProvider.LOADING) {
            return FilePlugin.getImage("icons/hourglass.png");
        }
        return image;
    }
}

