/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.views.fileexplorer;

import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.ProtocolManager;
import com.aptana.ide.core.io.VirtualFileManagerGroup;
import com.aptana.ide.core.ui.io.file.LocalFile;
import com.aptana.ide.core.ui.io.file.LocalFileManager;
import com.aptana.ide.core.ui.views.fileexplorer.FileExplorerView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public class FileTreeContentProvider
implements ITreeContentProvider {
    private AbstractTreeViewer _viewer = null;
    private int id = 0;
    public static final Object LOADING = new Object();
    public static final Object[] LOADING_ELEMENT = new Object[]{LOADING};
    private HashMap<Object, Object[]> mappings = new HashMap();

    public FileTreeContentProvider(AbstractTreeViewer viewer, boolean canStart) {
        this._viewer = viewer;
    }

    public FileTreeContentProvider(AbstractTreeViewer viewer) {
        this(viewer, true);
    }

    public Object[] getChildren(final Object element) {
        final ReturnValue returnValue = new ReturnValue();
        if (element instanceof LocalFile || element instanceof LocalFileManager || element instanceof ProtocolManager || element instanceof VirtualFileManagerGroup || element instanceof Object[]) {
            this.getChildrenOfElement(element, returnValue);
        } else if (!this.mappings.containsKey(element)) {
            returnValue.value = LOADING_ELEMENT;
            String name = element.toString();
            if (element instanceof IVirtualFileManager) {
                name = ((IVirtualFileManager)element).getDescriptiveLabel();
            } else if (element instanceof IVirtualFile) {
                name = ((IVirtualFile)element).getName();
            }
            final int start = this.id;
            Job fetchJob = new Job("Fetching " + name){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        FileTreeContentProvider.this.getChildrenOfElement(element, returnValue);
                        if (start == FileTreeContentProvider.this.id && returnValue.value != LOADING_ELEMENT) {
                            FileTreeContentProvider.this.mappings.put(element, returnValue.value);
                            UIJob refresh = new UIJob("Refreshing tree"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    try {
                                        if (start == FileTreeContentProvider.this.id && FileTreeContentProvider.this._viewer != null && !FileTreeContentProvider.this._viewer.getControl().isDisposed()) {
                                            FileTreeContentProvider.this._viewer.refresh(element);
                                        }
                                    }
                                    catch (Exception exception) {
                                    }
                                    catch (Error error) {}
                                    return Status.OK_STATUS;
                                }
                            };
                            refresh.schedule();
                        }
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {}
                    return Status.OK_STATUS;
                }
            };
            fetchJob.schedule();
        } else {
            returnValue.value = this.mappings.remove(element);
        }
        return returnValue.value;
    }

    private void getChildrenOfElement(Object element, ReturnValue returnValue) {
        if (element instanceof Object[]) {
            returnValue.value = (Object[])element;
        } else if (element instanceof ProtocolManager) {
            ProtocolManager pm = (ProtocolManager)element;
            if (pm.hasCustomContent()) {
                returnValue.value = pm.getContent();
            } else {
                ArrayList<IVirtualFileManager> list = new ArrayList<IVirtualFileManager>();
                IVirtualFileManager[] managers = pm.getFileManagers();
                int i = 0;
                while (i < managers.length) {
                    IVirtualFileManager manager = managers[i];
                    if (!manager.isTransient()) {
                        list.add(manager);
                    }
                    ++i;
                }
                returnValue.value = list.toArray(new IVirtualFileManager[0]);
            }
        } else if (element instanceof VirtualFileManagerGroup) {
            VirtualFileManagerGroup group = (VirtualFileManagerGroup)element;
            returnValue.value = group.getFileManagers();
        } else if (element instanceof IVirtualFileManager) {
            final IVirtualFileManager fm = (IVirtualFileManager)element;
            IVirtualFile[] files = new IVirtualFile[]{};
            if (fm.getBasePath() == null) {
                final int start = this.id;
                UIJob collapseJob = new UIJob("Collapsing item"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (start == FileTreeContentProvider.this.id && FileTreeContentProvider.this._viewer != null && !FileTreeContentProvider.this._viewer.getControl().isDisposed()) {
                            FileTreeContentProvider.this._viewer.collapseToLevel((Object)fm, 0);
                        }
                        return Status.OK_STATUS;
                    }
                };
                collapseJob.schedule();
            } else {
                try {
                    files = FileExplorerView.getVirtualFilesProtected(fm.getBaseFile());
                }
                catch (IOException iOException) {
                    final int start = this.id;
                    UIJob collapseJob = new UIJob("Collapsing item"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (start == FileTreeContentProvider.this.id && FileTreeContentProvider.this._viewer != null && !FileTreeContentProvider.this._viewer.getControl().isDisposed()) {
                                FileTreeContentProvider.this._viewer.collapseToLevel((Object)fm, 0);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    collapseJob.schedule();
                }
            }
            returnValue.value = files;
        } else if (element instanceof IVirtualFile && ((IVirtualFile)element).hasFiles()) {
            final IVirtualFile f = (IVirtualFile)element;
            try {
                returnValue.value = FileExplorerView.getVirtualFilesProtected(f);
            }
            catch (IOException iOException) {
                final int start = this.id;
                UIJob collapseJob = new UIJob("Collapsing item"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (start == FileTreeContentProvider.this.id && FileTreeContentProvider.this._viewer != null && !FileTreeContentProvider.this._viewer.getControl().isDisposed()) {
                            FileTreeContentProvider.this.mappings.put(f, new Object[0]);
                            FileTreeContentProvider.this._viewer.refresh((Object)f);
                        }
                        return Status.OK_STATUS;
                    }
                };
                collapseJob.schedule();
            }
        } else if (element instanceof ITreeContentProvider) {
            returnValue.value = ((ITreeContentProvider)element).getChildren(element);
        }
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ProtocolManager) {
            ProtocolManager pm = (ProtocolManager)element;
            if (pm.hasCustomContent()) {
                return pm.getContent().length > 0;
            }
            return pm.getFileManagers().length > 0;
        }
        if (element instanceof VirtualFileManagerGroup) {
            VirtualFileManagerGroup group = (VirtualFileManagerGroup)element;
            return group.getFileManagers().length > 0;
        }
        if (element instanceof IVirtualFileManager) {
            return true;
        }
        if (element instanceof IVirtualFile) {
            IVirtualFile f = (IVirtualFile)element;
            return f.hasFiles();
        }
        if (element instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)element).hasChildren(element);
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            return ((File)element).getParent();
        }
        return null;
    }

    public void dispose() {
        ++this.id;
        this.mappings.clear();
    }

    public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
    }

    class ReturnValue {
        public Object[] value = new Object[0];

        ReturnValue() {
        }
    }
}

