/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.samples;

import com.aptana.ide.samples.SamplesManager;
import com.aptana.ide.samples.model.SamplesEntry;
import com.aptana.ide.samples.model.SamplesInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SamplesViewContentProvider
implements ITreeContentProvider {
    public static final String APTANA_PREFIX = "Aptana";
    public static final Object LOADING = new Object();

    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        if (parentElement instanceof SamplesInfo) {
            SamplesInfo info = (SamplesInfo)parentElement;
            result = info.getRootSamples().toArray();
        } else if (parentElement instanceof SamplesEntry) {
            result = ((SamplesEntry)parentElement).getSubEntries().toArray();
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element == LOADING) {
            return null;
        }
        if (element instanceof SamplesEntry) {
            return ((SamplesEntry)element).getParent();
        }
        if (element instanceof SamplesManager) {
            return null;
        }
        return SamplesManager.getInstance();
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof SamplesInfo) {
            result = !((SamplesInfo)element).getRootSamples().isEmpty();
        } else if (element instanceof SamplesEntry) {
            result = !((SamplesEntry)element).getSubEntries().isEmpty();
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        Object[] result;
        if (inputElement == LOADING) {
            return new Object[]{LOADING};
        }
        if (inputElement instanceof SamplesManager) {
            SamplesManager list = (SamplesManager)inputElement;
            result = list.getSamplesInfos();
            ArrayList<Object> infos = new ArrayList<Object>();
            int i = 0;
            while (i < result.length) {
                infos.add(result[i]);
                ++i;
            }
            Collections.sort(infos, new Comparator<SamplesInfo>(){

                @Override
                public int compare(SamplesInfo o1, SamplesInfo o2) {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    if (name1.startsWith(SamplesViewContentProvider.APTANA_PREFIX) && !name2.startsWith(SamplesViewContentProvider.APTANA_PREFIX)) {
                        return -1;
                    }
                    if (!name1.startsWith(SamplesViewContentProvider.APTANA_PREFIX) && name2.startsWith(SamplesViewContentProvider.APTANA_PREFIX)) {
                        return 1;
                    }
                    return name1.compareToIgnoreCase(name2);
                }
            });
            result = infos.toArray(new SamplesInfo[0]);
        } else {
            result = new SamplesInfo[]{};
        }
        return result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

