/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.xul;

import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.xul.XULPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.mozilla.interfaces.nsIConsoleListener;
import org.mozilla.interfaces.nsIConsoleMessage;
import org.mozilla.interfaces.nsIConsoleService;
import org.mozilla.interfaces.nsIScriptError;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;

public class FirefoxConsole
extends MessageConsole {
    private static FirefoxConsole console;

    public static FirefoxConsole getConsole() {
        if (console == null) {
            console = new FirefoxConsole("Firefox Preview Console", XULPlugin.getImageDescriptor("icons/firefox_icon.png"));
            console.addListener();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        }
        return console;
    }

    private FirefoxConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    private void addListener() {
        nsIConsoleService service = (nsIConsoleService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/consoleservice;1", "{a647f184-1dd1-11b2-a9d1-8537b201161b}");
        final MessageConsoleStream warningStream = this.newMessageStream();
        warningStream.setColor(UnifiedColorManager.getInstance().getColor(new RGB(143, 91, 0)));
        final MessageConsoleStream messageStream = this.newMessageStream();
        messageStream.setColor(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 255)));
        final MessageConsoleStream errorStream = this.newMessageStream();
        errorStream.setColor(UnifiedColorManager.getInstance().getColor(new RGB(255, 0, 0)));
        service.registerListener(new nsIConsoleListener(){

            public nsISupports queryInterface(String uuid) {
                return null;
            }

            public void observe(nsIConsoleMessage aMessage) {
                nsIScriptError error = (nsIScriptError)aMessage.queryInterface("{b0196fc7-1913-441a-882a-453c0d8b89b8}");
                if (error != null) {
                    MessageConsoleStream stream = null;
                    StringBuffer message = new StringBuffer("");
                    long flag = error.getFlags();
                    if (flag == 0L) {
                        message.append("Error:");
                        stream = errorStream;
                    } else if (flag == 1L) {
                        message.append("Warning:");
                        stream = warningStream;
                    } else if (flag == 2L) {
                        message.append("Exception:");
                        stream = errorStream;
                    } else {
                        message.append("Message:");
                        stream = messageStream;
                    }
                    message.append(" " + error.getErrorMessage());
                    message.append(" File: " + error.getSourceName());
                    message.append(" Line: " + error.getLineNumber());
                    message.append(" Column: " + error.getColumnNumber());
                    stream.println(message.toString());
                } else {
                    messageStream.println("Message: " + aMessage.getMessage());
                }
            }
        });
    }
}

