/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.xul;

import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.ContributedOutline;
import com.aptana.ide.xul.DOMContentProvider;
import com.aptana.ide.xul.DOMLabelProvider;
import com.aptana.ide.xul.FirefoxBrowser;
import com.aptana.ide.xul.InternalNodeFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;

public class FirefoxOutline
extends ContributedOutline {
    private TreeViewer treeViewer;
    private FirefoxBrowser browser;
    private WorkbenchJob refreshJob;
    private PatternFilter filter;
    private String pattern;

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 772);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.getTree().setLayout((Layout)new GridLayout(1, true));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DOMLabelProvider());
        this.treeViewer.setAutoExpandLevel(3);
        this.treeViewer.setContentProvider((IContentProvider)new DOMContentProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    nsIDOMNode node = (nsIDOMNode)selection.getFirstElement();
                    FirefoxOutline.this.browser.highlightElement(node);
                }
            }
        });
        this.treeViewer.addFilter((ViewerFilter)new InternalNodeFilter());
        this.filter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                if (element instanceof nsIDOMNode) {
                    nsIDOMElement e;
                    if (((nsIDOMNode)element).getNodeType() == 1 && "_____INTERNAL".equals((e = (nsIDOMElement)((nsIDOMNode)element).queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute("class"))) {
                        return false;
                    }
                    DOMLabelProvider prov = (DOMLabelProvider)FirefoxOutline.this.treeViewer.getLabelProvider();
                    return this.wordMatches(prov.getText(element));
                }
                return true;
            }
        };
        this.treeViewer.addFilter((ViewerFilter)this.filter);
        this.refreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (FirefoxOutline.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (FirefoxOutline.this.pattern == null) {
                    return Status.OK_STATUS;
                }
                FirefoxOutline.this.filter.setPattern(FirefoxOutline.this.pattern);
                try {
                    FirefoxOutline.this.treeViewer.getControl().setRedraw(false);
                    FirefoxOutline.this.treeViewer.refresh(true);
                    if (FirefoxOutline.this.pattern.length() > 0) {
                        IStructuredContentProvider provider = (IStructuredContentProvider)FirefoxOutline.this.treeViewer.getContentProvider();
                        Object[] elements = provider.getElements(FirefoxOutline.this.treeViewer.getInput());
                        int i = 0;
                        while (i < elements.length) {
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            FirefoxOutline.this.treeViewer.expandToLevel(elements[i], -1);
                            ++i;
                        }
                        TreeItem[] items = FirefoxOutline.this.treeViewer.getTree().getItems();
                        if (items.length > 0) {
                            FirefoxOutline.this.treeViewer.getTree().showItem(items[0]);
                        }
                    }
                }
                finally {
                    FirefoxOutline.this.treeViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        TreeItem item = new TreeItem(this.treeViewer.getTree(), 0);
        item.setText("Select the Firefox tab to load the outline");
        this.refreshJob.setSystem(true);
        this.refresh();
    }

    public void setBrowser(ContributedBrowser browser) {
        this.browser = (FirefoxBrowser)browser;
    }

    public void refresh() {
        if (this.treeViewer != null && this.browser != null && this.browser.getDocument() != null) {
            this.treeViewer.setInput((Object)this.browser.getDocument());
        }
    }

    public Composite getParent() {
        return this.treeViewer.getControl().getParent();
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public void setFilterText(String text) {
        this.pattern = text;
        this.filter.setPattern(text);
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }
}

