/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.text;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.core.ui.editors.ISaveAsEvent;
import com.aptana.ide.core.ui.editors.ISaveEvent;
import com.aptana.ide.editor.text.Messages;
import com.aptana.ide.editor.text.TextPlugin;
import com.aptana.ide.editors.formatting.IUnifiedBracketInserter;
import com.aptana.ide.editors.formatting.UnifiedBracketInserter;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.BaseContributor;
import com.aptana.ide.editors.unified.BaseDocumentProvider;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.BaseFileServiceFactory;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.editors.unified.UnifiedAutoIndentStrategy;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedReconcilingStrategy;
import com.aptana.ide.editors.unified.colorizer.ColorizerReader;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.editors.unified.errors.UnifiedErrorManager;
import com.aptana.ide.editors.unified.parsing.UnifiedParser;
import com.aptana.ide.lexer.ILexerBuilder;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.views.outline.UnifiedOutlinePage;
import com.aptana.ide.views.outline.UnifiedQuickOutlinePage;
import com.aptana.sax.AttributeSniffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.xml.sax.SAXException;

public class GenericTextEditor
extends EditorPart
implements ITextEditor,
ITextEditorExtension,
IUnifiedEditor {
    public static final String ID = "com.aptana.ide.editor.text";
    public static final String PLAIN_MIME_TYPE = "text/plain";
    private UnifiedEditor editor;
    private BaseContributor contributor;
    private IFileServiceFactory fileService;
    private BaseDocumentProvider documentProvider;
    private IParser parser;
    private File grammarFile;
    private Job grammarFileMonitor;
    private String language;
    private String extension;
    private Shell shell;

    public void doSave(IProgressMonitor monitor) {
        if (this.editor != null) {
            this.editor.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.editor != null) {
            this.editor.doSaveAs();
        }
    }

    public IWorkbenchPartSite getSite() {
        return this.editor != null ? this.editor.getSite() : null;
    }

    public IEditorInput getEditorInput() {
        return this.editor != null ? this.editor.getEditorInput() : null;
    }

    public String getPartName() {
        return this.editor != null ? this.editor.getPartName() : "";
    }

    public IEditorSite getEditorSite() {
        return this.editor != null ? this.editor.getEditorSite() : null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        block35: {
            IPath path;
            String fileName = input.getName();
            String ext = FileUtils.getExtension((String)fileName);
            if ((ext == null || ext.length() == 0) && input instanceof NonExistingFileEditorInput && (path = ((NonExistingFileEditorInput)input).getPath((Object)input)) != null) {
                fileName = path.lastSegment();
                ext = FileUtils.getExtension((String)fileName);
            }
            IPreferenceStore store = TextPlugin.getDefault().getPreferenceStore();
            IEditorRegistry registry = EclipseUIUtils.getWorkbenchEditorRegistry();
            IFileEditorMapping[] mappings = registry.getFileEditorMappings();
            IFileEditorMapping candidate = null;
            int i = 0;
            while (i < mappings.length) {
                if (mappings[i].getLabel().equals(fileName)) {
                    candidate = mappings[i];
                    break;
                }
                if (mappings[i].getExtension().equals(ext)) {
                    candidate = mappings[i];
                }
                ++i;
            }
            if (candidate != null) {
                String label = candidate.getLabel();
                String grammarFilePath = store.getString(TextPlugin.getGrammarPreference(label));
                String colorizerPath = TextPlugin.getColorizerPreference(label);
                this.extension = ext;
                TokenList tokenList = LanguageRegistry.getTokenListByExtension((String)this.extension);
                if (tokenList != null) {
                    this.language = tokenList.getLanguage();
                    try {
                        if (LanguageRegistry.hasParser((String)this.language)) {
                            this.parser = LanguageRegistry.getParser((String)this.language);
                        }
                        this.parser = new UnifiedParser(this.language);
                    }
                    catch (ParserInitializationException e) {
                        throw new PartInitException(e.getMessage());
                    }
                } else {
                    this.grammarFile = new File(grammarFilePath);
                }
                FileInputStream stream = null;
                try {
                    try {
                        if (this.grammarFile != null && this.grammarFile.exists() && this.grammarFile.isFile() && this.grammarFile.canRead()) {
                            if (this.language == null) {
                                AttributeSniffer sniffer = new AttributeSniffer("lexer", "language");
                                sniffer.read(grammarFilePath);
                                if (sniffer.getMatchedValue() != null) {
                                    this.language = sniffer.getMatchedValue();
                                } else {
                                    throw new PartInitException(Messages.GenericTextEditor_No_Language_Defined);
                                }
                            }
                            if (this.parser == null) {
                                this.parser = this.createParser();
                            }
                        }
                        if (this.language != null) {
                            ColorizerReader reader = new ColorizerReader();
                            if (LanguageRegistry.hasLanguageColorizer((String)this.language)) {
                                LanguageRegistry.getLanguageColorizer((String)this.language);
                            } else {
                                reader.loadColorization(colorizerPath, true);
                            }
                        } else {
                            this.language = PLAIN_MIME_TYPE;
                            final TokenList list = new TokenList(this.language);
                            this.parser = new UnifiedParser(this.language){

                                public void addLexerGrammar(ILexerBuilder builder) throws LexerException {
                                    builder.addTokenList((ITokenList)list);
                                }
                            };
                        }
                        if (this.parser != null) {
                            this.createFileServiceFactory();
                        }
                        this.contributor = this.createContributor();
                        this.documentProvider = new GenericDocumentProvider();
                        this.createEditor();
                        this.editor.init(site, input);
                        if (this.grammarFile != null && this.grammarFile.exists()) {
                            this.createGrammarFileMonitor();
                        }
                        break block35;
                    }
                    catch (ParserInitializationException e) {
                        e.printStackTrace();
                        throw new PartInitException(e.getMessage());
                    }
                    catch (FileNotFoundException e) {
                        throw new PartInitException(e.getMessage());
                    }
                    catch (IOException e) {
                        throw new PartInitException(e.getMessage());
                    }
                    catch (ParserConfigurationException e) {
                        throw new PartInitException(e.getMessage());
                    }
                    catch (SAXException e) {
                        throw new PartInitException(e.getMessage());
                    }
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            throw new PartInitException(Messages.GenericTextEditor_ERROR_RETRIEVING_ASSOCIATION);
        }
    }

    private void createGrammarFileMonitor() {
        this.grammarFileMonitor = new Job(Messages.GenericTextEditor_MONITOR_GRAMMAR_FILE){
            private long stamp;
            {
                this.stamp = GenericTextEditor.this.grammarFile.lastModified();
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (this.stamp < GenericTextEditor.this.grammarFile.lastModified()) {
                    this.stamp = GenericTextEditor.this.grammarFile.lastModified();
                    TokenList oldList = LanguageRegistry.getTokenList((String)GenericTextEditor.this.language);
                    if (oldList != null) {
                        LanguageRegistry.unregisterTokenList((TokenList)oldList);
                    }
                    try {
                        IParser newParser = GenericTextEditor.this.createParser();
                        FileService context = FileContextManager.get((IEditorInput)GenericTextEditor.this.getEditorInput());
                        GenericTextEditor.this.parser = newParser;
                        context.setParser(GenericTextEditor.this.parser);
                        GenericTextEditor.this.editor.getFileContext().setFileContext((IFileService)context);
                        context.doFullParse();
                        UIJob refreshEditor = new UIJob(Messages.GenericTextEditor_REFRESHING_LEXER){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                GenericTextEditor.this.editor.getViewer().getTextWidget().redraw();
                                GenericTextEditor.this.editor.getViewer().getTextWidget().update();
                                return Status.OK_STATUS;
                            }
                        };
                        refreshEditor.schedule();
                    }
                    catch (Exception exception) {
                        if (oldList != null) {
                            LanguageRegistry.registerTokenList((TokenList)oldList);
                        }
                        UIJob errorJob = new UIJob(Messages.GenericTextEditor_ERROR_PARSING_LEXER){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                MessageDialog.openError((Shell)GenericTextEditor.this.shell, (String)Messages.GenericTextEditor_ERROR_PARSING_LEXER, (String)Messages.GenericTextEditor_ERROR_OCCURED_DURING_PARSE_LEXER);
                                return Status.OK_STATUS;
                            }
                        };
                        errorJob.schedule();
                    }
                }
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
        };
        this.grammarFileMonitor.setSystem(true);
        this.grammarFileMonitor.schedule(1000L);
    }

    private void createEditor() {
        this.editor = new UnifiedEditor(){

            public IFileServiceFactory getFileServiceFactory() {
                return GenericTextEditor.this.fileService;
            }

            public String getDefaultFileExtension() {
                return GenericTextEditor.this.extension;
            }

            protected IUnifiedEditorContributor createLocalContributor() {
                return GenericTextEditor.this.contributor;
            }

            public IDocumentProvider createDocumentProvider() {
                return GenericTextEditor.this.documentProvider;
            }

            protected String[] collectContextMenuPreferencePages() {
                return GenericTextEditor.this.collectContextMenuPreferencePages();
            }
        };
        this.editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                GenericTextEditor.this.firePropertyChange(propId);
            }
        });
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"com.aptana.ide.editor.text.preferences.TextEditorPreferencePage", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage"};
    }

    protected BaseContributor createContributor() {
        return new BaseContributor(this.language){

            public IAutoEditStrategy[] getLocalAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
                return new IAutoEditStrategy[]{new UnifiedAutoIndentStrategy(this.getFileContext(), this.getParentConfiguration(), sourceViewer){

                    protected LexemeList getLexemeList() {
                        return this.getFileContext().getLexemeList();
                    }

                    public IPreferenceStore getPreferenceStore() {
                        return TextPlugin.getDefault().getPreferenceStore();
                    }
                }};
            }

            public IUnifiedBracketInserter getLocalBracketInserter(ISourceViewer sourceViewer, String contentType) {
                EditorFileContext context = this.getFileContext();
                UnifiedBracketInserter result = null;
                if (context != null) {
                    result = new UnifiedBracketInserter(sourceViewer, (IFileService)context){

                        protected IPreferenceStore getPreferenceStore() {
                            return TextPlugin.getDefault().getPreferenceStore();
                        }
                    };
                }
                return result;
            }

            public UnifiedReconcilingStrategy getReconcilingStrategy() {
                return new UnifiedReconcilingStrategy();
            }
        };
    }

    private IParser createParser() throws ParserInitializationException, FileNotFoundException {
        FileInputStream stream = new FileInputStream(this.grammarFile);
        TokenList tokenList = LanguageRegistry.createTokenList((InputStream)stream);
        if (tokenList != null) {
            LanguageRegistry.registerTokenList((TokenList)tokenList);
        }
        Object result = LanguageRegistry.hasParser((String)this.language) ? LanguageRegistry.getParser((String)this.language) : new UnifiedParser(this.language);
        return result;
    }

    private void createFileServiceFactory() {
        this.fileService = new GenericTextFileServiceFactory();
    }

    public boolean isDirty() {
        return this.editor != null ? this.editor.isDirty() : false;
    }

    public boolean isSaveAsAllowed() {
        return this.editor != null ? this.editor.isSaveAsAllowed() : false;
    }

    public void createPartControl(Composite parent) {
        this.editor.createPartControl(parent);
        this.shell = parent.getShell();
    }

    public void dispose() {
        super.dispose();
        if (this.grammarFileMonitor != null) {
            this.grammarFileMonitor.cancel();
        }
        this.editor.dispose();
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.setFocus();
        }
    }

    public void close(boolean save) {
        if (this.editor != null) {
            this.editor.close(save);
        }
    }

    public IContextAwareness getContextAwareness() {
        return this.editor != null ? this.editor.getContextAwareness() : null;
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public EditorFileContext getFileContext() {
        return this.editor != null ? this.editor.getFileContext() : null;
    }

    public UnifiedOutlinePage getOutlinePage() {
        return this.editor != null ? this.editor.getOutlinePage() : null;
    }

    public UnifiedQuickOutlinePage createQuickOutlinePage() {
        return this.editor != null ? this.editor.createQuickOutlinePage() : null;
    }

    public PairMatch getPairMatch(int offset) {
        return this.editor != null ? this.editor.getPairMatch(offset) : null;
    }

    public String getParentDirectoryHint() {
        return this.editor != null ? this.editor.getParentDirectoryHint() : null;
    }

    public void selectAndReveal(int offset, int length) {
        if (this.editor != null) {
            this.editor.selectAndReveal(offset, length);
        }
    }

    public void setParentDirectoryHint(String hint) {
        if (this.editor != null) {
            this.editor.setParentDirectoryHint(hint);
        }
    }

    public void showWhitespace(boolean state) {
        if (this.editor != null) {
            this.editor.showWhitespace(state);
        }
    }

    public void doRevertToSaved() {
        if (this.editor != null) {
            this.editor.doRevertToSaved();
        }
    }

    public IAction getAction(String actionId) {
        return this.editor != null ? this.editor.getAction(actionId) : null;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.editor != null ? this.editor.getDocumentProvider() : null;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.editor != null ? this.editor.getSelectionProvider() : null;
    }

    public boolean isEditable() {
        return this.editor != null ? this.editor.isEditable() : false;
    }

    public void removeActionActivationCode(String actionId) {
        if (this.editor != null) {
            this.editor.removeActionActivationCode(actionId);
        }
    }

    public void resetHighlightRange() {
        if (this.editor != null) {
            this.editor.resetHighlightRange();
        }
    }

    public void setAction(String actionID, IAction action) {
        if (this.editor != null) {
            this.editor.setAction(actionID, action);
        }
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        if (this.editor != null) {
            this.editor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
        }
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        if (this.editor != null) {
            this.editor.setHighlightRange(offset, length, moveCursor);
        }
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        if (this.editor != null) {
            this.editor.showHighlightRangeOnly(showHighlightRangeOnly);
        }
    }

    public boolean showsHighlightRangeOnly() {
        return this.editor != null ? this.editor.showsHighlightRangeOnly() : false;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.editor != null) {
            this.editor.addRulerContextMenuListener(listener);
        }
    }

    public boolean isEditorInputReadOnly() {
        return this.editor != null ? this.editor.isEditorInputReadOnly() : false;
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.editor != null) {
            this.editor.removeRulerContextMenuListener(listener);
        }
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.editor != null) {
            this.editor.setStatusField(field, category);
        }
    }

    public void addSaveAsListener(ISaveAsEvent listener) {
        if (this.editor != null) {
            this.editor.addSaveAsListener(listener);
        }
    }

    public void addSaveListener(ISaveEvent listener) {
        if (this.editor != null) {
            this.editor.addSaveListener(listener);
        }
    }

    public void removeSaveAsListener(ISaveAsEvent listener) {
        if (this.editor != null) {
            this.editor.removeSaveAsListener(listener);
        }
    }

    public void removeSaveListener(ISaveEvent listener) {
        if (this.editor != null) {
            this.editor.removeSaveListener(listener);
        }
    }

    public IRegion getHighlightRange() {
        return this.editor != null ? this.editor.getHighlightRange() : null;
    }

    public SourceViewerConfiguration getConfiguration() {
        return this.editor != null ? this.editor.getConfiguration() : null;
    }

    public ISourceViewer getViewer() {
        return this.editor != null ? this.editor.getViewer() : null;
    }

    public Object getAdapter(Class adapter) {
        return this.editor != null ? this.editor.getAdapter(adapter) : null;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.editor != null ? this.editor.isSaveOnCloseNeeded() : false;
    }

    public String getTitleToolTip() {
        return this.editor != null ? this.editor.getTitleToolTip() : "";
    }

    public String getContentDescription() {
        return this.editor != null ? this.editor.getContentDescription() : "";
    }

    public int getOrientation() {
        return this.editor != null ? this.editor.getOrientation() : 0;
    }

    public String getTitle() {
        return this.editor != null ? this.editor.getTitle() : "";
    }

    public Image getTitleImage() {
        return this.editor != null ? this.editor.getTitleImage() : null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (this.editor != null) {
            this.editor.setInitializationData(config, propertyName, data);
        }
    }

    public void showBusy(boolean busy) {
        if (this.editor != null) {
            this.editor.showBusy(busy);
        }
    }

    public IUnifiedEditorContributor getBaseContributor() {
        return this.editor.getBaseContributor();
    }

    public String getDefaultFileExtension() {
        return this.editor.getDefaultFileExtension();
    }

    public void addFileServiceChangeListener(IFileServiceChangeListener listener) {
        if (this.editor != null) {
            this.editor.addFileServiceChangeListener(listener);
        }
    }

    public void removeFileServiceChangeListener(IFileServiceChangeListener listener) {
        if (this.editor != null) {
            this.editor.removeFileServiceChangeListener(listener);
        }
    }

    public void showPianoKeys(boolean state) {
        if (this.editor != null) {
            this.editor.showPianoKeys(state);
        }
    }

    private class GenericDocumentProvider
    extends BaseDocumentProvider {
        public TextFileDocumentProvider.FileInfo getFileInfoPublic(Object element) {
            return this.getFileInfo(element);
        }

        protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
            return new GenericFileInfo();
        }

        public IAnnotationModel getAnnotationModel(Object element) {
            TextFileDocumentProvider.FileInfo fileInfo;
            IAnnotationModel annotationModel = super.getAnnotationModel(element);
            if (annotationModel == null && (fileInfo = this.getFileInfo(element)) != null) {
                annotationModel = fileInfo.fModel;
            }
            return annotationModel;
        }

        protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
            TextFileDocumentProvider.FileInfo info;
            block8: {
                if (!(element instanceof IEditorInput)) {
                    return null;
                }
                try {
                    info = super.createFileInfo(element);
                    if (info instanceof GenericFileInfo) break block8;
                    return null;
                }
                catch (RuntimeException ex) {
                    IdeLog.logError((Plugin)TextPlugin.getDefault(), (String)Messages.GenericTextEditor_ERROR, (Throwable)ex);
                    return null;
                }
            }
            GenericFileInfo cuInfo = (GenericFileInfo)info;
            if (element instanceof IAdaptable) {
                if (cuInfo.fTextFileBuffer.getAnnotationModel() == null) {
                    IUniformResource uniformResource = (IUniformResource)((IAdaptable)element).getAdapter(IUniformResource.class);
                    if (uniformResource == null) {
                        cuInfo.fModel = new AnnotationModel();
                    }
                } else {
                    cuInfo.fModel = cuInfo.fTextFileBuffer.getAnnotationModel();
                }
            }
            return info;
        }

        public void disconnect(Object element) {
            String uri;
            IFileSourceProvider sourceProvider;
            GenericFileInfo cuInfo = (GenericFileInfo)this.getFileInfo(element);
            if (cuInfo != null && cuInfo.fCount == 1 && (sourceProvider = cuInfo.sourceProvider) != null && (uri = sourceProvider.getSourceURI()) != null) {
                FileContextManager.disconnectSourceProvider((String)uri, (IFileSourceProvider)cuInfo.sourceProvider);
            }
            try {
                super.disconnect(element);
            }
            catch (RuntimeException ex) {
                IdeLog.logError((Plugin)TextPlugin.getDefault(), (String)Messages.GenericTextEditor_ERROR, (Throwable)ex);
            }
        }

        public void connect(Object element) throws CoreException {
            super.connect(element);
        }

        protected class GenericFileInfo
        extends TextFileDocumentProvider.FileInfo {
            public IFileSourceProvider sourceProvider;

            protected GenericFileInfo() {
            }
        }
    }

    private class GenericTextFileServiceFactory
    extends BaseFileServiceFactory {
        private GenericTextFileServiceFactory() {
        }

        public FileService createFileService(IFileSourceProvider sourceProvider) {
            return this.createFileService(sourceProvider, true);
        }

        public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
            IParseState parseState = GenericTextEditor.this.parser.createParseState(null);
            FileService fileService = new FileService(GenericTextEditor.this.parser, parseState, sourceProvider, GenericTextEditor.this.language);
            ParentOffsetMapper parentMapper = new ParentOffsetMapper(fileService);
            BaseFileLanguageService languageService = new BaseFileLanguageService(fileService, parseState, GenericTextEditor.this.parser, (IParentOffsetMapper)parentMapper);
            fileService.setErrorManager((IErrorManager)new UnifiedErrorManager(fileService, GenericTextEditor.this.language));
            fileService.addLanguageService(GenericTextEditor.this.language, (IFileLanguageService)languageService);
            if (parse) {
                fileService.doFullParse();
            }
            return fileService;
        }
    }
}

