/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jam;

import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.servers.AbstractExternalServer;
import com.aptana.ide.server.internal.ApacheServer;
import com.aptana.ide.server.internal.MySqlServer;
import java.util.Properties;

public class JAMServer
extends AbstractExternalServer {
    private ApacheServer apacheServer;
    private MySqlServer mySqlServer;
    private JaxerServer jServer;

    public JAMServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
    }

    protected void installConfig(IAbstractConfiguration configuration) {
        super.installConfig(configuration);
        IAbstractConfiguration apacheConfiguration = configuration.getSubConfiguration("apache");
        IAbstractConfiguration sqlConfiguration = configuration.getSubConfiguration("mysql");
        IAbstractConfiguration jaxerConfiguration = configuration.getSubConfiguration("jaxer");
        this.apacheServer = new ApacheServer(ServerCore.getServerManager().getServerType("com.aptana.ide.server.apache"), apacheConfiguration);
        this.mySqlServer = new MySqlServer(ServerCore.getServerManager().getServerType("com.aptana.ide.server.mysql"), sqlConfiguration);
        this.jServer = new JaxerServer(ServerCore.getServerManager().getServerType("com.aptana.ide.server.jaxer.jaxerHttpServer"), jaxerConfiguration);
    }

    public void storeConfiguration(IAbstractConfiguration configuration) {
        super.storeConfiguration(configuration);
        IAbstractConfiguration apacheConfiguration = configuration.createSubConfiguration("apache");
        IAbstractConfiguration sqlConfiguration = configuration.createSubConfiguration("mysql");
        IAbstractConfiguration jaxerConfiguration = configuration.createSubConfiguration("jaxer");
        this.apacheServer.storeConfiguration(apacheConfiguration);
        this.mySqlServer.storeConfiguration(sqlConfiguration);
        this.jServer.storeConfiguration(jaxerConfiguration);
    }

    protected Properties loadProperties() {
        return this.apacheServer.getProperties();
    }

    public String getConfigurationDescription() {
        return "JAM Server";
    }

    public String getHost() {
        return this.apacheServer.getHost();
    }

    public String getHostname() {
        return this.apacheServer.getHostname();
    }

    public ApacheServer getApacheServer() {
        return this.apacheServer;
    }

    public MySqlServer getMySqlServer() {
        return this.mySqlServer;
    }

    public JaxerServer getJaxerServer() {
        return this.jServer;
    }

    public int getPort() {
        return 0;
    }
}

