/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.samples.SamplesView;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.jetty.comet.CometClient;
import com.aptana.ide.server.ui.views.actions.NewServerAction;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class JaxerClient
extends CometClient {
    public static final String JAXER_CHANNEL = "/portal/jaxer";
    public static final String SHOW_PACKAGE_SERVER = "showPackageServer";
    public static final String SHOW_SAMPLES = "showSamples";
    public static final String EDIT_CONFIG = "editConfig";
    public static final String FILE = "file";

    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }

    protected Object getResponse(String toChannel, Object request) {
        Map requestData;
        if (JAXER_CHANNEL.equals(toChannel) && request instanceof Map && (requestData = (Map)request).containsKey("request")) {
            final String requestType = requestData.get("request").toString();
            UIJob job = new UIJob("Running Jaxer action"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IServer jaxer;
                    if (JaxerClient.SHOW_PACKAGE_SERVER.equals(requestType)) {
                        IServerType type = ServerManager.getInstance().getServerType("com.aptana.ide.framework.jaxer.jamFakeType");
                        NewServerAction action = new NewServerAction(type);
                        action.run();
                    } else if (JaxerClient.SHOW_SAMPLES.equals(requestType)) {
                        try {
                            IViewPart part = CoreUIUtils.showView((String)"com.aptana.ide.samples.SamplesView");
                            if (part != null && part instanceof SamplesView) {
                                ((SamplesView)part).selectAndReveal("Aptana Jaxer Samples");
                            }
                        }
                        catch (PartInitException partInitException) {}
                    } else if (JaxerClient.EDIT_CONFIG.equals(requestType) && requestData.containsKey(JaxerClient.FILE) && (jaxer = ServerManager.getInstance().findServer("jaxerInternalServer")) != null && jaxer instanceof JaxerServer) {
                        JaxerServer jaxerServer = (JaxerServer)jaxer;
                        String file = requestData.get(JaxerClient.FILE).toString();
                        if (file != null) {
                            String filePath = null;
                            if ("config.js".equals(file)) {
                                filePath = jaxerServer.getConfigFile();
                            } else if ("configLog.js".equals(file)) {
                                filePath = jaxerServer.getConfigLogFile();
                            } else if ("configApps.js".equals(file)) {
                                filePath = jaxerServer.getConfigRoutesFile();
                            }
                            if (filePath != null) {
                                File config = new File(filePath);
                                IEditorInput input = CoreUIUtils.createJavaFileEditorInput((File)config);
                                IWorkbench workbench = JaxerPlugin.getDefault().getWorkbench();
                                IEditorRegistry editorRegistry = workbench.getEditorRegistry();
                                IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(config.getName());
                                if (descriptor == null) {
                                    descriptor = editorRegistry.getDefaultEditor("test.txt");
                                }
                                if (descriptor != null) {
                                    try {
                                        IDE.openEditor((IWorkbenchPage)workbench.getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)descriptor.getId());
                                    }
                                    catch (PartInitException e) {
                                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)StringUtils.format((String)"Error opening {0}", (String)filePath), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{JAXER_CHANNEL};
    }
}

