/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerListener;
import com.aptana.ide.server.core.ServerEvent;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class StartStopJaxerServerAction
implements IWorkbenchWindowActionDelegate {
    private JaxerServer server;
    private IAction action;
    private IServerListener listener = new IServerListener(){

        public void serverChanged(ServerEvent event) {
            StartStopJaxerServerAction.this.updateState();
        }
    };

    public void dispose() {
        if (this.server != null) {
            this.server.removeServerListener(this.listener);
        }
        this.listener = null;
        this.server = null;
    }

    public void init(IWorkbenchWindow window) {
        IServer jaxer = ServerManager.getInstance().findServer("jaxerInternalServer");
        if (jaxer != null && jaxer instanceof JaxerServer) {
            this.server = (JaxerServer)jaxer;
            this.server.addServerListener(this.listener);
        }
    }

    public void run(IAction action) {
        this.action = action;
        if (this.server != null) {
            int state = this.server.getServerState();
            if (state != 4) {
                this.server.stop(true, null, null);
            } else {
                this.server.start("run", null, null);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        this.updateState();
    }

    private void updateState() {
        if (this.action != null && this.server != null) {
            int state = this.server.getServerState();
            if (state != 4) {
                this.action.setText("Stop Internal Jaxer Server");
                this.action.setImageDescriptor(JaxerPlugin.getImageDescriptor("icons/stop.gif"));
            } else {
                this.action.setText("Start Jaxer Server");
                this.action.setImageDescriptor(JaxerPlugin.getImageDescriptor("icons/start.gif"));
            }
        }
    }
}

